/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class FloatBinding
extends TupleBinding {
    private static final int FLOAT_SIZE = 4;

    public Object entryToObject(TupleInput tupleInput) {
        return new Float(tupleInput.readFloat());
    }

    public void objectToEntry(Object object, TupleOutput tupleOutput) {
        tupleOutput.writeFloat(((Number)object).floatValue());
    }

    protected TupleOutput getTupleOutput(Object object) {
        return FloatBinding.sizedOutput();
    }

    public static float entryToFloat(DatabaseEntry databaseEntry) {
        return FloatBinding.entryToInput(databaseEntry).readFloat();
    }

    public static void floatToEntry(float f, DatabaseEntry databaseEntry) {
        FloatBinding.outputToEntry(FloatBinding.sizedOutput().writeFloat(f), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[4]);
    }
}

