/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.DataView;
import com.sleepycat.collections.KeyRange;
import com.sleepycat.collections.RangeCursor;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.JoinCursor;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;

final class DataCursor
implements Cloneable {
    private RangeCursor cursor;
    private JoinCursor joinCursor;
    private DataView view;
    private KeyRange range;
    private boolean writeAllowed;
    private boolean readUncommitted;
    private DatabaseEntry keyThang;
    private DatabaseEntry valueThang;
    private DatabaseEntry primaryKeyThang;
    private DatabaseEntry otherThang;
    private DataCursor[] indexCursorsToClose;

    DataCursor(DataView dataView, boolean bl) throws DatabaseException {
        this.init(dataView, bl, null);
    }

    DataCursor(DataView dataView, boolean bl, Object object) throws DatabaseException {
        this.init(dataView, bl, dataView.subRange(object));
    }

    DataCursor(DataView dataView, boolean bl, Object object, boolean bl2, Object object2, boolean bl3) throws DatabaseException {
        this.init(dataView, bl, dataView.subRange(object, bl2, object2, bl3));
    }

    DataCursor(DataView dataView, DataCursor[] dataCursorArray, JoinConfig joinConfig, boolean bl) throws DatabaseException {
        if (dataView.isSecondary()) {
            throw new IllegalArgumentException("The primary collection in a join must not be a secondary database");
        }
        Cursor[] cursorArray = new Cursor[dataCursorArray.length];
        int n = 0;
        while (n < cursorArray.length) {
            cursorArray[n] = dataCursorArray[n].cursor.getCursor();
            ++n;
        }
        this.joinCursor = dataView.db.join(cursorArray, joinConfig);
        this.init(dataView, false, null);
        if (bl) {
            this.indexCursorsToClose = dataCursorArray;
        }
    }

    DataCursor cloneCursor() throws DatabaseException {
        DataCursor dataCursor;
        this.checkNoJoinCursor();
        try {
            dataCursor = (DataCursor)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        dataCursor.initThangs();
        KeyRange.copy(this.keyThang, dataCursor.keyThang);
        KeyRange.copy(this.valueThang, dataCursor.valueThang);
        if (this.primaryKeyThang != this.keyThang) {
            KeyRange.copy(this.primaryKeyThang, dataCursor.primaryKeyThang);
        }
        dataCursor.cursor = this.cursor.dup(true);
        return dataCursor;
    }

    RangeCursor getCursor() {
        return this.cursor;
    }

    private void init(DataView dataView, boolean bl, KeyRange keyRange) throws DatabaseException {
        this.view = dataView;
        this.writeAllowed = bl && dataView.writeAllowed;
        this.range = keyRange != null ? keyRange : dataView.range;
        this.readUncommitted = dataView.cursorConfig.getReadUncommitted() || dataView.currentTxn.isReadUncommitted();
        this.initThangs();
        if (this.joinCursor == null) {
            this.cursor = new RangeCursor(dataView, this.range, this.writeAllowed);
        }
    }

    private void initThangs() throws DatabaseException {
        this.keyThang = new DatabaseEntry();
        this.primaryKeyThang = this.view.isSecondary() ? new DatabaseEntry() : this.keyThang;
        this.valueThang = new DatabaseEntry();
    }

    void close() throws DatabaseException {
        DataCursor[] dataCursorArray;
        if (this.joinCursor != null) {
            dataCursorArray = this.joinCursor;
            this.joinCursor = null;
            dataCursorArray.close();
        }
        if (this.cursor != null) {
            dataCursorArray = this.cursor.getCursor();
            this.cursor = null;
            this.view.currentTxn.closeCursor((Cursor)dataCursorArray);
        }
        if (this.indexCursorsToClose != null) {
            dataCursorArray = this.indexCursorsToClose;
            this.indexCursorsToClose = null;
            int n = 0;
            while (n < dataCursorArray.length) {
                dataCursorArray[n].close();
                ++n;
            }
        }
    }

    DataView getView() {
        return this.view;
    }

    KeyRange getRange() {
        return this.range;
    }

    boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    Object getCurrentKey() throws DatabaseException {
        if (this.view.keyBinding == null) {
            throw new UnsupportedOperationException();
        }
        return this.view.makeKey(this.keyThang);
    }

    Object getCurrentValue() throws DatabaseException {
        return this.view.makeValue(this.primaryKeyThang, this.valueThang);
    }

    boolean hasRecNumAccess() {
        return this.view.recNumAccess;
    }

    int getCurrentRecordNumber() throws DatabaseException {
        if (this.view.btreeRecNumDb) {
            if (this.otherThang == null) {
                this.otherThang = new DatabaseEntry();
            }
            DbCompat.getCurrentRecordNumber(this.cursor.getCursor(), this.otherThang, this.getLockMode(false));
            return DbCompat.getRecordNumber(this.otherThang);
        }
        return DbCompat.getRecordNumber(this.keyThang);
    }

    OperationStatus getCurrent(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getCurrent(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getFirst(boolean bl) throws DatabaseException {
        LockMode lockMode = this.getLockMode(bl);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, lockMode);
        }
        return this.cursor.getFirst(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getNext(boolean bl) throws DatabaseException {
        LockMode lockMode = this.getLockMode(bl);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, lockMode);
        }
        return this.cursor.getNext(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getNextNoDup(boolean bl) throws DatabaseException {
        LockMode lockMode = this.getLockMode(bl);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, lockMode);
        }
        return this.cursor.getNextNoDup(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getNextDup(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getNextDup(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getLast(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getLast(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getPrev(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getPrev(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getPrevNoDup(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getPrevNoDup(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getPrevDup(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getPrevDup(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getSearchKey(Object object, Object object2, boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        if (this.view.useKey(object, object2, this.keyThang, this.range)) {
            return this.doGetSearchKey(bl);
        }
        return OperationStatus.NOTFOUND;
    }

    private OperationStatus doGetSearchKey(boolean bl) throws DatabaseException {
        LockMode lockMode = this.getLockMode(bl);
        if (this.view.btreeRecNumAccess) {
            return this.cursor.getSearchRecordNumber(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        return this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getSearchKeyRange(Object object, Object object2, boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        if (this.view.useKey(object, object2, this.keyThang, this.range)) {
            return this.cursor.getSearchKeyRange(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
        }
        return OperationStatus.NOTFOUND;
    }

    OperationStatus getSearchBoth(Object object, Object object2, boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        LockMode lockMode = this.getLockMode(bl);
        this.view.useValue(object2, this.valueThang, null);
        if (this.view.useKey(object, object2, this.keyThang, this.range)) {
            if (this.view.isSecondary()) {
                if (this.otherThang == null) {
                    this.otherThang = new DatabaseEntry();
                }
                OperationStatus operationStatus = this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.otherThang, lockMode);
                while (operationStatus == OperationStatus.SUCCESS) {
                    if (KeyRange.equalBytes(this.otherThang, this.valueThang)) break;
                    operationStatus = this.cursor.getNextDup(this.keyThang, this.primaryKeyThang, this.otherThang, lockMode);
                }
                return operationStatus;
            }
            return this.cursor.getSearchBoth(this.keyThang, null, this.valueThang, lockMode);
        }
        return OperationStatus.NOTFOUND;
    }

    OperationStatus find(Object object, boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        if (!(this.view.entityBinding == null || this.view.isSecondary() || !bl && this.view.dupsAllowed)) {
            return this.getSearchBoth(null, object, false);
        }
        if (this.otherThang == null) {
            this.otherThang = new DatabaseEntry();
        }
        this.view.useValue(object, this.otherThang, null);
        OperationStatus operationStatus = bl ? this.getFirst(false) : this.getLast(false);
        while (operationStatus == OperationStatus.SUCCESS) {
            if (KeyRange.equalBytes(this.valueThang, this.otherThang)) break;
            OperationStatus operationStatus2 = operationStatus = bl ? this.getNext(false) : this.getPrev(false);
        }
        return operationStatus;
    }

    int count() throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.count();
    }

    OperationStatus putCurrent(Object object) throws DatabaseException {
        boolean bl;
        this.checkWriteAllowed(false);
        this.view.useValue(object, this.valueThang, this.keyThang);
        boolean bl2 = bl = this.view.dupsOrdered && !this.view.ordered;
        if (bl) {
            if (this.otherThang == null) {
                this.otherThang = new DatabaseEntry();
            }
            this.cursor.getCurrent(this.keyThang, this.primaryKeyThang, this.otherThang, LockMode.DEFAULT);
            if (KeyRange.equalBytes(this.valueThang, this.otherThang)) {
                return OperationStatus.SUCCESS;
            }
            throw new IllegalArgumentException("Current data differs from put data with sorted duplicates");
        }
        return this.cursor.putCurrent(this.valueThang);
    }

    OperationStatus putAfter(Object object) throws DatabaseException {
        this.checkWriteAllowed(false);
        this.view.useValue(object, this.valueThang, null);
        return this.cursor.putAfter(new DatabaseEntry(), this.valueThang);
    }

    OperationStatus putBefore(Object object) throws DatabaseException {
        this.checkWriteAllowed(false);
        this.view.useValue(object, this.valueThang, this.keyThang);
        return this.cursor.putBefore(new DatabaseEntry(), this.valueThang);
    }

    OperationStatus put(Object object, Object object2, Object[] objectArray, boolean bl) throws DatabaseException {
        this.initForPut(object, object2, objectArray, bl);
        return this.cursor.put(this.keyThang, this.valueThang);
    }

    OperationStatus putNoOverwrite(Object object, Object object2, boolean bl) throws DatabaseException {
        this.initForPut(object, object2, null, bl);
        return this.cursor.putNoOverwrite(this.keyThang, this.valueThang);
    }

    OperationStatus putNoDupData(Object object, Object object2, Object[] objectArray, boolean bl) throws DatabaseException {
        this.initForPut(object, object2, objectArray, bl);
        if (this.view.dupsOrdered) {
            return this.cursor.putNoDupData(this.keyThang, this.valueThang);
        }
        if (this.view.dupsAllowed) {
            OperationStatus operationStatus = this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(false));
            if (operationStatus == OperationStatus.SUCCESS) {
                return OperationStatus.KEYEXIST;
            }
            return this.cursor.put(this.keyThang, this.valueThang);
        }
        return this.cursor.putNoOverwrite(this.keyThang, this.valueThang);
    }

    private void initForPut(Object object, Object object2, Object[] objectArray, boolean bl) throws DatabaseException {
        this.checkWriteAllowed(false);
        if (!bl && !this.view.useKey(object, object2, this.keyThang, this.range)) {
            throw new IllegalArgumentException("key out of range");
        }
        if (objectArray != null) {
            OperationStatus operationStatus;
            objectArray[0] = null;
            if (!this.view.dupsAllowed && (operationStatus = this.doGetSearchKey(true)) == OperationStatus.SUCCESS) {
                objectArray[0] = this.getCurrentValue();
            }
        }
        this.view.useValue(object2, this.valueThang, this.keyThang);
    }

    void useRangeKey() {
        if (!this.range.singleKey) {
            throw new IllegalStateException();
        }
        KeyRange.copy(this.range.beginKey, this.keyThang);
    }

    OperationStatus delete() throws DatabaseException {
        this.checkWriteAllowed(true);
        return this.cursor.delete();
    }

    LockMode getLockMode(boolean bl) {
        if (bl && !this.readUncommitted) {
            return this.view.currentTxn.getWriteLockMode();
        }
        return LockMode.DEFAULT;
    }

    private void checkNoJoinCursor() {
        if (this.joinCursor != null) {
            throw new UnsupportedOperationException("Not allowed with a join cursor");
        }
    }

    private void checkWriteAllowed(boolean bl) {
        this.checkNoJoinCursor();
        if (!this.writeAllowed || !bl && this.view.isSecondary()) {
            throw new UnsupportedOperationException("Writing is not allowed");
        }
    }
}

