/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.RecordNumberBinding;
import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.KeyRange;
import com.sleepycat.collections.KeyRangeException;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.Transaction;
import com.sleepycat.util.RuntimeExceptionWrapper;

final class DataView
implements Cloneable {
    Database db;
    SecondaryDatabase secDb;
    CurrentTransaction currentTxn;
    KeyRange range;
    EntryBinding keyBinding;
    EntryBinding valueBinding;
    EntityBinding entityBinding;
    PrimaryKeyAssigner keyAssigner;
    SecondaryKeyCreator secKeyCreator;
    CursorConfig cursorConfig;
    boolean writeAllowed;
    boolean ordered;
    boolean recNumAllowed;
    boolean recNumAccess;
    boolean btreeRecNumDb;
    boolean btreeRecNumAccess;
    boolean recNumRenumber;
    boolean keysRenumbered;
    boolean dupsAllowed;
    boolean dupsOrdered;
    boolean transactional;
    boolean readUncommittedAllowed;

    DataView(Database database, EntryBinding entryBinding, EntryBinding entryBinding2, EntityBinding entityBinding, boolean bl, PrimaryKeyAssigner primaryKeyAssigner) throws IllegalArgumentException {
        if (database == null) {
            throw new IllegalArgumentException("database is null");
        }
        this.db = database;
        try {
            DatabaseConfig databaseConfig;
            this.currentTxn = CurrentTransaction.getInstanceInternal(this.db.getEnvironment());
            if (this.db instanceof SecondaryDatabase) {
                this.secDb = (SecondaryDatabase)database;
                SecondaryConfig secondaryConfig = this.secDb.getSecondaryConfig();
                this.secKeyCreator = secondaryConfig.getKeyCreator();
                databaseConfig = secondaryConfig;
            } else {
                databaseConfig = this.db.getConfig();
            }
            this.ordered = !DbCompat.isTypeHash(databaseConfig);
            this.recNumAllowed = DbCompat.isTypeQueue(databaseConfig) || DbCompat.isTypeRecno(databaseConfig) || DbCompat.getBtreeRecordNumbers(databaseConfig);
            this.recNumRenumber = DbCompat.getRenumbering(databaseConfig);
            this.dupsAllowed = DbCompat.getSortedDuplicates(databaseConfig) || DbCompat.getUnsortedDuplicates(databaseConfig);
            this.dupsOrdered = DbCompat.getSortedDuplicates(databaseConfig);
            this.transactional = this.currentTxn.isTxnMode() && databaseConfig.getTransactional();
            this.readUncommittedAllowed = DbCompat.getReadUncommitted(databaseConfig);
            this.btreeRecNumDb = this.recNumAllowed && DbCompat.isTypeBtree(databaseConfig);
            this.range = new KeyRange(databaseConfig.getBtreeComparator());
        }
        catch (DatabaseException databaseException) {
            throw new RuntimeExceptionWrapper(databaseException);
        }
        this.writeAllowed = bl;
        this.keyBinding = entryBinding;
        this.valueBinding = entryBinding2;
        this.entityBinding = entityBinding;
        this.keyAssigner = primaryKeyAssigner;
        this.cursorConfig = CursorConfig.DEFAULT;
        if (entryBinding2 != null && entityBinding != null) {
            throw new IllegalArgumentException("both valueBinding and entityBinding are non-null");
        }
        if (entryBinding instanceof RecordNumberBinding) {
            if (!this.recNumAllowed) {
                throw new IllegalArgumentException("RecordNumberBinding requires DB_BTREE/DB_RECNUM, DB_RECNO, or DB_QUEUE");
            }
            this.recNumAccess = true;
            if (this.btreeRecNumDb) {
                this.btreeRecNumAccess = true;
            }
        }
        this.keysRenumbered = this.recNumRenumber || this.btreeRecNumAccess;
    }

    private DataView cloneView() {
        try {
            return (DataView)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }

    DataView keySetView() {
        if (this.keyBinding == null) {
            throw new UnsupportedOperationException("must have keyBinding");
        }
        DataView dataView = this.cloneView();
        dataView.valueBinding = null;
        dataView.entityBinding = null;
        return dataView;
    }

    DataView valueSetView() {
        if (this.valueBinding == null && this.entityBinding == null) {
            throw new UnsupportedOperationException("must have valueBinding or entityBinding");
        }
        DataView dataView = this.cloneView();
        dataView.keyBinding = null;
        return dataView;
    }

    DataView valueSetView(Object object) throws DatabaseException, KeyRangeException {
        KeyRange keyRange = this.subRange(object);
        DataView dataView = this.valueSetView();
        dataView.range = keyRange;
        return dataView;
    }

    DataView subView(Object object, boolean bl, Object object2, boolean bl2, EntryBinding entryBinding) throws DatabaseException, KeyRangeException {
        DataView dataView = this.cloneView();
        dataView.setRange(object, bl, object2, bl2);
        if (entryBinding != null) {
            dataView.keyBinding = entryBinding;
        }
        return dataView;
    }

    DataView configuredView(CursorConfig cursorConfig) {
        DataView dataView = this.cloneView();
        dataView.cursorConfig = cursorConfig != null ? DbCompat.cloneCursorConfig(cursorConfig) : CursorConfig.DEFAULT;
        return dataView;
    }

    CurrentTransaction getCurrentTxn() {
        return this.transactional ? this.currentTxn : null;
    }

    private void setRange(Object object, boolean bl, Object object2, boolean bl2) throws DatabaseException, KeyRangeException {
        this.range = this.subRange(object, bl, object2, bl2);
    }

    DatabaseEntry getSingleKeyThang() {
        return this.range.getSingleKey();
    }

    final Environment getEnv() {
        return this.currentTxn.getEnvironment();
    }

    final boolean isSecondary() {
        return this.secDb != null;
    }

    boolean isEmpty() throws DatabaseException {
        boolean bl;
        DataCursor dataCursor = new DataCursor(this, false);
        try {
            bl = dataCursor.getFirst(false) != OperationStatus.SUCCESS;
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            dataCursor.close();
            throw throwable;
        }
        dataCursor.close();
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OperationStatus append(Object object, Object[] objectArray, Object[] objectArray2) throws DatabaseException {
        OperationStatus operationStatus;
        DatabaseEntry databaseEntry;
        DatabaseEntry databaseEntry2;
        block8: {
            databaseEntry2 = new DatabaseEntry();
            databaseEntry = new DatabaseEntry();
            this.useValue(object, databaseEntry, null);
            if (this.keyAssigner != null) {
                this.keyAssigner.assignKey(databaseEntry2);
                if (!this.range.check(databaseEntry2)) {
                    throw new IllegalArgumentException("assigned key out of range");
                }
                DataCursor dataCursor = new DataCursor(this, true);
                try {
                    operationStatus = dataCursor.getCursor().putNoOverwrite(databaseEntry2, databaseEntry);
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    dataCursor.close();
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                    dataCursor.close();
                    break block8;
                }
            }
            if (this.currentTxn.isCDBCursorOpen(this.db)) {
                throw new IllegalStateException("cannot open CDB write cursor when read cursor is open");
            }
            operationStatus = DbCompat.append(this.db, this.useTransaction(), databaseEntry2, databaseEntry);
            if (operationStatus == OperationStatus.SUCCESS && !this.range.check(databaseEntry2)) {
                this.db.delete(this.useTransaction(), databaseEntry2);
                throw new IllegalArgumentException("appended record number out of range");
            }
        }
        if (operationStatus == OperationStatus.SUCCESS) {
            this.returnPrimaryKeyAndValue(databaseEntry2, databaseEntry, objectArray, objectArray2);
        }
        return operationStatus;
    }

    Transaction useTransaction() {
        return this.transactional ? this.currentTxn.getTransaction() : null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void clear() throws DatabaseException {
        DataCursor dataCursor = new DataCursor(this, true);
        try {
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            while (operationStatus == OperationStatus.SUCCESS) {
                operationStatus = this.keysRenumbered ? dataCursor.getFirst(true) : dataCursor.getNext(true);
                if (operationStatus != OperationStatus.SUCCESS) continue;
                dataCursor.delete();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            dataCursor.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        dataCursor.close();
    }

    /*
     * Unable to fully structure code
     */
    DataCursor join(DataView[] var1_1, Object[] var2_2, JoinConfig var3_3) throws DatabaseException {
        block12: {
            block10: {
                var4_4 = null;
                var5_5 = new DataCursor[var1_1.length];
                try {
                    var6_6 = 0;
                    while (var6_6 < var1_1.length) {
                        var5_5[var6_6] = new DataCursor(var1_1[var6_6], false);
                        var5_5[var6_6].getSearchKey(var2_2[var6_6], null, false);
                        ++var6_6;
                    }
                    var9_7 = var4_4 = new DataCursor(this, var5_5, var3_3, true);
                    var7_8 = null;
                    if (var4_4 != null) break block10;
                    var10_10 = 0;
                    ** while (var10_10 < var5_5.length)
                }
                catch (Throwable var8_12) {
                    var7_9 = null;
                    if (var4_4 != null) break block12;
                    var10_11 = 0;
                    ** while (var10_11 < var5_5.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (var5_5[var10_10] != null) {
                        try {
                            var5_5[var10_10].close();
                        }
                        catch (Exception v0) {}
                    }
                    ++var10_10;
                    continue;
                }
            }
            return var9_7;
lbl-1000:
            // 1 sources

            {
                if (var5_5[var10_11] != null) {
                    try {
                        var5_5[var10_11].close();
                    }
                    catch (Exception v1) {}
                }
                ++var10_11;
                continue;
            }
        }
        throw var8_12;
    }

    DataCursor join(DataCursor[] dataCursorArray, JoinConfig joinConfig) throws DatabaseException {
        return new DataCursor(this, dataCursorArray, joinConfig, false);
    }

    private void returnPrimaryKeyAndValue(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, Object[] objectArray, Object[] objectArray2) throws DatabaseException {
        if (objectArray != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("returning key requires primary key binding");
            }
            if (this.isSecondary()) {
                throw new IllegalArgumentException("returning key requires unindexed view");
            }
            objectArray[0] = this.keyBinding.entryToObject(databaseEntry);
        }
        if (objectArray2 != null) {
            objectArray2[0] = this.makeValue(databaseEntry, databaseEntry2);
        }
    }

    boolean useKey(Object object, Object object2, DatabaseEntry databaseEntry, KeyRange keyRange) throws DatabaseException {
        if (object != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("non-null key with null key binding");
            }
            this.keyBinding.objectToEntry(object, databaseEntry);
        } else {
            if (object2 == null) {
                throw new IllegalArgumentException("null key and null value");
            }
            if (this.entityBinding == null) {
                throw new IllegalStateException("EntityBinding required to derive key from value");
            }
            if (this.isSecondary()) {
                DatabaseEntry databaseEntry2 = new DatabaseEntry();
                this.entityBinding.objectToKey(object2, databaseEntry2);
                DatabaseEntry databaseEntry3 = new DatabaseEntry();
                this.entityBinding.objectToData(object2, databaseEntry3);
                this.secKeyCreator.createSecondaryKey(this.secDb, databaseEntry2, databaseEntry3, databaseEntry);
            } else {
                this.entityBinding.objectToKey(object2, databaseEntry);
            }
        }
        if (this.recNumAccess && DbCompat.getRecordNumber(databaseEntry) <= 0) {
            return false;
        }
        return keyRange == null || keyRange.check(databaseEntry);
    }

    final boolean canDeriveKeyFromValue() {
        return this.entityBinding != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void useValue(Object object, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        if (object == null) {
            databaseEntry.setData(new byte[0]);
            databaseEntry.setOffset(0);
            databaseEntry.setSize(0);
            return;
        }
        if (this.valueBinding != null) {
            this.valueBinding.objectToEntry(object, databaseEntry);
            return;
        }
        if (this.entityBinding == null) throw new IllegalArgumentException("non-null value with null value/entity binding");
        this.entityBinding.objectToData(object, databaseEntry);
        if (databaseEntry2 == null) return;
        DatabaseEntry databaseEntry3 = new DatabaseEntry();
        this.entityBinding.objectToKey(object, databaseEntry3);
        if (KeyRange.equalBytes(databaseEntry3, databaseEntry2)) return;
        throw new IllegalArgumentException("cannot change primary key");
    }

    Object makeKey(DatabaseEntry databaseEntry) throws DatabaseException {
        if (databaseEntry.getSize() == 0) {
            return null;
        }
        return this.keyBinding.entryToObject(databaseEntry);
    }

    Object makeValue(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        Object object;
        if (this.valueBinding != null) {
            object = this.valueBinding.entryToObject(databaseEntry2);
        } else if (this.entityBinding != null) {
            object = this.entityBinding.entryToObject(databaseEntry, databaseEntry2);
        } else {
            throw new UnsupportedOperationException("requires valueBinding or entityBinding");
        }
        return object;
    }

    KeyRange subRange(Object object) throws DatabaseException, KeyRangeException {
        return this.range.subRange(this.makeRangeKey(object));
    }

    KeyRange subRange(Object object, boolean bl, Object object2, boolean bl2) throws DatabaseException, KeyRangeException {
        if (object == object2 && bl && bl2) {
            return this.subRange(object);
        }
        if (!this.ordered) {
            throw new UnsupportedOperationException("Cannot use key ranges on an unsorted database");
        }
        DatabaseEntry databaseEntry = object != null ? this.makeRangeKey(object) : null;
        DatabaseEntry databaseEntry2 = object2 != null ? this.makeRangeKey(object2) : null;
        return this.range.subRange(databaseEntry, bl, databaseEntry2, bl2);
    }

    private DatabaseEntry makeRangeKey(Object object) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        if (this.keyBinding != null) {
            this.useKey(object, null, databaseEntry, null);
        } else {
            this.useKey(null, object, databaseEntry, null);
        }
        return databaseEntry;
    }
}

