/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.KeyRangeException;
import com.sleepycat.db.DatabaseEntry;
import java.util.Comparator;

class KeyRange {
    Comparator comparator;
    DatabaseEntry beginKey;
    DatabaseEntry endKey;
    boolean singleKey;
    boolean beginInclusive;
    boolean endInclusive;

    KeyRange(Comparator comparator) {
        this.comparator = comparator;
    }

    KeyRange subRange(DatabaseEntry databaseEntry) throws KeyRangeException {
        if (!this.check(databaseEntry)) {
            throw new KeyRangeException("singleKey out of range");
        }
        KeyRange keyRange = new KeyRange(this.comparator);
        keyRange.beginKey = databaseEntry;
        keyRange.endKey = databaseEntry;
        keyRange.beginInclusive = true;
        keyRange.endInclusive = true;
        keyRange.singleKey = true;
        return keyRange;
    }

    KeyRange subRange(DatabaseEntry databaseEntry, boolean bl, DatabaseEntry databaseEntry2, boolean bl2) throws KeyRangeException {
        if (databaseEntry == null) {
            databaseEntry = this.beginKey;
            bl = this.beginInclusive;
        } else if (!this.check(databaseEntry, bl)) {
            throw new KeyRangeException("beginKey out of range");
        }
        if (databaseEntry2 == null) {
            databaseEntry2 = this.endKey;
            bl2 = this.endInclusive;
        } else if (!this.check(databaseEntry2, bl2)) {
            throw new KeyRangeException("endKey out of range");
        }
        KeyRange keyRange = new KeyRange(this.comparator);
        keyRange.beginKey = databaseEntry;
        keyRange.endKey = databaseEntry2;
        keyRange.beginInclusive = bl;
        keyRange.endInclusive = bl2;
        return keyRange;
    }

    final DatabaseEntry getSingleKey() {
        return this.singleKey ? this.beginKey : null;
    }

    final boolean hasBound() {
        return this.endKey != null || this.beginKey != null;
    }

    public String toString() {
        return "[KeyRange " + this.beginKey + ' ' + this.beginInclusive + this.endKey + ' ' + this.endInclusive + (this.singleKey ? " single" : "");
    }

    boolean check(DatabaseEntry databaseEntry) {
        if (this.singleKey) {
            return this.compare(databaseEntry, this.beginKey) == 0;
        }
        return this.checkBegin(databaseEntry, true) && this.checkEnd(databaseEntry, true);
    }

    boolean check(DatabaseEntry databaseEntry, boolean bl) {
        if (this.singleKey) {
            return this.compare(databaseEntry, this.beginKey) == 0;
        }
        return this.checkBegin(databaseEntry, bl) && this.checkEnd(databaseEntry, bl);
    }

    boolean checkBegin(DatabaseEntry databaseEntry, boolean bl) {
        if (this.beginKey == null) {
            return true;
        }
        if (!this.beginInclusive && bl) {
            return this.compare(databaseEntry, this.beginKey) > 0;
        }
        return this.compare(databaseEntry, this.beginKey) >= 0;
    }

    boolean checkEnd(DatabaseEntry databaseEntry, boolean bl) {
        if (this.endKey == null) {
            return true;
        }
        if (!this.endInclusive && bl) {
            return this.compare(databaseEntry, this.endKey) < 0;
        }
        return this.compare(databaseEntry, this.endKey) <= 0;
    }

    int compare(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        if (this.comparator != null) {
            return this.comparator.compare(KeyRange.getByteArray(databaseEntry), KeyRange.getByteArray(databaseEntry2));
        }
        return KeyRange.compareBytes(databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize(), databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
    }

    static int compareBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n2 && n5 < n4) {
            int n6 = 0xFF & byArray[n + n5];
            int n7 = 0xFF & byArray2[n3 + n5];
            if (n6 < n7) {
                return -1;
            }
            if (n6 > n7) {
                return 1;
            }
            ++n5;
        }
        if (n2 < n4) {
            return -1;
        }
        if (n2 > n4) {
            return 1;
        }
        return 0;
    }

    static DatabaseEntry copy(DatabaseEntry databaseEntry) {
        return new DatabaseEntry(KeyRange.getByteArray(databaseEntry));
    }

    static void copy(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        databaseEntry2.setData(KeyRange.getByteArray(databaseEntry));
        databaseEntry2.setOffset(0);
    }

    static byte[] getByteArray(DatabaseEntry databaseEntry) {
        byte[] byArray = databaseEntry.getData();
        if (byArray == null) {
            return null;
        }
        int n = databaseEntry.getSize();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, databaseEntry.getOffset(), byArray2, 0, n);
        return byArray2;
    }

    static boolean equalBytes(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        if (databaseEntry == null && databaseEntry2 == null) {
            return true;
        }
        if (databaseEntry == null || databaseEntry2 == null) {
            return false;
        }
        byte[] byArray = databaseEntry.getData();
        byte[] byArray2 = databaseEntry2.getData();
        int n = databaseEntry.getSize();
        int n2 = databaseEntry2.getSize();
        int n3 = databaseEntry.getOffset();
        int n4 = databaseEntry2.getOffset();
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (n != n2) {
            return false;
        }
        int n5 = 0;
        while (n5 < n) {
            if (byArray[n3 + n5] != byArray2[n4 + n5]) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    static String toString(DatabaseEntry databaseEntry) {
        int n = databaseEntry.getOffset() + databaseEntry.getSize();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        byte[] byArray = databaseEntry.getData();
        int n2 = databaseEntry.getOffset();
        while (n2 < n) {
            String string = Integer.toHexString(byArray[n2]);
            if (string.length() < 2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

