/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.OperationStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class StoredCollection
extends StoredContainer
implements Collection {
    StoredCollection(DataView dataView) {
        super(dataView);
    }

    final boolean add(Object object, Object object2) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.putNoDupData(object, object2, null, false);
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    public Iterator iterator() {
        return this.iterator(this.isWriteAllowed());
    }

    public StoredIterator iterator(boolean bl) {
        try {
            return new StoredIterator(this, bl && this.isWriteAllowed(), null);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] toArray() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        StoredIterator.close(iterator);
        return arrayList.toArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] toArray(Object[] objectArray) {
        int n = 0;
        Iterator iterator = this.iterator();
        try {
            while (n < objectArray.length && iterator.hasNext()) {
                objectArray[n++] = iterator.next();
            }
            if (n < objectArray.length) {
                objectArray[n] = null;
            } else if (iterator.hasNext()) {
                ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                objectArray = arrayList.toArray(objectArray);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsAll(Collection collection) {
        Iterator iterator;
        block5: {
            block4: {
                iterator = collection.iterator();
                try {
                    while (iterator.hasNext()) {
                        if (this.contains(iterator.next())) continue;
                        Object var3_3 = null;
                        break block4;
                    }
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    StoredIterator.close(iterator);
                    throw throwable;
                }
            }
            StoredIterator.close(iterator);
            return false;
        }
        Object var3_5 = null;
        StoredIterator.close(iterator);
        return true;
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            iterator = collection.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                if (!this.add(iterator.next())) continue;
                bl2 = true;
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    public boolean removeAll(Collection collection) {
        return this.removeAll(collection, true);
    }

    public boolean retainAll(Collection collection) {
        return this.removeAll(collection, false);
    }

    private boolean removeAll(Collection collection, boolean bl) {
        Iterator iterator = null;
        boolean bl2 = this.beginAutoCommit();
        try {
            boolean bl3 = false;
            iterator = this.iterator();
            while (iterator.hasNext()) {
                if (bl != collection.contains(iterator.next())) continue;
                iterator.remove();
                bl3 = true;
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl2);
            return bl3;
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        boolean bl;
        Iterator iterator;
        block4: {
            if (!(object instanceof Collection)) {
                return false;
            }
            Collection collection = StoredCollection.copyCollection(object);
            iterator = this.iterator();
            try {
                do {
                    if (iterator.hasNext()) continue;
                    bl = collection.isEmpty();
                    break block4;
                } while (collection.remove(iterator.next()));
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                StoredIterator.close(iterator);
                throw throwable;
            }
            StoredIterator.close(iterator);
            return false;
        }
        Object var4_5 = null;
        StoredIterator.close(iterator);
        return bl;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public List toList() {
        ArrayList arrayList;
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList2.add(iterator.next());
            }
            arrayList = arrayList2;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return arrayList;
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append(']');
            string = stringBuffer.toString();
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return string;
    }

    public StoredIterator join(StoredContainer[] storedContainerArray, Object[] objectArray, JoinConfig joinConfig) {
        try {
            DataView[] dataViewArray = new DataView[storedContainerArray.length];
            int n = 0;
            while (n < storedContainerArray.length) {
                dataViewArray[n] = storedContainerArray[n].view;
                ++n;
            }
            DataCursor dataCursor = this.view.join(dataViewArray, objectArray, joinConfig);
            return new StoredIterator(this, false, dataCursor);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    final Object getFirstOrLast(boolean bl) {
        Object object;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = bl ? dataCursor.getFirst(false) : dataCursor.getLast(false);
            object = operationStatus == OperationStatus.SUCCESS ? this.makeIteratorData(null, dataCursor) : null;
            Object var4_6 = null;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return object;
    }

    abstract Object makeIteratorData(StoredIterator var1, DataCursor var2) throws DatabaseException;

    abstract boolean hasValues();

    boolean iterateDuplicates() {
        return true;
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("duplicates required");
        }
    }

    int getIndexOffset() {
        return 0;
    }

    private static Collection copyCollection(Object object) {
        if (object instanceof StoredCollection) {
            return ((StoredCollection)object).toList();
        }
        return new ArrayList((Collection)object);
    }
}

