/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredMapEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.OperationStatus;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet
extends StoredCollection
implements Set {
    StoredEntrySet(DataView dataView) {
        super(dataView);
    }

    public boolean add(Object object) {
        Map.Entry entry = (Map.Entry)object;
        return this.add(entry.getKey(), entry.getValue());
    }

    public boolean remove(Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.getSearchBoth(entry.getKey(), entry.getValue(), true);
            if (operationStatus == OperationStatus.SUCCESS) {
                dataCursor.delete();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    public boolean contains(Object object) {
        boolean bl;
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = dataCursor.getSearchBoth(entry.getKey(), entry.getValue(), false);
            bl = operationStatus == OperationStatus.SUCCESS;
            Object var5_7 = null;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return bl;
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (k != null) {
                    stringBuffer.append(k.toString());
                }
                stringBuffer.append('=');
                if (v == null) continue;
                stringBuffer.append(v.toString());
            }
            stringBuffer.append(']');
            string = stringBuffer.toString();
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return string;
    }

    Object makeIteratorData(StoredIterator storedIterator, DataCursor dataCursor) throws DatabaseException {
        return new StoredMapEntry(dataCursor.getCurrentKey(), dataCursor.getCurrentValue(), this, storedIterator);
    }

    boolean hasValues() {
        return true;
    }
}

