/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.OperationStatus;
import java.util.Set;

public class StoredValueSet
extends StoredCollection
implements Set {
    private boolean isSingleKey;

    public StoredValueSet(Database database, EntryBinding entryBinding, boolean bl) {
        super(new DataView(database, null, entryBinding, null, bl, null));
    }

    public StoredValueSet(Database database, EntityBinding entityBinding, boolean bl) {
        super(new DataView(database, null, null, entityBinding, bl, null));
    }

    StoredValueSet(DataView dataView) {
        super(dataView);
    }

    StoredValueSet(DataView dataView, boolean bl) {
        super(dataView);
        this.isSingleKey = bl;
    }

    public boolean add(Object object) {
        if (this.view.isSecondary()) {
            throw new UnsupportedOperationException("add() not allowed with index");
        }
        if (this.isSingleKey) {
            if (!this.view.dupsAllowed) {
                throw new UnsupportedOperationException("duplicates required");
            }
            DataCursor dataCursor = null;
            boolean bl = this.beginAutoCommit();
            try {
                dataCursor = new DataCursor(this.view, true);
                dataCursor.useRangeKey();
                OperationStatus operationStatus = dataCursor.putNoDupData(null, object, null, true);
                this.closeCursor(dataCursor);
                this.commitAutoCommit(bl);
                return operationStatus == OperationStatus.SUCCESS;
            }
            catch (Exception exception) {
                this.closeCursor(dataCursor);
                throw this.handleException(exception, bl);
            }
        }
        if (this.view.entityBinding == null) {
            throw new UnsupportedOperationException("add() requires entity binding");
        }
        return this.add(null, object);
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean remove(Object object) {
        return this.removeValue(object);
    }

    public int size() {
        DataCursor dataCursor;
        block6: {
            if (!this.isSingleKey) {
                return super.size();
            }
            dataCursor = null;
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = dataCursor.getFirst(false);
            if (operationStatus != OperationStatus.SUCCESS) break block6;
            int n = dataCursor.count();
            Object var3_5 = null;
            this.closeCursor(dataCursor);
            return n;
        }
        try {
            Object var3_6 = null;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return 0;
    }

    Object makeIteratorData(StoredIterator storedIterator, DataCursor dataCursor) throws DatabaseException {
        return dataCursor.getCurrentValue();
    }

    boolean hasValues() {
        return true;
    }
}

