/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.TransactionWorker;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DeadlockException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.util.ExceptionUnwrapper;

public class TransactionRunner {
    public static final int DEFAULT_MAX_RETRIES = 10;
    private Environment env;
    private CurrentTransaction currentTxn;
    private int maxRetries;
    private TransactionConfig config;
    private boolean allowNestedTxn;

    public TransactionRunner(Environment environment) {
        this(environment, 10, null);
    }

    public TransactionRunner(Environment environment, int n, TransactionConfig transactionConfig) {
        this.env = environment;
        this.currentTxn = CurrentTransaction.getInstance(environment);
        this.maxRetries = n;
        this.config = transactionConfig;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public boolean getAllowNestedTransactions() {
        return this.allowNestedTxn;
    }

    public void setAllowNestedTransactions(boolean bl) {
        this.allowNestedTxn = bl;
    }

    public TransactionConfig getTransactionConfig() {
        return this.config;
    }

    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.config = transactionConfig;
    }

    public void run(TransactionWorker transactionWorker) throws DatabaseException, Exception {
        if (this.currentTxn != null && (this.allowNestedTxn || this.currentTxn.getTransaction() == null)) {
            int n = 0;
            while (true) {
                Transaction transaction = null;
                try {
                    transaction = this.currentTxn.beginTransaction(this.config);
                    transactionWorker.doWork();
                    if (transaction != null && transaction == this.currentTxn.getTransaction()) {
                        this.currentTxn.commitTransaction();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = ExceptionUnwrapper.unwrapAny(throwable);
                    if (transaction != null && transaction == this.currentTxn.getTransaction()) {
                        try {
                            this.currentTxn.abortTransaction();
                        }
                        catch (Throwable throwable3) {
                            throwable3.printStackTrace();
                            n = this.maxRetries + 1;
                        }
                    }
                    if (n >= this.maxRetries || !(throwable2 instanceof DeadlockException)) {
                        if (throwable2 instanceof Exception) {
                            throw (Exception)throwable2;
                        }
                        throw (Error)throwable2;
                    }
                    ++n;
                    continue;
                }
                break;
            }
        }
        try {
            transactionWorker.doWork();
        }
        catch (Exception exception) {
            throw ExceptionUnwrapper.unwrap(exception);
        }
    }
}

