/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.CacheFile;
import com.sleepycat.db.CompactConfig;
import com.sleepycat.db.CompactStats;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseStats;
import com.sleepycat.db.Environment;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.JoinCursor;
import com.sleepycat.db.KeyRange;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Sequence;
import com.sleepycat.db.SequenceConfig;
import com.sleepycat.db.StatsConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.VerifyConfig;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbSequence;
import com.sleepycat.db.internal.Dbc;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class Database {
    Db db;
    private int autoCommitFlag;
    int rmwFlag;

    Database(Db db) throws DatabaseException {
        this.db = db;
        db.wrapper = this;
        this.autoCommitFlag = db.get_transactional() ? 0x1000000 : 0;
        this.rmwFlag = (db.get_env().get_open_flags() & 0x4000) != 0 ? 0x20000000 : 0;
    }

    public Database(String string, String string2, DatabaseConfig databaseConfig) throws DatabaseException, FileNotFoundException {
        this(DatabaseConfig.checkNull(databaseConfig).openDatabase(null, null, string, string2));
        new Environment(this.db.get_env());
    }

    public void close(boolean bl) throws DatabaseException {
        this.db.close(bl ? 23 : 0);
    }

    public void close() throws DatabaseException {
        this.close(false);
    }

    public CompactStats compact(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, CompactConfig compactConfig) throws DatabaseException {
        compactConfig = CompactConfig.checkNull(compactConfig);
        CompactStats compactStats = new CompactStats(compactConfig.getFillPercent(), compactConfig.getTimeout(), compactConfig.getMaxPages());
        this.db.compact(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, compactStats, compactConfig.getFlags(), databaseEntry3);
        return compactStats;
    }

    public Cursor openCursor(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        return new Cursor(this, CursorConfig.checkNull(cursorConfig).openCursor(this.db, transaction == null ? null : transaction.txn), cursorConfig);
    }

    public Sequence openSequence(Transaction transaction, DatabaseEntry databaseEntry, SequenceConfig sequenceConfig) throws DatabaseException {
        return new Sequence(SequenceConfig.checkNull(sequenceConfig).openSequence(this.db, transaction == null ? null : transaction.txn, databaseEntry), sequenceConfig);
    }

    public void removeSequence(Transaction transaction, DatabaseEntry databaseEntry, SequenceConfig sequenceConfig) throws DatabaseException {
        sequenceConfig = SequenceConfig.checkNull(sequenceConfig);
        DbSequence dbSequence = sequenceConfig.openSequence(this.db, transaction == null ? null : transaction.txn, databaseEntry);
        dbSequence.remove(transaction == null ? null : transaction.txn, transaction == null && this.db.get_transactional() ? 0x1000000 | (sequenceConfig.getAutoCommitNoSync() ? 256 : 0) : 0);
    }

    public String getDatabaseFile() throws DatabaseException {
        return this.db.get_filename();
    }

    public String getDatabaseName() throws DatabaseException {
        return this.db.get_dbname();
    }

    public DatabaseConfig getConfig() throws DatabaseException {
        return new DatabaseConfig(this.db);
    }

    public void setConfig(DatabaseConfig databaseConfig) throws DatabaseException {
        databaseConfig.configureDatabase(this.db, this.getConfig());
    }

    public Environment getEnvironment() throws DatabaseException {
        return this.db.get_env().wrapper;
    }

    public CacheFile getCacheFile() throws DatabaseException {
        return new CacheFile(this.db.get_mpf());
    }

    public OperationStatus append(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return OperationStatus.fromInt(this.db.put(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, 2 | (transaction == null ? this.autoCommitFlag : 0)));
    }

    public OperationStatus consume(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, boolean bl) throws DatabaseException {
        return OperationStatus.fromInt(this.db.get(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, (bl ? 6 : 5) | (transaction == null ? this.autoCommitFlag : 0)));
    }

    public OperationStatus delete(Transaction transaction, DatabaseEntry databaseEntry) throws DatabaseException {
        return OperationStatus.fromInt(this.db.del(transaction == null ? null : transaction.txn, databaseEntry, transaction == null ? this.autoCommitFlag : 0));
    }

    public OperationStatus get(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.get(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public KeyRange getKeyRange(Transaction transaction, DatabaseEntry databaseEntry) throws DatabaseException {
        KeyRange keyRange = new KeyRange();
        this.db.key_range(transaction == null ? null : transaction.txn, databaseEntry, keyRange, 0);
        return keyRange;
    }

    public OperationStatus getSearchBoth(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.get(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, 0xA | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getSearchRecordNumber(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.get(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, 0x1F | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus put(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return OperationStatus.fromInt(this.db.put(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, transaction == null ? this.autoCommitFlag : 0));
    }

    public OperationStatus putNoDupData(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return OperationStatus.fromInt(this.db.put(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, 0x15 | (transaction == null ? this.autoCommitFlag : 0)));
    }

    public OperationStatus putNoOverwrite(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return OperationStatus.fromInt(this.db.put(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, 0x16 | (transaction == null ? this.autoCommitFlag : 0)));
    }

    public JoinCursor join(Cursor[] cursorArray, JoinConfig joinConfig) throws DatabaseException {
        joinConfig = JoinConfig.checkNull(joinConfig);
        Dbc[] dbcArray = new Dbc[cursorArray.length];
        int n = 0;
        while (n < cursorArray.length) {
            dbcArray[n] = cursorArray[n] == null ? null : cursorArray[n].dbc;
            ++n;
        }
        return new JoinCursor(this, this.db.join(dbcArray, joinConfig.getFlags()), joinConfig);
    }

    public int truncate(Transaction transaction, boolean bl) throws DatabaseException {
        int n = this.db.truncate(transaction == null ? null : transaction.txn, transaction == null ? this.autoCommitFlag : 0);
        return bl ? n : -1;
    }

    public DatabaseStats getStats(Transaction transaction, StatsConfig statsConfig) throws DatabaseException {
        return (DatabaseStats)this.db.stat(transaction == null ? null : transaction.txn, StatsConfig.checkNull(statsConfig).getFlags());
    }

    public static void remove(String string, String string2, DatabaseConfig databaseConfig) throws DatabaseException, FileNotFoundException {
        Db db = DatabaseConfig.checkNull(databaseConfig).createDatabase(null);
        db.remove(string, string2, 0);
    }

    public static void rename(String string, String string2, String string3, DatabaseConfig databaseConfig) throws DatabaseException, FileNotFoundException {
        Db db = DatabaseConfig.checkNull(databaseConfig).createDatabase(null);
        db.rename(string, string2, string3, 0);
    }

    public void sync() throws DatabaseException {
        this.db.sync(0);
    }

    public static void upgrade(String string, DatabaseConfig databaseConfig) throws DatabaseException, FileNotFoundException {
        Db db = DatabaseConfig.checkNull(databaseConfig).createDatabase(null);
        db.upgrade(string, databaseConfig.getSortedDuplicates() ? 32768 : 0);
        db.close(0);
    }

    public boolean verify(String string, String string2, PrintStream printStream, VerifyConfig verifyConfig) throws DatabaseException, FileNotFoundException {
        return this.db.verify(string, string2, printStream, VerifyConfig.checkNull(verifyConfig).getFlags());
    }
}

