/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.FeedbackHandler;
import com.sleepycat.db.LockDetectMode;
import com.sleepycat.db.LogRecordHandler;
import com.sleepycat.db.MessageHandler;
import com.sleepycat.db.PanicHandler;
import com.sleepycat.db.ReplicationTransport;
import com.sleepycat.db.internal.DbEnv;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class EnvironmentConfig
implements Cloneable {
    public static final EnvironmentConfig DEFAULT = new EnvironmentConfig();
    private int mode = 420;
    private int cacheCount = 0;
    private long cacheSize = 0L;
    private Vector dataDirs = new Vector();
    private int envid = 0;
    private String errorPrefix = null;
    private OutputStream errorStream = null;
    private OutputStream messageStream = null;
    private byte[][] lockConflicts = null;
    private LockDetectMode lockDetectMode = LockDetectMode.NONE;
    private int maxLocks = 0;
    private int maxLockers = 0;
    private int maxLockObjects = 0;
    private int maxLogFileSize = 0;
    private int logBufferSize = 0;
    private File logDirectory = null;
    private int logFileMode = 0;
    private int logRegionSize = 0;
    private int maxMutexes = 0;
    private int maxOpenFiles = 0;
    private int maxWrite = 0;
    private int maxWriteSleep = 0;
    private int mutexAlignment = 0;
    private int mutexIncrement = 0;
    private int mutexTestAndSetSpins = 0;
    private long mmapSize = 0L;
    private String password = null;
    private long replicationLimit = 0L;
    private int replicationRequestMin = 0;
    private int replicationRequestMax = 0;
    private String rpcServer = null;
    private long rpcClientTimeout = 0L;
    private long rpcServerTimeout = 0L;
    private long segmentId = 0L;
    private long lockTimeout = 0L;
    private int txnMaxActive = 0;
    private long txnTimeout = 0L;
    private Date txnTimestamp = null;
    private File temporaryDirectory = null;
    private boolean allowCreate = false;
    private boolean initializeCache = false;
    private boolean initializeCDB = false;
    private boolean initializeLocking = false;
    private boolean initializeLogging = false;
    private boolean initializeReplication = false;
    private boolean joinEnvironment = false;
    private boolean lockDown = false;
    private boolean isPrivate = false;
    private boolean register = false;
    private boolean runRecovery = false;
    private boolean runFatalRecovery = false;
    private boolean systemMemory = false;
    private boolean threaded = true;
    private boolean transactional = false;
    private boolean useEnvironment = false;
    private boolean useEnvironmentRoot = false;
    private boolean cdbLockAllDatabases = false;
    private boolean directDatabaseIO = false;
    private boolean directLogIO = false;
    private boolean dsyncDatabases = false;
    private boolean dsyncLog = false;
    private boolean initializeRegions = false;
    private boolean logAutoRemove = false;
    private boolean logInMemory = false;
    private boolean noLocking = false;
    private boolean noMMap = false;
    private boolean noPanic = false;
    private boolean overwrite = false;
    private boolean txnNoSync = false;
    private boolean txnNotDurable = false;
    private boolean txnWriteNoSync = false;
    private boolean yieldCPU = false;
    private boolean verboseDeadlock = false;
    private boolean verboseRecovery = false;
    private boolean verboseRegister = false;
    private boolean verboseReplication = false;
    private boolean verboseWaitsFor = false;
    private ErrorHandler errorHandler = null;
    private FeedbackHandler feedbackHandler = null;
    private LogRecordHandler logRecordHandler = null;
    private MessageHandler messageHandler = null;
    private PanicHandler panicHandler = null;
    private ReplicationTransport replicationTransport = null;

    static EnvironmentConfig checkNull(EnvironmentConfig environmentConfig) {
        return environmentConfig == null ? DEFAULT : environmentConfig;
    }

    public EnvironmentConfig() {
    }

    public void setAllowCreate(boolean bl) {
        this.allowCreate = bl;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setCacheSize(long l) {
        this.cacheSize = l;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheCount(int n) {
        this.cacheCount = n;
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public void setCDBLockAllDatabases(boolean bl) {
        this.cdbLockAllDatabases = bl;
    }

    public boolean getCDBLockAllDatabases() {
        return this.cdbLockAllDatabases;
    }

    public void addDataDir(File file) {
        this.dataDirs.add(file);
    }

    public void addDataDir(String string) {
        this.addDataDir(new File(string));
    }

    public File[] getDataDirs() {
        Object[] objectArray = new File[this.dataDirs.size()];
        this.dataDirs.copyInto(objectArray);
        return objectArray;
    }

    public void setDirectDatabaseIO(boolean bl) {
        this.directDatabaseIO = bl;
    }

    public boolean getDirectDatabaseIO() {
        return this.directDatabaseIO;
    }

    public void setDirectLogIO(boolean bl) {
        this.directLogIO = bl;
    }

    public boolean getDirectLogIO() {
        return this.directLogIO;
    }

    public void setDsyncDatabases(boolean bl) {
        this.dsyncDatabases = bl;
    }

    public boolean getDsyncDatabases() {
        return this.dsyncDatabases;
    }

    public void setDsyncLog(boolean bl) {
        this.dsyncLog = bl;
    }

    public boolean getDsyncLog() {
        return this.dsyncLog;
    }

    public void setEncrypted(String string) {
        this.password = string;
    }

    public boolean getEncrypted() {
        return this.password != null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorPrefix(String string) {
        this.errorPrefix = string;
    }

    public String getErrorPrefix() {
        return this.errorPrefix;
    }

    public void setErrorStream(OutputStream outputStream) {
        this.errorStream = outputStream;
    }

    public OutputStream getErrorStream() {
        return this.errorStream;
    }

    public void setFeedbackHandler(FeedbackHandler feedbackHandler) {
        this.feedbackHandler = feedbackHandler;
    }

    public FeedbackHandler getFeedbackHandler() {
        return this.feedbackHandler;
    }

    public void setInitializeCache(boolean bl) {
        this.initializeCache = bl;
    }

    public boolean getInitializeCache() {
        return this.initializeCache;
    }

    public void setInitializeCDB(boolean bl) {
        this.initializeCDB = bl;
    }

    public boolean getInitializeCDB() {
        return this.initializeCDB;
    }

    public void setInitializeLocking(boolean bl) {
        this.initializeLocking = bl;
    }

    public boolean getInitializeLocking() {
        return this.initializeLocking;
    }

    public void setInitializeLogging(boolean bl) {
        this.initializeLogging = bl;
    }

    public boolean getInitializeLogging() {
        return this.initializeLogging;
    }

    public void setInitializeRegions(boolean bl) {
        this.initializeRegions = bl;
    }

    public boolean getInitializeRegions() {
        return this.initializeRegions;
    }

    public void setInitializeReplication(boolean bl) {
        this.initializeReplication = bl;
    }

    public boolean getInitializeReplication() {
        return this.initializeReplication;
    }

    public void setJoinEnvironment(boolean bl) {
        this.joinEnvironment = bl;
    }

    public boolean getJoinEnvironment() {
        return this.joinEnvironment;
    }

    public void setLockConflicts(byte[][] byArray) {
        this.lockConflicts = byArray;
    }

    public byte[][] getLockConflicts() {
        return this.lockConflicts;
    }

    public void setLockDetectMode(LockDetectMode lockDetectMode) {
        this.lockDetectMode = lockDetectMode;
    }

    public LockDetectMode getLockDetectMode() {
        return this.lockDetectMode;
    }

    public void setLockDown(boolean bl) {
        this.lockDown = bl;
    }

    public boolean getLockDown() {
        return this.lockDown;
    }

    public void setLockTimeout(long l) {
        this.lockTimeout = l;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLogAutoRemove(boolean bl) {
        this.logAutoRemove = bl;
    }

    public boolean getLogAutoRemove() {
        return this.logAutoRemove;
    }

    public void setLogInMemory(boolean bl) {
        this.logInMemory = bl;
    }

    public boolean getLogInMemory() {
        return this.logInMemory;
    }

    public void setLogRecordHandler(LogRecordHandler logRecordHandler) {
        this.logRecordHandler = logRecordHandler;
    }

    public LogRecordHandler getLogRecordHandler() {
        return this.logRecordHandler;
    }

    public void setMaxLocks(int n) {
        this.maxLocks = n;
    }

    public int getMaxLocks() {
        return this.maxLocks;
    }

    public void setMaxLockers(int n) {
        this.maxLockers = n;
    }

    public int getMaxLockers() {
        return this.maxLockers;
    }

    public void setMaxLockObjects(int n) {
        this.maxLockObjects = n;
    }

    public int getMaxLockObjects() {
        return this.maxLockObjects;
    }

    public void setMaxLogFileSize(int n) {
        this.maxLogFileSize = n;
    }

    public int getMaxLogFileSize() {
        return this.maxLogFileSize;
    }

    public void setLogBufferSize(int n) {
        this.logBufferSize = n;
    }

    public int getLogBufferSize() {
        return this.logBufferSize;
    }

    public void setLogDirectory(File file) {
        this.logDirectory = file;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogFileMode(int n) {
        this.logFileMode = n;
    }

    public int getLogFileMode() {
        return this.logFileMode;
    }

    public void setLogRegionSize(int n) {
        this.logRegionSize = n;
    }

    public int getLogRegionSize() {
        return this.logRegionSize;
    }

    public void setMaxOpenFiles(int n) {
        this.maxOpenFiles = n;
    }

    public int getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public void setMaxWrite(int n, int n2) {
        this.maxWrite = n;
        this.maxWriteSleep = n2;
    }

    public int getMaxWrite() {
        return this.maxWrite;
    }

    public int getMaxWriteSleep() {
        return this.maxWriteSleep;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageStream(OutputStream outputStream) {
        this.messageStream = outputStream;
    }

    public OutputStream getMessageStream() {
        return this.messageStream;
    }

    public void setMMapSize(long l) {
        this.mmapSize = l;
    }

    public long getMMapSize() {
        return this.mmapSize;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public long getMode() {
        return this.mode;
    }

    public void setNoLocking(boolean bl) {
        this.noLocking = bl;
    }

    public boolean getNoLocking() {
        return this.noLocking;
    }

    public void setNoMMap(boolean bl) {
        this.noMMap = bl;
    }

    public boolean getNoMMap() {
        return this.noMMap;
    }

    public void setNoPanic(boolean bl) {
        this.noPanic = bl;
    }

    public boolean getNoPanic() {
        return this.noPanic;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void setPanicHandler(PanicHandler panicHandler) {
        this.panicHandler = panicHandler;
    }

    public PanicHandler getPanicHandler() {
        return this.panicHandler;
    }

    public void setPrivate(boolean bl) {
        this.isPrivate = bl;
    }

    public boolean getPrivate() {
        return this.isPrivate;
    }

    public void setReplicationLimit(long l) {
        this.replicationLimit = l;
    }

    public long getReplicationLimit() {
        return this.replicationLimit;
    }

    public void setReplicationRequestMin(int n) {
        this.replicationRequestMin = n;
    }

    public int getReplicationRequestMin() {
        return this.replicationRequestMin;
    }

    public void setReplicationRequestMax(int n) {
        this.replicationRequestMax = n;
    }

    public int getReplicationRequestMax() {
        return this.replicationRequestMax;
    }

    public void setReplicationTransport(int n, ReplicationTransport replicationTransport) {
        this.envid = n;
        this.replicationTransport = replicationTransport;
    }

    public ReplicationTransport getReplicationTransport() {
        return this.replicationTransport;
    }

    public void setRegister(boolean bl) {
        this.register = bl;
    }

    public boolean getRegister() {
        return this.register;
    }

    public void setRunFatalRecovery(boolean bl) {
        this.runFatalRecovery = bl;
    }

    public boolean getRunFatalRecovery() {
        return this.runFatalRecovery;
    }

    public void setRunRecovery(boolean bl) {
        this.runRecovery = bl;
    }

    public boolean getRunRecovery() {
        return this.runRecovery;
    }

    public void setSystemMemory(boolean bl) {
        this.systemMemory = bl;
    }

    public boolean getSystemMemory() {
        return this.systemMemory;
    }

    public void setRPCServer(String string, long l, long l2) {
        this.rpcServer = string;
        this.rpcClientTimeout = l;
        this.rpcServerTimeout = l2;
        this.threaded = false;
    }

    public void setSegmentId(long l) {
        this.segmentId = l;
    }

    public long getSegmentId() {
        return this.segmentId;
    }

    public void setTemporaryDirectory(File file) {
        this.temporaryDirectory = file;
    }

    public void setTemporaryDirectory(String string) {
        this.setTemporaryDirectory(new File(string));
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public void setMutexAlignment(int n) {
        this.mutexAlignment = n;
    }

    public int getMutexAlignment() {
        return this.mutexAlignment;
    }

    public void setMutexIncrement(int n) {
        this.mutexIncrement = n;
    }

    public int getMutexIncrement() {
        return this.mutexIncrement;
    }

    public void setMaxMutexes(int n) {
        this.maxMutexes = n;
    }

    public int getMaxMutexes() {
        return this.maxMutexes;
    }

    public void setMutexTestAndSetSpins(int n) {
        this.mutexTestAndSetSpins = n;
    }

    public int getMutexTestAndSetSpins() {
        return this.mutexTestAndSetSpins;
    }

    public void setTestAndSetSpins(int n) {
        this.setMutexTestAndSetSpins(n);
    }

    public int getTestAndSetSpins() {
        return this.getMutexTestAndSetSpins();
    }

    public void setThreaded(boolean bl) {
        this.threaded = bl;
    }

    public boolean getThreaded() {
        return this.threaded;
    }

    public void setTransactional(boolean bl) {
        this.transactional = bl;
    }

    public boolean getTransactional() {
        return this.transactional;
    }

    public void setTxnNoSync(boolean bl) {
        this.txnNoSync = bl;
    }

    public boolean getTxnNoSync() {
        return this.txnNoSync;
    }

    public void setTxnNotDurable(boolean bl) {
        this.txnNotDurable = bl;
    }

    public boolean getTxnNotDurable() {
        return this.txnNotDurable;
    }

    public void setTxnMaxActive(int n) {
        this.txnMaxActive = n;
    }

    public int getTxnMaxActive() {
        return this.txnMaxActive;
    }

    public void setTxnTimeout(long l) {
        this.txnTimeout = l;
    }

    public long getTxnTimeout() {
        return this.txnTimeout;
    }

    public void setTxnTimestamp(Date date) {
        this.txnTimestamp = date;
    }

    public Date getTxnTimestamp() {
        return this.txnTimestamp;
    }

    public void setTxnWriteNoSync(boolean bl) {
        this.txnWriteNoSync = bl;
    }

    public boolean getTxnWriteNoSync() {
        return this.txnWriteNoSync;
    }

    public void setUseEnvironment(boolean bl) {
        this.useEnvironment = bl;
    }

    public boolean getUseEnvironment() {
        return this.useEnvironment;
    }

    public void setUseEnvironmentRoot(boolean bl) {
        this.useEnvironmentRoot = bl;
    }

    public boolean getUseEnvironmentRoot() {
        return this.useEnvironmentRoot;
    }

    public void setVerboseDeadlock(boolean bl) {
        this.verboseDeadlock = bl;
    }

    public boolean getVerboseDeadlock() {
        return this.verboseDeadlock;
    }

    public void setVerboseRecovery(boolean bl) {
        this.verboseRecovery = bl;
    }

    public boolean getVerboseRecovery() {
        return this.verboseRecovery;
    }

    public void setVerboseRegister(boolean bl) {
        this.verboseRegister = bl;
    }

    public boolean getVerboseRegister() {
        return this.verboseRegister;
    }

    public void setVerboseReplication(boolean bl) {
        this.verboseReplication = bl;
    }

    public boolean getVerboseReplication() {
        return this.verboseReplication;
    }

    public void setVerboseWaitsFor(boolean bl) {
        this.verboseWaitsFor = bl;
    }

    public boolean getVerboseWaitsFor() {
        return this.verboseWaitsFor;
    }

    public void setYieldCPU(boolean bl) {
        this.yieldCPU = bl;
    }

    public boolean getYieldCPU() {
        return this.yieldCPU;
    }

    private boolean lockConflictsEqual(byte[][] byArray, byte[][] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null || byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n].length != byArray2[n].length) {
                return false;
            }
            int n2 = 0;
            while (n2 < byArray[n].length) {
                if (byArray[n][n2] != byArray2[n][n2]) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    DbEnv openEnvironment(File file) throws DatabaseException, FileNotFoundException {
        DbEnv dbEnv;
        block5: {
            DbEnv dbEnv2 = this.createEnvironment();
            int n = 0;
            n |= this.allowCreate ? 1 : 0;
            n |= this.initializeCache ? 65536 : 0;
            n |= this.initializeCDB ? 8192 : 0;
            n |= this.initializeLocking ? 16384 : 0;
            n |= this.initializeLogging ? 32768 : 0;
            n |= this.initializeReplication ? 131072 : 0;
            n |= this.joinEnvironment ? 0 : 0;
            n |= this.lockDown ? 524288 : 0;
            n |= this.isPrivate ? 0x100000 : 0;
            n |= this.register ? 0x400000 : 0;
            n |= this.runRecovery ? 32 : 0;
            n |= this.runFatalRecovery ? 0x200000 : 0;
            n |= this.systemMemory ? 0x800000 : 0;
            n |= this.threaded ? 64 : 0;
            n |= this.transactional ? 262144 : 0;
            n |= this.useEnvironment ? 2048 : 0;
            n |= this.useEnvironmentRoot ? 4096 : 0;
            boolean bl = false;
            try {
                dbEnv2.open(file == null ? null : file.toString(), n, this.mode);
                bl = true;
                dbEnv = dbEnv2;
                Object var5_6 = null;
                if (bl) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_7 = null;
                    if (bl) break block6;
                    try {
                        dbEnv2.close(0);
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
            try {
                dbEnv2.close(0);
            }
            catch (Throwable throwable) {}
        }
        return dbEnv;
    }

    DbEnv createEnvironment() throws DatabaseException {
        int n = 0;
        if (this.rpcServer != null) {
            n |= 2;
        }
        DbEnv dbEnv = new DbEnv(n);
        this.configureEnvironment(dbEnv, DEFAULT);
        return dbEnv;
    }

    void configureEnvironment(DbEnv dbEnv, EnvironmentConfig environmentConfig) throws DatabaseException {
        if (this.errorHandler != environmentConfig.errorHandler) {
            dbEnv.set_errcall(this.errorHandler);
        }
        if (this.errorPrefix != environmentConfig.errorPrefix && this.errorPrefix != null && !this.errorPrefix.equals(environmentConfig.errorPrefix)) {
            dbEnv.set_errpfx(this.errorPrefix);
        }
        if (this.errorStream != environmentConfig.errorStream) {
            dbEnv.set_error_stream(this.errorStream);
        }
        if (this.rpcServer != environmentConfig.rpcServer || this.rpcClientTimeout != environmentConfig.rpcClientTimeout || this.rpcServerTimeout != environmentConfig.rpcServerTimeout) {
            dbEnv.set_rpc_server(null, this.rpcServer, this.rpcClientTimeout, this.rpcServerTimeout, 0);
        }
        int n = 0x10000000;
        int n2 = 0;
        if (this.cdbLockAllDatabases && !environmentConfig.cdbLockAllDatabases) {
            n |= 0x2000;
        }
        if (!this.cdbLockAllDatabases && environmentConfig.cdbLockAllDatabases) {
            n2 |= 0x2000;
        }
        if (this.directDatabaseIO && !environmentConfig.directDatabaseIO) {
            n |= 0x4000;
        }
        if (!this.directDatabaseIO && environmentConfig.directDatabaseIO) {
            n2 |= 0x4000;
        }
        if (this.directLogIO && !environmentConfig.directLogIO) {
            n |= 0x8000;
        }
        if (!this.directLogIO && environmentConfig.directLogIO) {
            n2 |= 0x8000;
        }
        if (this.dsyncDatabases && !environmentConfig.dsyncDatabases) {
            n |= 0x10000;
        }
        if (!this.dsyncDatabases && environmentConfig.dsyncDatabases) {
            n2 |= 0x10000;
        }
        if (this.dsyncLog && !environmentConfig.dsyncLog) {
            n |= 0x20000;
        }
        if (!this.dsyncLog && environmentConfig.dsyncLog) {
            n2 |= 0x20000;
        }
        if (this.initializeRegions && !environmentConfig.initializeRegions) {
            n |= 0x8000000;
        }
        if (!this.initializeRegions && environmentConfig.initializeRegions) {
            n2 |= 0x8000000;
        }
        if (this.logAutoRemove && !environmentConfig.logAutoRemove) {
            n |= 0x40000;
        }
        if (!this.logAutoRemove && environmentConfig.logAutoRemove) {
            n2 |= 0x40000;
        }
        if (this.logInMemory && !environmentConfig.logInMemory) {
            n |= 0x80000;
        }
        if (!this.logInMemory && environmentConfig.logInMemory) {
            n2 |= 0x80000;
        }
        if (this.noLocking && !environmentConfig.noLocking) {
            n |= 0x100000;
        }
        if (!this.noLocking && environmentConfig.noLocking) {
            n2 |= 0x100000;
        }
        if (this.noMMap && !environmentConfig.noMMap) {
            n |= 8;
        }
        if (!this.noMMap && environmentConfig.noMMap) {
            n2 |= 8;
        }
        if (this.noPanic && !environmentConfig.noPanic) {
            n |= 0x200000;
        }
        if (!this.noPanic && environmentConfig.noPanic) {
            n2 |= 0x200000;
        }
        if (this.overwrite && !environmentConfig.overwrite) {
            n |= 0x400000;
        }
        if (!this.overwrite && environmentConfig.overwrite) {
            n2 |= 0x400000;
        }
        if (this.txnNoSync && !environmentConfig.txnNoSync) {
            n |= 0x100;
        }
        if (!this.txnNoSync && environmentConfig.txnNoSync) {
            n2 |= 0x100;
        }
        if (this.txnNotDurable && !environmentConfig.txnNotDurable) {
            n |= 0x200;
        }
        if (!this.txnNotDurable && environmentConfig.txnNotDurable) {
            n2 |= 0x200;
        }
        if (this.txnWriteNoSync && !environmentConfig.txnWriteNoSync) {
            n |= 0x400;
        }
        if (!this.txnWriteNoSync && environmentConfig.txnWriteNoSync) {
            n2 |= 0x400;
        }
        if (this.yieldCPU && !environmentConfig.yieldCPU) {
            n |= 0x20000000;
        }
        if (!this.yieldCPU && environmentConfig.yieldCPU) {
            n2 |= 0x20000000;
        }
        if (n != 0) {
            dbEnv.set_flags(n, true);
        }
        if (n2 != 0) {
            dbEnv.set_flags(n2, false);
        }
        if (this.verboseDeadlock && !environmentConfig.verboseDeadlock) {
            dbEnv.set_verbose(1, true);
        }
        if (!this.verboseDeadlock && environmentConfig.verboseDeadlock) {
            dbEnv.set_verbose(1, false);
        }
        if (this.verboseRecovery && !environmentConfig.verboseRecovery) {
            dbEnv.set_verbose(2, true);
        }
        if (!this.verboseRecovery && environmentConfig.verboseRecovery) {
            dbEnv.set_verbose(2, false);
        }
        if (this.verboseRegister && !environmentConfig.verboseRegister) {
            dbEnv.set_verbose(4, true);
        }
        if (!this.verboseRegister && environmentConfig.verboseRegister) {
            dbEnv.set_verbose(4, false);
        }
        if (this.verboseReplication && !environmentConfig.verboseReplication) {
            dbEnv.set_verbose(8, true);
        }
        if (!this.verboseReplication && environmentConfig.verboseReplication) {
            dbEnv.set_verbose(8, false);
        }
        if (this.verboseWaitsFor && !environmentConfig.verboseWaitsFor) {
            dbEnv.set_verbose(16, true);
        }
        if (!this.verboseWaitsFor && environmentConfig.verboseWaitsFor) {
            dbEnv.set_verbose(16, false);
        }
        if (this.feedbackHandler != environmentConfig.feedbackHandler) {
            dbEnv.set_feedback(this.feedbackHandler);
        }
        if (this.logRecordHandler != environmentConfig.logRecordHandler) {
            dbEnv.set_app_dispatch(this.logRecordHandler);
        }
        if (this.messageHandler != environmentConfig.messageHandler) {
            dbEnv.set_msgcall(this.messageHandler);
        }
        if (this.panicHandler != environmentConfig.panicHandler) {
            dbEnv.set_paniccall(this.panicHandler);
        }
        if (this.replicationTransport != environmentConfig.replicationTransport) {
            dbEnv.set_rep_transport(this.envid, this.replicationTransport);
        }
        if (this.cacheSize != environmentConfig.cacheSize || this.cacheCount != environmentConfig.cacheCount) {
            dbEnv.set_cachesize(this.cacheSize, this.cacheCount);
        }
        Enumeration enumeration = this.dataDirs.elements();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            if (environmentConfig.dataDirs.contains(file)) continue;
            dbEnv.set_data_dir(file.toString());
        }
        if (!this.lockConflictsEqual(this.lockConflicts, environmentConfig.lockConflicts)) {
            dbEnv.set_lk_conflicts(this.lockConflicts);
        }
        if (this.lockDetectMode != environmentConfig.lockDetectMode) {
            dbEnv.set_lk_detect(this.lockDetectMode.getFlag());
        }
        if (this.maxLocks != environmentConfig.maxLocks) {
            dbEnv.set_lk_max_locks(this.maxLocks);
        }
        if (this.maxLockers != environmentConfig.maxLockers) {
            dbEnv.set_lk_max_lockers(this.maxLockers);
        }
        if (this.maxLockObjects != environmentConfig.maxLockObjects) {
            dbEnv.set_lk_max_objects(this.maxLockObjects);
        }
        if (this.maxLogFileSize != environmentConfig.maxLogFileSize) {
            dbEnv.set_lg_max(this.maxLogFileSize);
        }
        if (this.logBufferSize != environmentConfig.logBufferSize) {
            dbEnv.set_lg_bsize(this.logBufferSize);
        }
        if (this.logDirectory != environmentConfig.logDirectory && this.logDirectory != null && !this.logDirectory.equals(environmentConfig.logDirectory)) {
            dbEnv.set_lg_dir(this.logDirectory.toString());
        }
        if (this.logFileMode != environmentConfig.logFileMode) {
            dbEnv.set_lg_filemode(this.logFileMode);
        }
        if (this.logRegionSize != environmentConfig.logRegionSize) {
            dbEnv.set_lg_regionmax(this.logRegionSize);
        }
        if (this.maxOpenFiles != environmentConfig.maxOpenFiles) {
            dbEnv.set_mp_max_openfd(this.maxOpenFiles);
        }
        if (this.maxWrite != environmentConfig.maxWrite || this.maxWriteSleep != environmentConfig.maxWriteSleep) {
            dbEnv.set_mp_max_write(this.maxWrite, this.maxWriteSleep);
        }
        if (this.messageStream != environmentConfig.messageStream) {
            dbEnv.set_message_stream(this.messageStream);
        }
        if (this.mmapSize != environmentConfig.mmapSize) {
            dbEnv.set_mp_mmapsize(this.mmapSize);
        }
        if (this.password != null) {
            dbEnv.set_encrypt(this.password, 1);
        }
        if (this.replicationLimit != environmentConfig.replicationLimit) {
            dbEnv.set_rep_limit(this.replicationLimit);
        }
        if (this.replicationRequestMin != environmentConfig.replicationRequestMin || this.replicationRequestMax != environmentConfig.replicationRequestMax) {
            dbEnv.set_rep_request(this.replicationRequestMin, this.replicationRequestMax);
        }
        if (this.segmentId != environmentConfig.segmentId) {
            dbEnv.set_shm_key(this.segmentId);
        }
        if (this.mutexAlignment != environmentConfig.mutexAlignment) {
            dbEnv.mutex_set_align(this.mutexAlignment);
        }
        if (this.mutexIncrement != environmentConfig.mutexIncrement) {
            dbEnv.mutex_set_increment(this.mutexIncrement);
        }
        if (this.maxMutexes != environmentConfig.maxMutexes) {
            dbEnv.mutex_set_max(this.maxMutexes);
        }
        if (this.mutexTestAndSetSpins != environmentConfig.mutexTestAndSetSpins) {
            dbEnv.mutex_set_tas_spins(this.mutexTestAndSetSpins);
        }
        if (this.lockTimeout != environmentConfig.lockTimeout) {
            dbEnv.set_timeout(this.lockTimeout, 29);
        }
        if (this.txnMaxActive != environmentConfig.txnMaxActive) {
            dbEnv.set_tx_max(this.txnMaxActive);
        }
        if (this.txnTimeout != environmentConfig.txnTimeout) {
            dbEnv.set_timeout(this.txnTimeout, 33);
        }
        if (this.txnTimestamp != environmentConfig.txnTimestamp && this.txnTimestamp != null && !this.txnTimestamp.equals(environmentConfig.txnTimestamp)) {
            dbEnv.set_tx_timestamp(this.txnTimestamp);
        }
        if (this.temporaryDirectory != environmentConfig.temporaryDirectory && this.temporaryDirectory != null && !this.temporaryDirectory.equals(environmentConfig.temporaryDirectory)) {
            dbEnv.set_tmp_dir(this.temporaryDirectory.toString());
        }
    }

    EnvironmentConfig(DbEnv dbEnv) throws DatabaseException {
        String[] stringArray;
        int n = dbEnv.get_open_flags();
        this.allowCreate = (n & 1) != 0;
        this.initializeCache = (n & 0x10000) != 0;
        this.initializeCDB = (n & 0x2000) != 0;
        this.initializeLocking = (n & 0x4000) != 0;
        this.initializeLogging = (n & 0x8000) != 0;
        this.initializeReplication = (n & 0x20000) != 0;
        this.joinEnvironment = false;
        this.lockDown = (n & 0x80000) != 0;
        this.isPrivate = (n & 0x100000) != 0;
        this.register = (n & 0x400000) != 0;
        this.runRecovery = (n & 0x20) != 0;
        this.runFatalRecovery = (n & 0x200000) != 0;
        this.systemMemory = (n & 0x800000) != 0;
        this.threaded = (n & 0x40) != 0;
        this.transactional = (n & 0x40000) != 0;
        this.useEnvironment = (n & 0x800) != 0;
        this.useEnvironmentRoot = (n & 0x1000) != 0;
        int n2 = dbEnv.get_flags();
        this.cdbLockAllDatabases = (n2 & 0x2000) != 0;
        this.directDatabaseIO = (n2 & 0x4000) != 0;
        this.directLogIO = (n2 & 0x8000) != 0;
        this.dsyncDatabases = (n2 & 0x10000) != 0;
        this.dsyncLog = (n2 & 0x20000) != 0;
        this.initializeRegions = (n2 & 0x8000000) != 0;
        this.logAutoRemove = (n2 & 0x40000) != 0;
        this.logInMemory = (n2 & 0x80000) != 0;
        this.noLocking = (n2 & 0x100000) != 0;
        this.noMMap = (n2 & 8) != 0;
        this.noPanic = (n2 & 0x200000) != 0;
        this.overwrite = (n2 & 0x400000) != 0;
        this.txnNoSync = (n2 & 0x100) != 0;
        this.txnNotDurable = (n2 & 0x200) != 0;
        this.txnWriteNoSync = (n2 & 0x400) != 0;
        this.yieldCPU = (n2 & 0x20000000) != 0;
        this.verboseDeadlock = dbEnv.get_verbose(1);
        this.verboseRecovery = dbEnv.get_verbose(2);
        this.verboseRegister = dbEnv.get_verbose(4);
        this.verboseReplication = dbEnv.get_verbose(8);
        this.verboseWaitsFor = dbEnv.get_verbose(16);
        this.errorHandler = dbEnv.get_errcall();
        this.feedbackHandler = dbEnv.get_feedback();
        this.logRecordHandler = dbEnv.get_app_dispatch();
        this.messageHandler = dbEnv.get_msgcall();
        this.panicHandler = dbEnv.get_paniccall();
        if (this.initializeCache) {
            this.cacheSize = dbEnv.get_cachesize();
            this.cacheCount = dbEnv.get_cachesize_ncache();
            this.mmapSize = dbEnv.get_mp_mmapsize();
            this.maxOpenFiles = dbEnv.get_mp_max_openfd();
            this.maxWrite = dbEnv.get_mp_max_write();
            this.maxWriteSleep = dbEnv.get_mp_max_write_sleep();
        }
        if ((stringArray = dbEnv.get_data_dirs()) == null) {
            stringArray = new String[]{};
        }
        this.dataDirs = new Vector(stringArray.length);
        this.dataDirs.setSize(stringArray.length);
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.dataDirs.set(n3, new File(stringArray[n3]));
            ++n3;
        }
        this.errorPrefix = dbEnv.get_errpfx();
        this.errorStream = dbEnv.get_error_stream();
        if (this.initializeLocking) {
            this.lockConflicts = dbEnv.get_lk_conflicts();
            this.lockDetectMode = LockDetectMode.fromFlag(dbEnv.get_lk_detect());
            this.lockTimeout = dbEnv.get_timeout(29);
            this.maxLocks = dbEnv.get_lk_max_locks();
            this.maxLockers = dbEnv.get_lk_max_lockers();
            this.maxLockObjects = dbEnv.get_lk_max_objects();
            this.txnTimeout = dbEnv.get_timeout(33);
        } else {
            this.lockConflicts = null;
            this.lockDetectMode = LockDetectMode.NONE;
            this.lockTimeout = 0L;
            this.maxLocks = 0;
            this.maxLockers = 0;
            this.maxLockObjects = 0;
            this.txnTimeout = 0L;
        }
        if (this.initializeLogging) {
            this.maxLogFileSize = dbEnv.get_lg_max();
            this.logBufferSize = dbEnv.get_lg_bsize();
            this.logDirectory = dbEnv.get_lg_dir() == null ? null : new File(dbEnv.get_lg_dir());
            this.logFileMode = dbEnv.get_lg_filemode();
            this.logRegionSize = dbEnv.get_lg_regionmax();
        } else {
            this.maxLogFileSize = 0;
            this.logBufferSize = 0;
            this.logDirectory = null;
            this.logRegionSize = 0;
        }
        this.messageStream = dbEnv.get_message_stream();
        String string = this.password = dbEnv.get_encrypt_flags() == 0 ? null : "";
        if (this.initializeReplication) {
            this.replicationLimit = dbEnv.get_rep_limit();
        } else {
            this.replicationLimit = 0L;
            this.replicationRequestMin = 0;
            this.replicationRequestMax = 0;
        }
        this.rpcServer = null;
        this.rpcClientTimeout = 0L;
        this.rpcServerTimeout = 0L;
        this.segmentId = dbEnv.get_shm_key();
        this.mutexAlignment = dbEnv.mutex_get_align();
        this.mutexIncrement = dbEnv.mutex_get_increment();
        this.maxMutexes = dbEnv.mutex_get_max();
        this.mutexTestAndSetSpins = dbEnv.mutex_get_tas_spins();
        if (this.transactional) {
            this.txnMaxActive = dbEnv.get_tx_max();
            long l = dbEnv.get_tx_timestamp();
            this.txnTimestamp = l != 0L ? new Date(l * 1000L) : null;
        } else {
            this.txnMaxActive = 0;
            this.txnTimestamp = null;
        }
        this.temporaryDirectory = new File(dbEnv.get_tmp_dir());
    }
}

