/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbSequence;
import com.sleepycat.db.internal.DbTxn;

public class SequenceConfig
implements Cloneable {
    public static final SequenceConfig DEFAULT = new SequenceConfig();
    private int cacheSize = 0;
    private long rangeMin = Long.MIN_VALUE;
    private long rangeMax = Long.MAX_VALUE;
    private long initialValue = 0L;
    private boolean allowCreate = false;
    private boolean decrement = false;
    private boolean exclusiveCreate = false;
    private boolean autoCommitNoSync = false;
    private boolean wrap = false;

    static SequenceConfig checkNull(SequenceConfig sequenceConfig) {
        return sequenceConfig == null ? DEFAULT : sequenceConfig;
    }

    public SequenceConfig() {
    }

    public void setAllowCreate(boolean bl) {
        this.allowCreate = bl;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setDecrement(boolean bl) {
        this.decrement = bl;
    }

    public boolean getDecrement() {
        return this.decrement;
    }

    public void setExclusiveCreate(boolean bl) {
        this.exclusiveCreate = bl;
    }

    public boolean getExclusiveCreate() {
        return this.exclusiveCreate;
    }

    public void setInitialValue(long l) {
        this.initialValue = l;
    }

    public long getInitialValue() {
        return this.initialValue;
    }

    public void setAutoCommitNoSync(boolean bl) {
        this.autoCommitNoSync = bl;
    }

    public boolean getAutoCommitNoSync() {
        return this.autoCommitNoSync;
    }

    public void setRange(long l, long l2) {
        this.rangeMin = l;
        this.rangeMax = l2;
    }

    public long getRangeMin() {
        return this.rangeMin;
    }

    public long getRangeMax() {
        return this.rangeMax;
    }

    public void setWrap(boolean bl) {
        this.wrap = bl;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    DbSequence createSequence(Db db) throws DatabaseException {
        int n = 0;
        return new DbSequence(db, n);
    }

    DbSequence openSequence(Db db, DbTxn dbTxn, DatabaseEntry databaseEntry) throws DatabaseException {
        DbSequence dbSequence;
        block6: {
            DbSequence dbSequence2 = this.createSequence(db);
            boolean bl = (db.get_open_flags() & 0x40) != 0;
            int n = 0;
            n |= this.allowCreate ? 1 : 0;
            n |= this.exclusiveCreate ? 8192 : 0;
            n |= bl ? 64 : 0;
            if (db.get_transactional() && dbTxn == null) {
                n |= 0x1000000;
            }
            this.configureSequence(dbSequence2, DEFAULT);
            boolean bl2 = false;
            try {
                dbSequence2.open(dbTxn, databaseEntry, n);
                bl2 = true;
                dbSequence = dbSequence2;
                Object var8_9 = null;
                if (bl2) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var8_10 = null;
                    if (bl2) break block7;
                    try {
                        dbSequence2.close(0);
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
            try {
                dbSequence2.close(0);
            }
            catch (Throwable throwable) {}
        }
        return dbSequence;
    }

    void configureSequence(DbSequence dbSequence, SequenceConfig sequenceConfig) throws DatabaseException {
        int n = 0;
        n |= this.decrement ? 1 : 2;
        if ((n |= this.wrap ? 8 : 0) != 0) {
            dbSequence.set_flags(n);
        }
        if (this.rangeMin != sequenceConfig.rangeMin || this.rangeMax != sequenceConfig.rangeMax) {
            dbSequence.set_range(this.rangeMin, this.rangeMax);
        }
        if (this.initialValue != sequenceConfig.initialValue) {
            dbSequence.initial_value(this.initialValue);
        }
        if (this.cacheSize != sequenceConfig.cacheSize) {
            dbSequence.set_cachesize(this.cacheSize);
        }
    }

    SequenceConfig(DbSequence dbSequence) throws DatabaseException {
        this.allowCreate = false;
        this.exclusiveCreate = false;
        int n = dbSequence.get_flags();
        this.decrement = (n & 1) != 0;
        this.wrap = (n & 8) != 0;
        this.cacheSize = dbSequence.get_cachesize();
        this.rangeMin = dbSequence.get_range_min();
        this.rangeMax = dbSequence.get_range_max();
    }
}

