/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db.internal;

public class DbUtil {
    private static final boolean big_endian = DbUtil.is_big_endian();

    public static int array2int(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n;
        if (big_endian) {
            n5 = byArray[n6++];
            n4 = byArray[n6++];
            n3 = byArray[n6++];
            n2 = byArray[n6];
        } else {
            n2 = byArray[n6++];
            n3 = byArray[n6++];
            n4 = byArray[n6++];
            n5 = byArray[n6];
        }
        if (n2 < 0) {
            n2 += 256;
        }
        if (n3 < 0) {
            n3 += 256;
        }
        if (n4 < 0) {
            n4 += 256;
        }
        if (n5 < 0) {
            n5 += 256;
        }
        return n2 + (n3 <<= 8) + (n4 <<= 16) + (n5 <<= 24);
    }

    public static void int2array(int n, byte[] byArray, int n2) {
        int n3 = n2;
        int n4 = n & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n >> 16 & 0xFF;
        int n7 = n >> 24 & 0xFF;
        if (n4 >= 128) {
            n4 -= 256;
        }
        if (n5 >= 128) {
            n5 -= 256;
        }
        if (n6 >= 128) {
            n6 -= 256;
        }
        if (n7 >= 128) {
            n7 -= 256;
        }
        if (big_endian) {
            byArray[n3++] = (byte)n7;
            byArray[n3++] = (byte)n6;
            byArray[n3++] = (byte)n5;
            byArray[n3] = (byte)n4;
        } else {
            byArray[n3++] = (byte)n4;
            byArray[n3++] = (byte)n5;
            byArray[n3++] = (byte)n6;
            byArray[n3] = (byte)n7;
        }
    }

    public static String byteArrayToString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append('x');
            int n3 = byArray[n2] >> 4 & 0xF;
            if (n3 < 10) {
                stringBuffer.append((char)(48 + n3));
            } else {
                stringBuffer.append((char)(97 + n3 - 10));
            }
            n3 = byArray[n2] & 0xF;
            if (n3 < 10) {
                stringBuffer.append((char)(48 + n3));
            } else {
                stringBuffer.append((char)(97 + n3 - 10));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String objectArrayToString(Object[] objectArray, String string) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\n    " + string + "[" + n2 + "]:\n");
            stringBuffer.append("    " + objectArray[n2].toString());
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static int default_lorder() {
        return big_endian ? 4321 : 1234;
    }

    private static native boolean is_big_endian();
}

