/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util;

public class UtfOps {
    private static byte[] EMPTY_BYTES = new byte[0];
    private static String EMPTY_STRING = "";

    public static int getZeroTerminatedByteLength(byte[] byArray, int n) throws IndexOutOfBoundsException {
        int n2 = 0;
        while (byArray[n++] != 0) {
            ++n2;
        }
        return n2;
    }

    public static int getByteLength(char[] cArray) {
        return UtfOps.getByteLength(cArray, 0, cArray.length);
    }

    public static int getByteLength(char[] cArray, int n, int n2) {
        int n3 = 0;
        n2 += n;
        int n4 = n;
        while (n4 < n2) {
            char c = cArray[n4];
            n3 = c >= '\u0001' && c <= '\u007f' ? ++n3 : (c > '\u07ff' ? (n3 += 3) : (n3 += 2));
            ++n4;
        }
        return n3;
    }

    public static int getCharLength(byte[] byArray) throws IllegalArgumentException, IndexOutOfBoundsException {
        return UtfOps.getCharLength(byArray, 0, byArray.length);
    }

    public static int getCharLength(byte[] byArray, int n, int n2) throws IllegalArgumentException, IndexOutOfBoundsException {
        int n3 = 0;
        n2 += n;
        while (n < n2) {
            switch ((byArray[n] & 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n;
                    break;
                }
                case 12: 
                case 13: {
                    n += 2;
                    break;
                }
                case 14: {
                    n += 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++n3;
        }
        return n3;
    }

    public static int bytesToChars(byte[] byArray, int n, char[] cArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IndexOutOfBoundsException {
        n3 += bl ? n : n2;
        while ((bl ? n : n2) < n3) {
            int n4 = byArray[n++] & 0xFF;
            switch ((n4 & 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n2++] = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    byte by = byArray[n++];
                    if ((by & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    cArray[n2++] = (char)((n4 & 0x1F) << 6 | by & 0x3F);
                    break;
                }
                case 14: {
                    byte by = byArray[n++];
                    byte by2 = byArray[n++];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    cArray[n2++] = (char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return n;
    }

    public static void charsToBytes(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        n3 += n;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n2++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n2++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                byArray[n2++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n2++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n4;
        }
    }

    public static String bytesToString(byte[] byArray, int n, int n2) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (n2 == 0) {
            return EMPTY_STRING;
        }
        int n3 = UtfOps.getCharLength(byArray, n, n2);
        char[] cArray = new char[n3];
        UtfOps.bytesToChars(byArray, n, cArray, 0, n2, true);
        return new String(cArray, 0, n3);
    }

    public static byte[] stringToBytes(String string) {
        if (string.length() == 0) {
            return EMPTY_BYTES;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[UtfOps.getByteLength(cArray)];
        UtfOps.charsToBytes(cArray, 0, byArray, 0, cArray.length);
        return byArray;
    }
}

