/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.grddl.impl;

import com.hp.hpl.jena.grddl.GRDDLReader;
import com.hp.hpl.jena.grddl.GRDDLSecurityException;
import com.hp.hpl.jena.grddl.impl.GRDDLWarningException;
import com.hp.hpl.jena.grddl.impl.Rewindable;
import com.hp.hpl.jena.grddl.impl.SafeURIResolver;
import com.hp.hpl.jena.grddl.impl.SeenEnoughExpectedException;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.SAX2Model;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.cache.Cache;
import com.hp.hpl.jena.util.cache.CacheManager;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class GRDDL {
    final List<String> transforms = new ArrayList<String>();
    public static final String NAMESPACE = "http://www.w3.org/2003/g/data-view#";
    public static final String PROFILE = "http://www.w3.org/2003/g/data-view";
    public static final String[] XHTMLNS = new String[]{"http://www.w3.org/1999/xhtml", "http://www.w3.org/2002/06/xhtml2/"};
    private static final Property ProfileTransformation = ResourceFactory.createProperty((String)"http://www.w3.org/2003/g/data-view#", (String)"profileTransformation");
    private static final Property NamespaceTransformation = ResourceFactory.createProperty((String)"http://www.w3.org/2003/g/data-view#", (String)"namespaceTransformation");
    final Model model;
    final GRDDLReader reader;
    final Rewindable input;
    Thread subThread = null;
    private PipedWriter pipe;
    private boolean needTidy = false;
    static Cache known = CacheManager.createCache((String)"RAND", (String)"GRDDL schema/profile cache", (int)300);
    public static final Log logger = LogFactory.getLog(GRDDL.class);

    public GRDDL(GRDDLReader r, Model m, Rewindable rw) {
        this.trace("GRDDL: " + rw.resolve(""));
        this.model = m;
        this.reader = r;
        this.input = rw;
    }

    public synchronized void go() throws IOException {
        this.initialParse();
        this.applyTransforms();
    }

    private TransformerFactory xformFactory() {
        return this.reader.xformFactory;
    }

    private void initialParse() throws IOException {
        this.needTidy = false;
        SAXResult r = new SAXResult(new InitialContentHandler());
        try {
            Transformer idTransform;
            block16: {
                idTransform = this.xformFactory().newTransformer();
                try {
                    idTransform.transform(this.input.startAfresh(true), r);
                }
                catch (SeenEnoughExpectedException e) {
                }
                catch (TransformerException e) {
                    if (e.getCause().getClass().equals(SeenEnoughExpectedException.class)) break block16;
                    throw e;
                }
            }
            if (this.needTidy) {
                this.input.useTidy(this.reader.tidyParser);
                r = new SAXResult(new InitialContentHandler());
                idTransform.transform(this.input.startAfresh(true), r);
            }
        }
        catch (SeenEnoughExpectedException e) {
        }
        catch (TransformerException e) {
            if (!e.getCause().getClass().equals(SeenEnoughExpectedException.class)) {
                throw new JenaException((Throwable)e);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception nrte) {
            throw new JenaException((Throwable)nrte);
        }
        finally {
            this.input.close();
        }
    }

    private void applyTransforms() {
        Iterator<String> it = this.transforms.iterator();
        while (it.hasNext()) {
            String n = it.next();
            this.transformWith(n, it.hasNext());
        }
    }

    private void transformWith(String string, boolean needRewind) {
        try {
            try {
                Transformer t = this.transformerFor(string);
                Result result = this.resultFor(t);
                t.transform(this.input.startAfresh(needRewind), result);
                if (result instanceof StreamResult) {
                    ((StreamResult)result).getWriter().close();
                }
                if (this.subThread != null) {
                    this.subThread.join();
                }
                this.subThread = null;
            }
            catch (TransformerException e) {
                this.fatalError(e);
            }
            catch (SAXParseException e) {
                this.fatalError(e);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("In GRDDL transformWith");
            }
            finally {
                this.input.close();
                if (this.subThread != null) {
                    this.subThread.interrupt();
                }
            }
        }
        catch (IOException ioe) {
            this.fatalError(ioe);
        }
    }

    private void fatalError(Exception e) {
        this.reader.checkException(e);
        this.reader.eHandler().fatalError(e);
    }

    private Result resultFor(Transformer t) throws SAXParseException, IOException {
        String mimeType = t.getOutputProperty("media-type");
        if (mimeType != null && mimeType.equalsIgnoreCase("text/rdf+n3")) {
            return this.n3result();
        }
        return this.rdfXmlResult();
    }

    private Result n3result() throws IOException {
        this.pipe = new PipedWriter();
        final PipedReader pr = new PipedReader(this.pipe);
        StreamResult rslt = new StreamResult(this.pipe);
        this.subThread = new Thread(){

            public void run() {
                GRDDL.this.reader.n3.read(GRDDL.this.model, (Reader)pr, GRDDL.this.input.resolve(""));
            }
        };
        this.subThread.start();
        return rslt;
    }

    private Result rdfXmlResult() throws SAXParseException {
        SAX2Model s2m = SAX2Model.create((String)this.input.resolve(""), (Model)this.model);
        s2m.setErrorHandler(this.reader.eHandler());
        s2m.setOptionsWith(((JenaReader)this.reader.rdfxml).getOptions());
        SAXResult r = new SAXResult((ContentHandler)s2m);
        r.setLexicalHandler((LexicalHandler)s2m);
        return r;
    }

    private Transformer transformerFor(String url) throws TransformerException {
        if (url.equals("RDF/XML")) {
            return this.xformFactory().newTransformer();
        }
        try {
            this.reader.lastSecurityException = null;
            Transformer rslt = this.xformFactory().newTransformer(new StreamSource(url));
            rslt.setURIResolver(new SafeURIResolver());
            return rslt;
        }
        catch (AssertionError e) {
            if (((Throwable)((Object)e)).getMessage().startsWith("Failed to load system function: unparsed-text()")) {
                throw new GRDDLSecurityException("unparsed-text() not permitted in this implementation");
            }
            throw e;
        }
        catch (TransformerException e) {
            if (this.reader.lastSecurityException != null) {
                throw this.reader.lastSecurityException;
            }
            throw e;
        }
    }

    public boolean isHtmlMimetype() {
        String mime = this.input.mimetype();
        if (mime == null) {
            return false;
        }
        return mime.equalsIgnoreCase("text/html") || mime.equalsIgnoreCase("application/xhtml+xml");
    }

    public void addTransform(String tUrl) {
        this.trace("transform: " + tUrl);
        if ("http://www.w3.org/2003/g/sq1t.xsl".equals(tUrl)) {
            tUrl = "http://www.w3.org/2001/sw/grddl-wg/td/sq1t.xsl";
        }
        this.transforms.add(tUrl);
    }

    public void checkProfile(String pUrl) {
        this.trace("profile: " + pUrl);
        this.reapTransforms(pUrl, ProfileTransformation);
    }

    private void reapTransforms(String pUrl, Property property) {
        StmtIterator it = this.getModel(pUrl).createResource(pUrl).listProperties(property);
        while (it.hasNext()) {
            RDFNode n = it.nextStatement().getObject();
            if (n.isURIResource()) {
                this.addTransform(((Resource)n).getURI());
                continue;
            }
            this.warning("Bad " + property.getLocalName() + "value in <" + pUrl + ">. No tranform applied for this value.");
        }
    }

    private void warning(String string) {
        this.reader.eHandler().warning((Exception)((Object)new GRDDLWarningException(string)));
    }

    private Model getModel(String url) {
        Model m = (Model)known.get((Object)url);
        if (m == null) {
            m = ModelFactory.createDefaultModel();
            known.put((Object)url, (Object)m);
            this.reader.read(m, url);
        }
        return m;
    }

    public void needTidy() {
        this.trace("needTidy");
        this.needTidy = true;
        throw new SeenEnoughExpectedException();
    }

    public void checkSchema(String uri) {
        this.trace("schema: " + uri);
        if (uri.equals(RDF.getURI())) {
            this.addTransform("RDF/XML");
        } else {
            this.reapTransforms(uri, NamespaceTransformation);
        }
    }

    private void trace(String string) {
        logger.trace((Object)string);
    }

    private class InitialContentHandler
    extends DefaultHandler {
        boolean rootElement = true;
        boolean grddlNamespace = false;
        boolean grddlProfile = false;

        private InitialContentHandler() {
        }

        public void endElement(String uri, String localName, String qname) {
            GRDDL.this.trace("<element: " + qname);
        }

        public void startElement(String uri, String localName, String qname, Attributes attr) throws SAXException {
            GRDDL.this.trace(">element: " + qname);
            if (this.rootElement) {
                boolean html = GRDDL.this.isHtmlMimetype();
                if (this.grddlNamespace) {
                    this.checkRootAttrs(attr);
                }
                if (uri != null && !uri.equals("")) {
                    GRDDL.this.checkSchema(GRDDL.this.input.resolve(uri));
                    for (int i = 0; i < XHTMLNS.length; ++i) {
                        if (!uri.equalsIgnoreCase(XHTMLNS[i])) continue;
                        html = true;
                    }
                } else if (localName.equalsIgnoreCase("html")) {
                    html = true;
                }
                if (!html) {
                    throw new SeenEnoughExpectedException();
                }
                if (!localName.equalsIgnoreCase("html")) {
                    GRDDL.this.needTidy();
                }
            }
            if (!this.grddlProfile) {
                if (localName.equalsIgnoreCase("head")) {
                    this.checkProfileAttrs(attr);
                }
                if (this.rootElement || !this.grddlProfile) {
                    // empty if block
                }
                this.rootElement = false;
                if (!this.grddlProfile) {
                    return;
                }
            }
            if (localName.equalsIgnoreCase("a") || localName.equalsIgnoreCase("link")) {
                this.checkLinkAttrs(attr);
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            if (this.grddlProfile || GRDDL.this.isHtmlMimetype()) {
                GRDDL.this.needTidy();
            }
            GRDDL.this.reader.eHandler().fatalError((Exception)e);
        }

        public void error(SAXParseException e) {
            GRDDL.this.reader.eHandler().error((Exception)e);
        }

        public void warning(SAXParseException e) {
            GRDDL.this.reader.eHandler().warning((Exception)e);
        }

        private void checkLinkAttrs(Attributes attr) {
            String rel = this.getValueIgnoreCase(attr, "rel");
            if (rel != null && rel.equalsIgnoreCase("transformation")) {
                GRDDL.this.addTransform(GRDDL.this.input.resolve(this.getValueIgnoreCase(attr, "href")));
            }
        }

        private String getValueIgnoreCase(Attributes attr, String arg) {
            int ln = attr.getLength();
            for (int i = 0; i < ln; ++i) {
                if (!arg.equalsIgnoreCase(attr.getQName(i))) continue;
                return attr.getValue(i);
            }
            return null;
        }

        private void checkProfileAttrs(Attributes attr) {
            String profs = this.getValueIgnoreCase(attr, "profile");
            if (profs == null) {
                return;
            }
            String[] p = profs.split(" +");
            for (int i = 0; i < p.length; ++i) {
                if (GRDDL.PROFILE.equals(p[i]) || GRDDL.NAMESPACE.equals(p[i])) {
                    this.grddlProfile = true;
                    continue;
                }
                GRDDL.this.checkProfile(GRDDL.this.input.resolve(p[i]));
            }
        }

        private void checkRootAttrs(Attributes attr) {
            String transforms = attr.getValue(GRDDL.NAMESPACE, "transformation");
            if (transforms == null) {
                return;
            }
            String[] t = transforms.split(" +");
            for (int i = 0; i < t.length; ++i) {
                GRDDL.this.addTransform(GRDDL.this.input.resolve(t[i]));
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.rootElement && !this.grddlNamespace && GRDDL.NAMESPACE.equals(uri)) {
                this.grddlNamespace = true;
            }
        }
    }
}

