/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.grddl.impl;

import com.hp.hpl.jena.grddl.GRDDLSecurityException;
import com.hp.hpl.jena.grddl.impl.SeenEnoughExpectedException;
import com.hp.hpl.jena.rdf.arp.impl.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.functions.StandardFunction;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class GRDDLReaderBase {
    SAXParser tidyParser = new SAXParser();
    RDFReader rdfxml;
    RDFReader n3;
    private RDFErrorHandler eHandler = new RDFDefaultErrorHandler();
    final TransformerFactory xformFactory = TransformerFactory.newInstance();
    GRDDLSecurityException lastSecurityException;

    public GRDDLReaderBase() {
        this.xformFactory.setErrorListener(new ErrorListener(){

            public void error(TransformerException e) throws TransformerException {
                if (e.getCause() instanceof SeenEnoughExpectedException) {
                    throw e;
                }
                GRDDLReaderBase.this.checkException(e);
                GRDDLReaderBase.this.eHandler.error((Exception)e);
            }

            public void fatalError(TransformerException e) throws TransformerException {
                GRDDLReaderBase.this.checkException(e);
                GRDDLReaderBase.this.eHandler.fatalError((Exception)e);
                throw e;
            }

            public void warning(TransformerException e) throws TransformerException {
                GRDDLReaderBase.this.eHandler.warning((Exception)e);
            }
        });
        this.xformFactory.setAttribute("http://saxon.sf.net/feature/allow-external-functions", Boolean.FALSE);
        try {
            this.xformFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        this.xformFactory.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        Model m = ModelFactory.createDefaultModel();
        this.rdfxml = m.getReader("RDF/XML");
        this.n3 = m.getReader("N3");
        this.rdfxml.setErrorHandler(this.eHandler);
        this.n3.setErrorHandler(this.eHandler);
        this.setProperty("http://cyberneko.org/html/features/insert-namespaces", "true");
        this.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
        this.tidyParser.setErrorHandler((ErrorHandler)new ARPSaxErrorHandler(this.eHandler));
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.eHandler;
        this.eHandler = errHandler;
        this.rdfxml.setErrorHandler(this.eHandler);
        this.n3.setErrorHandler(this.eHandler);
        ((ARPSaxErrorHandler)this.tidyParser.getErrorHandler()).setErrorHandler(this.eHandler);
        return old;
    }

    protected RDFErrorHandler eHandler() {
        return this.eHandler;
    }

    public Object setProperty(String propName, Object propValue) {
        if (propName.startsWith("http://cyberneko.org/")) {
            try {
                if (propValue instanceof Boolean) {
                    boolean old = this.tidyParser.getFeature(propName);
                    this.tidyParser.setFeature(propName, ((Boolean)propValue).booleanValue());
                    return new Boolean(old);
                }
                if ("true".equals(propValue) || "false".equals(propValue)) {
                    boolean old = this.tidyParser.getFeature(propName);
                    this.tidyParser.setFeature(propName, Boolean.parseBoolean((String)propValue));
                    return new Boolean(old);
                }
                Object old = this.tidyParser.getProperty(propName);
                this.tidyParser.setProperty(propName, propValue);
                return old;
            }
            catch (SAXNotRecognizedException e) {
                this.eHandler.error((Exception)e);
                return null;
            }
            catch (SAXNotSupportedException e) {
                this.eHandler.error((Exception)e);
                return null;
            }
        }
        return this.rdfxml.setProperty(propName, propValue);
    }

    void checkException(Exception e) {
        if (e.getCause() instanceof GRDDLSecurityException) {
            this.lastSecurityException = (GRDDLSecurityException)((Object)e.getCause());
            throw this.lastSecurityException;
        }
        String msg = e.getMessage();
        if (msg.contains("result-document") || msg.contains("disabled") || msg.contains("extension")) {
            this.lastSecurityException = new GRDDLSecurityException(e);
            throw this.lastSecurityException;
        }
    }

    static {
        StandardFunction.Entry unparsedText = StandardFunction.getFunction((String)"unparsed-text", (int)1);
        unparsedText.implementationClass = ProhibitUnparsedText.class;
        unparsedText = StandardFunction.getFunction((String)"unparsed-text-available", (int)1);
        unparsedText.implementationClass = ProhibitUnparsedText.class;
    }

    public static class ProhibitUnparsedText {
        public ProhibitUnparsedText() {
            throw new GRDDLSecurityException("unparsed-text() not permitted in this implementation");
        }
    }
}

