/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.grddl.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class JBufferedReader
extends Reader {
    final Reader base;
    private List<char[]> buffers = null;
    private int bufSz;
    private static final int MAXBUF = 0x100000;
    private int whichBuf = 0;
    private int where = 0;
    private int lastBuf;
    private int lastWhere;
    private int markedWhere;
    private boolean remember = false;
    private boolean replaying = false;
    private int markLimit;
    private int oldMarkLimit;

    public JBufferedReader(Reader base, int bSz) {
        this.base = base;
        this.bufSz = bSz;
    }

    public JBufferedReader(Reader base) {
        this(base, 256);
    }

    public void close() throws IOException {
        this.forget();
        this.base.close();
        this.remember = false;
        this.replaying = false;
        this.where = 0;
        this.whichBuf = 0;
    }

    public int read(char[] buf, int off, int len) throws IOException {
        int nc = this.read1(buf, off, len);
        if (this.replaying || this.remember) {
            this.where += nc;
            this.markLimit -= nc;
            if (this.markLimit < 0) {
                if (!this.replaying) {
                    this.forget();
                }
                this.remember = false;
            }
        }
        return nc;
    }

    public int read1(char[] buf, int off, int len) throws IOException {
        int cRead;
        int space;
        if (this.replaying) {
            char[] currentBuf = this.get();
            int endOfCopiable = this.whichBuf < this.lastBuf ? currentBuf.length : this.lastWhere;
            if (this.where < endOfCopiable) {
                if (len + this.where < endOfCopiable) {
                    System.arraycopy(currentBuf, this.where, buf, off, len);
                    return len;
                }
                int rslt = endOfCopiable - this.where;
                System.arraycopy(currentBuf, this.where, buf, off, rslt);
                if (this.whichBuf == this.lastBuf) {
                    this.replaying = false;
                    if (!this.remember) {
                        this.forget();
                    }
                } else {
                    ++this.whichBuf;
                    this.where = -rslt;
                }
                return rslt;
            }
            throw new AssertionError((Object)"Replay logic");
        }
        if (!this.remember) {
            return this.base.read(buf, off, len);
        }
        char[] currentBuf = this.get();
        if (this.where == currentBuf.length) {
            ++this.whichBuf;
            currentBuf = this.get();
            this.where = 0;
        }
        if ((space = currentBuf.length - this.where) > len) {
            space = len;
        }
        if ((cRead = this.base.read(currentBuf, this.where, space)) > 0) {
            System.arraycopy(currentBuf, this.where, buf, off, cRead);
        }
        return cRead;
    }

    private void forget() {
        this.buffers = null;
        this.whichBuf = 0;
        this.where = 0;
        this.remember = false;
        this.lastWhere = 0;
        this.lastBuf = 0;
    }

    private char[] get() {
        if (this.buffers == null) {
            this.buffers = new ArrayList<char[]>();
        }
        if (this.buffers.size() > this.whichBuf) {
            return this.buffers.get(this.whichBuf);
        }
        char[] rslt = new char[this.bufSz];
        if (this.buffers.size() != this.whichBuf) {
            throw new AssertionError((Object)"buffer logic");
        }
        this.bufSz += this.bufSz;
        if (this.bufSz > 0x100000) {
            this.bufSz = 0x100000;
        }
        this.buffers.add(this.whichBuf, rslt);
        return rslt;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int x) {
        this.markedWhere = this.where;
        while (this.whichBuf > 0) {
            this.buffers.remove(0);
            --this.whichBuf;
            --this.lastBuf;
        }
        this.remember = x > 0;
        this.oldMarkLimit = this.markLimit = x;
    }

    public void reset() throws IOException {
        if (!this.remember) {
            throw new IOException("No valid mark currently set.");
        }
        if (!this.replaying) {
            this.lastWhere = this.where;
            this.lastBuf = this.whichBuf;
            this.replaying = this.whichBuf > 0 || this.where > this.markedWhere;
        }
        this.where = this.markedWhere;
        this.whichBuf = 0;
        this.markLimit = this.oldMarkLimit;
    }

    public boolean ready() throws IOException {
        if (!this.replaying) {
            return this.base.ready();
        }
        if (this.whichBuf == this.lastBuf && this.where == this.lastWhere) {
            this.replaying = false;
            return this.base.ready();
        }
        return true;
    }

    public long skip(long l) throws IOException {
        return super.skip(l);
    }
}

