/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.grddl.impl;

import com.hp.hpl.jena.grddl.impl.Rewindable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.stream.StreamSource;

public class RewindableURL
extends Rewindable {
    final URL url;
    final String encoding;
    final String mimetype;
    StreamSource source;
    private StreamSource openSource = null;

    public RewindableURL(String u) throws IOException {
        super(u);
        this.url = new URL(u);
        URLConnection conn = this.url.openConnection();
        conn.setRequestProperty("accept", "application/rdf+xml; q=0.5, application/xhtml+xml; q=1.0, text/html; q=0.7, application/xml; q=1.0, text/xml; q=0.7, application/rss+xml; q=0.2, */*; q=0.1");
        this.encoding = conn.getContentEncoding();
        this.mimetype = conn.getContentType();
        this.source = this.toStreamSource(conn.getInputStream());
    }

    private StreamSource toStreamSource(InputStream in) throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return new StreamSource(in, this.url.toString());
        }
        return new StreamSource(new InputStreamReader(in, this.encoding), this.url.toString());
    }

    String encoding() {
        return this.encoding;
    }

    String mimetype() {
        return this.mimetype;
    }

    StreamSource startAfreshRaw(boolean rewindable) throws IOException {
        this.close();
        if (this.source != null) {
            this.openSource = this.source;
            this.source = null;
        } else {
            this.openSource = this.toStreamSource(this.reopen().getInputStream());
        }
        return this.openSource;
    }

    private URLConnection reopen() throws IOException {
        URLConnection conn = this.url.openConnection();
        conn.setRequestProperty("accept", this.mimetype);
        conn.setRequestProperty("Cache-Control", "no-cache");
        if (!this.equals(this.encoding, conn.getContentEncoding())) {
            throw new RuntimeException("error handling not implemented");
        }
        if (!this.equals(this.mimetype, conn.getContentType())) {
            throw new RuntimeException("error handling not implemented");
        }
        return conn;
    }

    private boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    void close() throws IOException {
        if (this.openSource != null) {
            if (this.openSource.getInputStream() != null) {
                this.openSource.getInputStream().close();
            }
            if (this.openSource.getReader() != null) {
                this.openSource.getReader().close();
            }
            this.openSource = null;
        }
    }
}

