/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.grddl.test;

import com.hp.hpl.jena.grddl.impl.JBufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class BufferedReadTest
extends TestCase {
    public BufferedReadTest(String name) {
        super(name);
    }

    void p1(Enc a) throws IOException {
        a.mark(50);
        a.read(30);
        a.mark(10);
        a.read(5);
        a.back();
        a.read(8);
        a.back();
        a.read(12);
        a.back();
        a.read(30);
        a.read(55);
        a.mark(2000);
        a.read(305);
        a.read(200);
        a.back();
        a.skip(40);
        a.read(4000);
    }

    void resetAfterMark(Enc a) throws IOException {
        a.mark(5000);
        a.reset();
        a.read(100);
        a.reset();
        a.read(273);
        a.mark(30);
        a.reset();
        a.read(90);
        a.reset();
    }

    void skipping(Enc a) throws IOException {
        a.mark(50);
        a.skip(40);
        a.back();
        a.read(30);
        a.skip(19);
        a.back();
        a.mark(10);
        a.read(5);
        a.back();
        a.read(8);
        a.back();
        a.read(12);
        a.back();
        a.mark(25);
        a.skip(50);
        a.read(30);
        a.read(55);
        a.mark(2000);
        a.read(305);
        a.skip(400);
        a.back();
        a.skip(300);
        a.read(4000);
        a.skip(55);
        a.read(300);
    }

    public void test1() throws IOException {
        Rdr rdr = new Rdr();
        Sums sums = new Sums();
        this.p1(rdr);
        this.p1(sums);
        this.mustBeEqual(rdr.log, sums.log);
    }

    public void testSkipping() throws IOException {
        Rdr rdr = new Rdr();
        Sums sums = new Sums();
        this.skipping(rdr);
        this.skipping(sums);
        this.mustBeEqual(rdr.log, sums.log);
    }

    public void testReset() throws IOException {
        Rdr rdr = new Rdr();
        Sums sums = new Sums();
        this.resetAfterMark(rdr);
        this.resetAfterMark(sums);
        this.mustBeEqual(rdr.log, sums.log);
    }

    private void mustBeEqual(List got, List wanted) {
        BufferedReadTest.assertEquals((int)got.size(), (int)wanted.size());
        Iterator gi = got.iterator();
        Iterator wi = wanted.iterator();
        int step = 0;
        while (gi.hasNext()) {
            Object go = gi.next();
            Object wo = wi.next();
            if (go instanceof char[]) {
                char[] gc = (char[])go;
                char[] wc = (char[])wo;
                BufferedReadTest.assertEquals((int)gc.length, (int)wc.length);
                for (int i = 0; i < gc.length; ++i) {
                    BufferedReadTest.assertEquals((String)("step: " + step), (char)gc[i], (char)wc[i]);
                }
            } else {
                BufferedReadTest.assertEquals((String)("step: " + step), go, wo);
            }
            ++step;
        }
    }

    private class Rdr
    extends Enc {
        char[] data;
        Reader r;
        int rc;

        Rdr() {
            this.data = new char[16000];
            this.rc = 0;
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = (char)(i + 1000);
            }
            this.r = new JBufferedReader(new StringReader(new String(this.data)), 1);
        }

        void fill(char[] b) throws IOException {
            int off = 0;
            int len = b.length;
            while (len > 0) {
                int nc = this.r.read(b, off, len);
                if (nc < 0) {
                    Assert.fail((String)"Premature EOF");
                }
                off += nc;
                len -= nc;
                ++this.rc;
            }
        }

        void mark(int n) throws IOException {
            this.r.mark(n);
        }

        boolean reset() {
            try {
                this.r.reset();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        void skip(int l) throws IOException {
            this.r.skip(l);
        }
    }

    private static abstract class Enc {
        List log = new ArrayList();

        private Enc() {
        }

        abstract void mark(int var1) throws IOException;

        abstract void fill(char[] var1) throws IOException;

        abstract boolean reset();

        abstract void skip(int var1) throws IOException;

        void read(int n) throws IOException {
            char[] b = new char[n];
            this.fill(b);
            this.log.add(b);
        }

        void back() {
            this.log.add(new Boolean(this.reset()));
        }
    }

    public class Sums
    extends Enc {
        int pos;
        int markLimit = -1;
        int mark = 0;

        void fill(char[] b) throws IOException {
            for (int i = 0; i < b.length; ++i) {
                b[i] = (char)(i + 1000 + this.pos);
            }
            this.pos += b.length;
        }

        void mark(int n) {
            this.mark = this.pos;
            this.markLimit = this.pos + n;
        }

        boolean reset() {
            if (this.pos > this.markLimit) {
                return false;
            }
            this.pos = this.mark;
            return true;
        }

        void skip(int l) throws IOException {
            this.pos += l;
        }
    }
}

