/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.grddl.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class JenaApiTest
extends ModelTestBase
implements RDFErrorHandler {
    private int eCnt = 0;

    public JenaApiTest(String name) {
        super(name);
    }

    public void testArpOption() {
        this.eCnt = 0;
        Model m = JenaApiTest.createMemModel();
        RDFReader r = m.getReader("GRDDL");
        r.setErrorHandler((RDFErrorHandler)this);
        r.setProperty("WARN_UNQUALIFIED_ATTRIBUTE", (Object)"EM_IGNORE");
        r.read(m, "http://jena.sf.net/test/grddl/warn.html");
        JenaApiTest.assertEquals((String)"Warning not suppressed", (int)0, (int)this.eCnt);
        Model m2 = JenaApiTest.createMemModel();
        m2.read("http://jena.sf.net/test/grddl/warn.rdf", "http://jena.sf.net/test/grddl/warn.html", "RDF/XML");
        JenaApiTest.assertIsoModels((Model)m2, (Model)m);
    }

    public void testWarningGiven() {
        this.eCnt = 0;
        Model m = JenaApiTest.createMemModel();
        RDFReader r = m.getReader("GRDDL");
        r.setErrorHandler((RDFErrorHandler)this);
        r.read(m, "http://jena.sf.net/test/grddl/warn.html");
        JenaApiTest.assertEquals((String)"Warning not given", (int)1, (int)this.eCnt);
        Model m2 = JenaApiTest.createMemModel();
        m2.read("http://jena.sf.net/test/grddl/warn.rdf", "http://jena.sf.net/test/grddl/warn.html", "RDF/XML");
        JenaApiTest.assertIsoModels((Model)m2, (Model)m);
    }

    public void testInputStream() throws IOException {
        FileInputStream is = new FileInputStream("test/basic.html");
        Model m = JenaApiTest.createMemModel();
        m.read((InputStream)is, "file:test/basic.html", "GRDDL");
        Model m2 = JenaApiTest.createMemModel();
        is = new FileInputStream("test/basic.rdf");
        m2.read((InputStream)is, "file:test/basic.html");
        JenaApiTest.assertIsoModels((Model)m2, (Model)m);
    }

    public void testReader() throws IOException {
        FileReader r = new FileReader("test/basic.html");
        Model m = JenaApiTest.createMemModel();
        m.read((Reader)r, "file:test/basic.html", "GRDDL");
        Model m2 = JenaApiTest.createMemModel();
        FileInputStream is = new FileInputStream("test/basic.rdf");
        m2.read((InputStream)is, "file:test/basic.html");
        JenaApiTest.assertIsoModels((Model)m2, (Model)m);
    }

    public void error(Exception e) {
        ++this.eCnt;
    }

    public void fatalError(Exception e) {
        ++this.eCnt;
    }

    public void warning(Exception e) {
        ++this.eCnt;
    }
}

