/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.grddl.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import junit.framework.TestCase;

class WebEqualityTest
extends TestCase {
    private final String directory;
    private final String input;
    private final String output;

    WebEqualityTest(String d, String i, String o) {
        super(i + " -> " + o);
        this.directory = d;
        this.input = i;
        this.output = o;
    }

    public void runTest() throws IOException {
        Model m1 = ModelFactory.createDefaultModel();
        Model m2 = ModelFactory.createDefaultModel();
        m1.read(this.directory + this.input, "GRDDL");
        URLConnection conn = new URL(this.directory + this.output).openConnection();
        conn.setRequestProperty("accept", "application/rdf+xml, application/xml; q=0.8, text/xml; q=0.7, application/rss+xml; q=0.3, */*; q=0.2");
        String encoding = conn.getContentEncoding();
        if (encoding == null) {
            m2.read(conn.getInputStream(), this.directory + this.input);
        } else {
            m2.read((Reader)new InputStreamReader(conn.getInputStream(), encoding), this.directory + this.input);
        }
        if (!m1.isIsomorphicWith(m2)) {
            if (m1.size() == m2.size()) {
                System.err.println("GRDDL\n=====");
                m1.difference(m2).write((OutputStream)System.err, "N3-TRIPLES");
                System.err.println("RDF/XML\n=======");
                m2.difference(m1).write((OutputStream)System.err, "N3-TRIPLES");
            }
            FileOutputStream fos = new FileOutputStream("C:/temp/" + this.input + ".rdf");
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fos, "utf-8");
            fw.write("<!-- Base used for output: <" + this.directory + this.input + "> -->\r\n");
            m1.write((Writer)fw, "RDF/XML-ABBREV", this.directory + this.input);
            ((Writer)fw).close();
            WebEqualityTest.fail((String)("output (" + m1.size() + " triples) != input (" + m2.size() + " triples)"));
        }
    }
}

