/*
 * Decompiled with CFR 0.152.
 */
package com.quiotix.html.parser;

import com.quiotix.html.parser.HtmlCollector;
import com.quiotix.html.parser.HtmlDocument;
import com.quiotix.html.parser.HtmlDumper;
import com.quiotix.html.parser.HtmlFormatter;
import com.quiotix.html.parser.HtmlParser;
import com.quiotix.html.parser.HtmlScrubber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HtmlStripper
extends HtmlDumper {
    protected static Set html1BlockTags;
    protected static Set html1EmptyTags;
    protected static Set html1Tags;
    protected static String[] html1EmptyTagStrings;
    protected static String[] html1BlockTagStrings;
    protected static String[] html4BlockTagStrings;

    public HtmlStripper(OutputStream os) {
        super(os);
    }

    public HtmlStripper(OutputStream os, String encoding) throws UnsupportedEncodingException {
        super(os, encoding);
    }

    public void visit(HtmlDocument.TagBlock tagBlock) {
        if (!tagBlock.startTag.tagName.toUpperCase().equals("STYLE") && !this.noButSpace(tagBlock.text())) {
            if (!html1BlockTags.contains(tagBlock.startTag.tagName.toUpperCase())) {
                this.visit(tagBlock.body);
            } else {
                super.visit(tagBlock);
            }
        }
    }

    public void visit(HtmlDocument.Tag t) {
        if (html1Tags.contains(t.tagName.toUpperCase())) {
            StringBuffer s = new StringBuffer();
            s.append("<");
            s.append(t.tagName);
            if (!t.tagName.toUpperCase().equals("HTML")) {
                Iterator iterator = t.attributeList.attributes.iterator();
                while (iterator.hasNext()) {
                    HtmlDocument.Attribute attribute = (HtmlDocument.Attribute)iterator.next();
                    if (attribute.name.toUpperCase().equals("STYLE") || attribute.name.toUpperCase().equals("CLASS") || attribute.name.toUpperCase().equals("MSONORMAL")) continue;
                    s.append(" ");
                    s.append(attribute.toString());
                }
            }
            if (t.emptyTag) {
                s.append("/");
            }
            s.append(">");
            this.out.print(s.toString());
        }
    }

    public void visit(HtmlDocument.Comment comment) {
    }

    boolean noButSpace(String in) {
        String s = in.toLowerCase();
        boolean plausible = true;
        while (plausible) {
            if (s.startsWith("&nbsp;")) {
                s = s.substring(6);
                continue;
            }
            if (s.startsWith(" ")) {
                s = s.substring(1);
                continue;
            }
            plausible = false;
        }
        return s.equals("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        FileInputStream r = new FileInputStream(args[0]);
        try {
            HtmlDocument document = new HtmlParser(r).HtmlDocument();
            int scrubberFlags = 106;
            document.accept(new HtmlScrubber(scrubberFlags));
            document.accept(new HtmlCollector());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            document.accept(new HtmlStripper(out));
            ByteArrayInputStream r2 = new ByteArrayInputStream(out.toByteArray());
            HtmlDocument document2 = new HtmlParser(r2).HtmlDocument();
            document2.accept(new HtmlCollector());
            HtmlFormatter formatter = new HtmlFormatter(System.out);
            formatter.setRightMargin(60);
            formatter.setIndent(1);
            document2.accept(formatter);
        }
        finally {
            ((InputStream)r).close();
        }
    }

    static {
        int i;
        html1BlockTags = new HashSet();
        html1EmptyTags = new HashSet();
        html1Tags = new HashSet();
        html1EmptyTagStrings = new String[]{"AREA", "BASE", "BASEFONT", "BR", "COL", "HR", "IMG", "INPUT", "ISINDEX", "LINK", "META", "PARAM", "NEXTID", "PLAINTEXT"};
        html1BlockTagStrings = new String[]{"A", "ADDRESS", "B", "BLOCKQUOTE", "BODY", "CITE", "CODE", "DD", "DFN", "DIR", "DL", "DT", "EM", "H1", "H2", "H3", "H4", "H5", "H6", "HEAD", "HTML", "I", "KBD", "KEY", "LI", "LISTING", "MENU", "OL", "P", "PRE", "SAMP", "STRONG", "TITLE", "TT", "U", "UL", "VAR", "XMP"};
        html4BlockTagStrings = new String[]{"A", "ADDRESS", "B", "BLOCKQUOTE", "BODY", "CITE", "CODE", "DD", "DFN", "DIR", "DL", "DT", "EM", "H1", "H2", "H3", "H4", "H5", "H6", "HEAD", "HTML", "I", "KBD", "KEY", "LI", "LISTING", "MENU", "OL", "P", "PRE", "SAMP", "STRONG", "TITLE", "TABLE", "TR", "TH", "TD", "TT", "U", "UL", "VAR", "XMP"};
        for (i = 0; i < html1EmptyTagStrings.length; ++i) {
            html1BlockTags.add(html1EmptyTagStrings[i]);
        }
        for (i = 0; i < html4BlockTagStrings.length; ++i) {
            html1BlockTags.add(html4BlockTagStrings[i]);
        }
        for (i = 0; i < html1EmptyTagStrings.length; ++i) {
            html1Tags.add(html1EmptyTagStrings[i]);
        }
        for (i = 0; i < html4BlockTagStrings.length; ++i) {
            html1Tags.add(html4BlockTagStrings[i]);
        }
    }
}

