/*
 * Decompiled with CFR 0.152.
 */
package com.quiotix.html.example;

import com.quiotix.html.parser.HtmlCollector;
import com.quiotix.html.parser.HtmlDocument;
import com.quiotix.html.parser.HtmlDumper;
import com.quiotix.html.parser.HtmlFormatter;
import com.quiotix.html.parser.HtmlParser;
import com.quiotix.html.parser.HtmlScrubber;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HtmlFormat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        int i;
        boolean compress = false;
        boolean format = false;
        boolean quote = false;
        int rightMargin = -1;
        int indentIncrement = -1;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if (args[i].equals("-compress")) {
                compress = true;
                format = false;
                continue;
            }
            if (args[i].equals("-format")) {
                compress = false;
                format = true;
                continue;
            }
            if (args[i].equals("-quote")) {
                compress = false;
                format = true;
                quote = true;
                continue;
            }
            if (args[i].equals("-indent") && i + 1 < args.length) {
                compress = false;
                format = true;
                indentIncrement = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (!args[i].equals("-margin") || i + 1 >= args.length) continue;
            rightMargin = Integer.parseInt(args[i + 1]);
            ++i;
        }
        int scrubberFlags = 106;
        while (i < args.length) {
            FileInputStream r = new FileInputStream(args[i]);
            try {
                HtmlFormatter v;
                HtmlDocument document = new HtmlParser(r).HtmlDocument();
                if (compress) {
                    document.accept(new HtmlScrubber(scrubberFlags));
                    document.accept(new HtmlDumper(System.out));
                } else if (format) {
                    document.accept(new HtmlCollector());
                    if (quote) {
                        scrubberFlags |= 0x40;
                    }
                    document.accept(new HtmlScrubber(scrubberFlags));
                    v = new HtmlFormatter(System.out);
                    if (rightMargin != -1) {
                        v.setRightMargin(rightMargin);
                    }
                    if (indentIncrement != -1) {
                        v.setIndent(indentIncrement);
                    }
                    document.accept(v);
                } else {
                    document.accept(new HtmlCollector());
                    document.accept(new HtmlScrubber(scrubberFlags));
                    v = new HtmlFormatter(System.out);
                    v.setRightMargin(1024);
                    v.setIndent(0);
                    document.accept(v);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ((InputStream)r).close();
            }
            ++i;
        }
    }
}

