/*
 * Decompiled with CFR 0.152.
 */
package com.quiotix.html.parser;

import com.quiotix.html.parser.HtmlDocument;
import com.quiotix.html.parser.HtmlDumper;
import com.quiotix.html.parser.HtmlParser;
import com.quiotix.html.parser.HtmlScrubber;
import com.quiotix.html.parser.HtmlVisitor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class HtmlCollector
extends HtmlVisitor {
    protected ElementStack tagStack = new ElementStack();
    protected ElementStack elements;
    protected boolean collected;
    protected static Set dontMatch = new HashSet();
    protected static String[] dontMatchStrings = new String[]{"AREA", "BASE", "BASEFONT", "BR", "COL", "HR", "IMG", "INPUT", "ISINDEX", "LINK", "META", "PARAM"};

    protected int pushNode(HtmlDocument.HtmlElement e) {
        this.elements.addElement(e);
        return this.elements.size() - 1;
    }

    public void visit(HtmlDocument.Comment c) {
        this.pushNode(c);
    }

    public void visit(HtmlDocument.Text t) {
        this.pushNode(t);
    }

    public void visit(HtmlDocument.Newline n) {
        this.pushNode(n);
    }

    public void visit(HtmlDocument.Tag t) {
        TagStackEntry ts = new TagStackEntry();
        int index = this.pushNode(t);
        if (!t.emptyTag && !dontMatch.contains(t.tagName.toUpperCase())) {
            ts.tagName = t.tagName;
            ts.index = index;
            this.tagStack.addElement(ts);
        }
    }

    public void visit(HtmlDocument.EndTag t) {
        int i;
        for (i = this.tagStack.size() - 1; i >= 0; --i) {
            TagStackEntry ts = (TagStackEntry)this.tagStack.elementAt(i);
            if (!t.tagName.equalsIgnoreCase(ts.tagName)) continue;
            HtmlDocument.ElementSequence blockElements = new HtmlDocument.ElementSequence(this.elements.size() - ts.index - 1);
            for (int j = ts.index + 1; j < this.elements.size(); ++j) {
                blockElements.addElement((HtmlDocument.HtmlElement)this.elements.elementAt(j));
            }
            HtmlDocument.Tag tag = (HtmlDocument.Tag)this.elements.elementAt(ts.index);
            HtmlDocument.TagBlock block = new HtmlDocument.TagBlock(tag.tagName, tag.attributeList, blockElements);
            this.elements.popN(this.elements.size() - ts.index);
            this.elements.addElement(block);
            this.tagStack.popN(this.tagStack.size() - i);
            this.collected = true;
            break;
        }
        if (i < 0) {
            this.pushNode(t);
        }
    }

    public void visit(HtmlDocument.TagBlock bl) {
        HtmlCollector c = new HtmlCollector();
        c.start();
        c.visit(bl.body);
        c.finish();
        this.pushNode(bl);
    }

    public void visit(HtmlDocument.ElementSequence s) {
        this.elements = new ElementStack(s.size());
        this.collected = false;
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            HtmlDocument.HtmlElement htmlElement = (HtmlDocument.HtmlElement)iterator.next();
            htmlElement.accept(this);
        }
        if (this.collected) {
            s.setElements(this.elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        FileInputStream r = new FileInputStream(args[0]);
        try {
            HtmlDocument document = new HtmlParser(r).HtmlDocument();
            document.accept(new HtmlScrubber());
            document.accept(new HtmlCollector());
            document.accept(new HtmlDumper(System.out));
        }
        finally {
            ((InputStream)r).close();
        }
    }

    static {
        for (int i = 0; i < dontMatchStrings.length; ++i) {
            dontMatch.add(dontMatchStrings[i]);
        }
    }

    private static class ElementStack
    extends Vector {
        private static final long serialVersionUID = 3718394150667677113L;

        ElementStack() {
        }

        ElementStack(int n) {
            super(n);
        }

        void popN(int n) {
            this.elementCount -= n;
        }
    }

    private static class TagStackEntry {
        String tagName;
        int index;

        private TagStackEntry() {
        }
    }
}

