/*
 * Decompiled with CFR 0.152.
 */
package com.quiotix.html.parser;

import java.io.PrintWriter;

class MarginWriter {
    protected int tabStop;
    protected int curPosition;
    protected int leftMargin;
    protected int rightMargin;
    protected PrintWriter out;
    protected char[] spaces = new char[256];

    MarginWriter(PrintWriter out) {
        this.out = out;
        for (int i = 0; i < this.spaces.length; ++i) {
            this.spaces[i] = 32;
        }
    }

    void flush() {
        this.out.flush();
    }

    void close() {
        this.out.close();
    }

    void print(String s) {
        if (this.curPosition == 0 && this.leftMargin > 0) {
            this.out.write(this.spaces, 0, this.leftMargin);
            this.curPosition = this.leftMargin;
        }
        this.out.print(s);
        this.curPosition += s.length();
    }

    void printAutoWrap(String s) {
        if (this.curPosition > this.leftMargin && this.curPosition + s.length() > this.rightMargin) {
            this.println();
        }
        this.print(s);
    }

    void printAutoWrap(String s, int hanging) {
        if (this.curPosition > this.leftMargin && this.curPosition + s.length() > this.rightMargin) {
            this.println();
            this.out.write(this.spaces, 0, hanging + this.leftMargin);
            this.curPosition = this.leftMargin + hanging;
        }
        this.print(s);
    }

    void println() {
        this.curPosition = 0;
        this.out.println();
    }

    void printlnSoft() {
        if (this.curPosition > 0) {
            this.println();
        }
    }

    void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    int getLeftMargin() {
        return this.leftMargin;
    }

    void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    int getRightMargin() {
        return this.rightMargin;
    }

    int getCurPosition() {
        return this.curPosition == 0 ? this.leftMargin : this.curPosition;
    }
}

