/*
 * Decompiled with CFR 0.152.
 */
package com.quiotix.html.parser;

import com.quiotix.html.parser.HtmlCollector;
import com.quiotix.html.parser.HtmlDocument;
import com.quiotix.html.parser.HtmlParser;
import com.quiotix.html.parser.HtmlScrubber;
import com.quiotix.html.parser.HtmlVisitor;
import com.quiotix.html.parser.MarginWriter;
import com.quiotix.html.parser.TagBlockRenderer;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HtmlFormatter
extends HtmlVisitor {
    protected MarginWriter out;
    protected int rightMargin = 80;
    protected int indentSize = 2;
    protected static Set tagsIndentBlock;
    protected static Set tagsNewlineBefore;
    protected static Set tagsPreformatted;
    protected static Set tagsTryMatch;
    protected static final String[] tagsIndentStrings;
    protected static final String[] tagsNewlineBeforeStrings;
    protected static final String[] tagsPreformattedStrings;
    protected static final String[] tagsTryMatchStrings;
    protected TagBlockRenderer blockRenderer = new TagBlockRenderer();
    protected HtmlDocument.HtmlElement previousElement;
    protected boolean inPreBlock;

    public HtmlFormatter(OutputStream os) throws Exception {
        this.out = new MarginWriter(new PrintWriter(new BufferedOutputStream(os)));
        this.out.setRightMargin(this.rightMargin);
    }

    public void setRightMargin(int margin) {
        this.rightMargin = margin;
        this.out.setRightMargin(this.rightMargin);
    }

    public void setIndent(int indent) {
        this.indentSize = indent;
    }

    public void visit(HtmlDocument.TagBlock block) {
        int wasMargin = 0;
        if (tagsTryMatch.contains(block.startTag.tagName.toUpperCase())) {
            this.blockRenderer.start();
            this.blockRenderer.setTargetWidth(this.out.getRightMargin() - this.out.getLeftMargin());
            this.blockRenderer.visit(block);
            this.blockRenderer.finish();
            if (!this.blockRenderer.hasBlownTarget()) {
                this.out.printAutoWrap(this.blockRenderer.getString());
                this.previousElement = block.endTag;
                return;
            }
        }
        boolean indent = tagsIndentBlock.contains(block.startTag.tagName.toUpperCase());
        boolean preformat = tagsPreformatted.contains(block.startTag.tagName.toUpperCase());
        if (preformat) {
            this.inPreBlock = true;
            this.visit(block.startTag);
            wasMargin = this.out.getLeftMargin();
            this.out.setLeftMargin(0);
            this.visit(block.body);
            this.out.setLeftMargin(wasMargin);
            this.visit(block.endTag);
        } else if (indent) {
            this.out.printlnSoft();
            this.visit(block.startTag);
            this.out.printlnSoft();
            this.out.setLeftMargin(this.out.getLeftMargin() + this.indentSize);
            this.visit(block.body);
            this.out.setLeftMargin(this.out.getLeftMargin() - this.indentSize);
            this.out.printlnSoft();
            this.visit(block.endTag);
            this.out.printlnSoft();
            this.inPreBlock = false;
        } else {
            this.visit(block.startTag);
            this.visit(block.body);
            this.visit(block.endTag);
        }
    }

    public void visit(HtmlDocument.Tag t) {
        String s = t.toString();
        if (tagsNewlineBefore.contains(t.tagName.toUpperCase()) || this.out.getCurPosition() + s.length() > this.out.getRightMargin()) {
            this.out.printlnSoft();
        }
        this.out.print("<" + t.tagName);
        int hanging = t.tagName.length() + 1;
        Iterator it = t.attributeList.attributes.iterator();
        while (it.hasNext()) {
            HtmlDocument.Attribute a = (HtmlDocument.Attribute)it.next();
            this.out.printAutoWrap(" " + a.toString(), hanging);
        }
        if (t.emptyTag) {
            this.out.print("/");
        }
        this.out.print(">");
        this.previousElement = t;
    }

    public void visit(HtmlDocument.EndTag t) {
        this.out.printAutoWrap(t.toString());
        if (tagsNewlineBefore.contains(t.tagName.toUpperCase())) {
            this.out.printlnSoft();
            this.out.println();
        }
        this.previousElement = t;
    }

    public void visit(HtmlDocument.Comment c) {
        this.out.print(c.toString());
        this.previousElement = c;
    }

    public void visit(HtmlDocument.Text t) {
        if (this.inPreBlock) {
            this.out.print(t.text);
        } else {
            int start = 0;
            while (start < t.text.length()) {
                int index = t.text.indexOf(32, start) + 1;
                if (index == 0) {
                    index = t.text.length();
                }
                this.out.printAutoWrap(t.text.substring(start, index));
                start = index;
            }
        }
        this.previousElement = t;
    }

    public void visit(HtmlDocument.Newline n) {
        if (this.inPreBlock) {
            this.out.println();
        } else if (this.previousElement instanceof HtmlDocument.Tag || this.previousElement instanceof HtmlDocument.EndTag || this.previousElement instanceof HtmlDocument.Comment || this.previousElement instanceof HtmlDocument.Newline) {
            this.out.printlnSoft();
        } else if (this.previousElement instanceof HtmlDocument.Text) {
            this.out.print(" ");
        }
        this.previousElement = n;
    }

    public void start() {
        this.previousElement = null;
        this.inPreBlock = false;
    }

    public void finish() {
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        FileInputStream r = new FileInputStream(args[0]);
        try {
            HtmlDocument document = new HtmlParser(r).HtmlDocument();
            document.accept(new HtmlCollector());
            document.accept(new HtmlScrubber(106));
            document.accept(new HtmlFormatter(System.out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ((InputStream)r).close();
        }
    }

    static {
        int i;
        tagsIndentBlock = new HashSet();
        tagsNewlineBefore = new HashSet();
        tagsPreformatted = new HashSet();
        tagsTryMatch = new HashSet();
        tagsIndentStrings = new String[]{"TABLE", "TR", "TD", "TH", "FORM", "HTML", "HEAD", "BODY", "SELECT", "OL", "UL", "LI"};
        tagsNewlineBeforeStrings = new String[]{"P", "H1", "H2", "H3", "H4", "H5", "H6", "BR"};
        tagsPreformattedStrings = new String[]{"PRE", "SCRIPT", "STYLE"};
        tagsTryMatchStrings = new String[]{"A", "TD", "TH", "TR", "I", "B", "EM", "FONT", "TT", "UL", "OL", "LI"};
        for (i = 0; i < tagsIndentStrings.length; ++i) {
            tagsIndentBlock.add(tagsIndentStrings[i]);
        }
        for (i = 0; i < tagsNewlineBeforeStrings.length; ++i) {
            tagsNewlineBefore.add(tagsNewlineBeforeStrings[i]);
        }
        for (i = 0; i < tagsPreformattedStrings.length; ++i) {
            tagsPreformatted.add(tagsPreformattedStrings[i]);
        }
        for (i = 0; i < tagsTryMatchStrings.length; ++i) {
            tagsTryMatch.add(tagsTryMatchStrings[i]);
        }
    }
}

