/*
 * Decompiled with CFR 0.152.
 */
package com.quiotix.html.parser;

import com.quiotix.html.parser.HtmlDocument;
import com.quiotix.html.parser.HtmlVisitor;
import java.util.Iterator;

public class HtmlScrubber
extends HtmlVisitor {
    public static final int TAGS_UPCASE = 1;
    public static final int TAGS_DOWNCASE = 2;
    public static final int ATTR_UPCASE = 4;
    public static final int ATTR_DOWNCASE = 8;
    public static final int STRIP_QUOTES = 16;
    public static final int TRIM_SPACES = 32;
    public static final int QUOTE_ATTRS = 64;
    public static final int DEFAULT_OPTIONS = 74;
    protected int flags;
    protected HtmlDocument.HtmlElement previousElement;
    protected boolean inPreBlock;

    public HtmlScrubber() {
        this(74);
    }

    public HtmlScrubber(int flags) {
        this.flags = flags;
    }

    private static boolean safeToUnquote(String qs) {
        int upperCount = 0;
        int lowerCount = 0;
        int idCount = 0;
        for (int i = 1; i < qs.length() - 1; ++i) {
            char c = qs.charAt(i);
            if (Character.isUnicodeIdentifierPart(c)) {
                ++idCount;
            }
            if (Character.isUpperCase(c)) {
                ++upperCount;
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            ++lowerCount;
        }
        return qs.length() - 2 > 0 && qs.length() - 2 == idCount && (upperCount == 0 || lowerCount == 0);
    }

    private static boolean isSingleQuoted(String s) {
        return s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'';
    }

    private static boolean isDoubleQuoted(String s) {
        return s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"';
    }

    private static boolean isQuoted(String s) {
        return HtmlScrubber.isDoubleQuoted(s) || HtmlScrubber.isSingleQuoted(s);
    }

    public void start() {
        this.previousElement = null;
        this.inPreBlock = false;
    }

    public void visit(HtmlDocument.Tag t) {
        if ((this.flags & 1) != 0) {
            t.tagName = t.tagName.toUpperCase();
        } else if ((this.flags & 2) != 0) {
            t.tagName = t.tagName.toLowerCase();
        }
        Iterator it = t.attributeList.attributes.iterator();
        while (it.hasNext()) {
            HtmlDocument.Attribute a = (HtmlDocument.Attribute)it.next();
            if ((this.flags & 4) != 0) {
                a.name = a.name.toUpperCase();
            } else if ((this.flags & 8) != 0) {
                a.name = a.name.toLowerCase();
            }
            if ((this.flags & 0x10) != 0 && a.hasValue && HtmlScrubber.isQuoted(a.value) && HtmlScrubber.safeToUnquote(a.value)) {
                a.value = a.value.substring(1, a.value.length() - 1);
            }
            if ((this.flags & 0x40) == 0 || !a.hasValue || HtmlScrubber.isDoubleQuoted(a.value)) continue;
            if (HtmlScrubber.isSingleQuoted(a.value)) {
                a.value = a.value.substring(1, a.value.length() - 1);
            }
            a.value = "\"" + a.value + "\"";
        }
        this.previousElement = t;
    }

    public void visit(HtmlDocument.EndTag t) {
        if ((this.flags & 1) != 0) {
            t.tagName = t.tagName.toUpperCase();
        } else if ((this.flags & 2) != 0) {
            t.tagName = t.tagName.toLowerCase();
        }
        this.previousElement = t;
    }

    public void visit(HtmlDocument.Text t) {
        if ((this.flags & 0x20) != 0 && !this.inPreBlock && (this.previousElement instanceof HtmlDocument.Newline || this.previousElement instanceof HtmlDocument.Tag || this.previousElement instanceof HtmlDocument.EndTag || this.previousElement instanceof HtmlDocument.Comment)) {
            int i;
            for (i = 0; i < t.text.length() && (t.text.charAt(i) == ' ' || t.text.charAt(i) == '\t'); ++i) {
            }
            if (i > 0) {
                t.text = t.text.substring(i);
            }
        }
        this.previousElement = t;
    }

    public void visit(HtmlDocument.Comment c) {
        this.previousElement = c;
    }

    public void visit(HtmlDocument.Newline n) {
        this.previousElement = n;
    }

    public void visit(HtmlDocument.Annotation a) {
        this.previousElement = a;
    }

    public void visit(HtmlDocument.TagBlock bl) {
        if (bl.startTag.tagName.equalsIgnoreCase("PRE") || bl.startTag.tagName.equalsIgnoreCase("SCRIPT") || bl.startTag.tagName.equalsIgnoreCase("STYLE")) {
            this.inPreBlock = true;
            super.visit(bl);
            this.inPreBlock = false;
        } else {
            super.visit(bl);
        }
    }
}

