/*
 * Decompiled with CFR 0.152.
 */
package com.quiotix.html.example;

import com.quiotix.html.parser.HtmlDocument;
import com.quiotix.html.parser.HtmlParser;
import com.quiotix.html.parser.HtmlVisitor;
import com.quiotix.html.parser.ParseException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public class DumpLinks
extends HtmlVisitor {
    protected PrintWriter out;

    public DumpLinks(OutputStream os) {
        this.out = new PrintWriter(os);
    }

    public DumpLinks(OutputStream os, String encoding) throws UnsupportedEncodingException {
        this.out = new PrintWriter(new OutputStreamWriter(os, encoding));
    }

    public void finish() {
        this.out.flush();
    }

    public void visit(HtmlDocument.Tag t) {
        if (t.tagName.equalsIgnoreCase("A")) {
            Iterator i = t.attributeList.attributes.iterator();
            while (i.hasNext()) {
                HtmlDocument.Attribute a = (HtmlDocument.Attribute)i.next();
                if (!a.name.equalsIgnoreCase("HREF")) continue;
                this.out.println(a.getValue());
            }
        }
    }

    public static void main(String[] args) throws ParseException, IOException {
        HtmlDocument document = new HtmlParser(System.in).HtmlDocument();
        document.accept(new DumpLinks(System.out));
    }
}

