/*
 * Decompiled with CFR 0.152.
 */
package com.wakaleo.schemaspy;

import com.wakaleo.schemaspy.util.JDBCHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.SchemaAnalyzer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaSpyReport
extends AbstractMavenReport {
    private File targetDirectory;
    private String outputDirectory;
    private Renderer siteRenderer;
    private MavenProject project;
    private String database;
    private String host;
    private String port;
    private String jdbcUrl;
    private String databaseType;
    private String user;
    private String schema;
    private String password;
    private String pathToDrivers;
    private String schemaDescription;
    private String includeTableNamesRegex;
    private String excludeColumnNamesRegex;
    private Boolean allowHtmlInComments;
    private Boolean commentsInitiallyDisplayed;
    private Boolean noImplied;
    private Boolean noHtml;
    private Boolean useDriverManager;
    private String cssStylesheet;
    private Boolean singleSignOn;
    private Boolean lowQuality;
    private Boolean highQuality;
    private Boolean showAllSchemas;
    private String schemas;
    private Boolean noSchema;
    private Boolean noRows;
    private Boolean noViews;
    private String connprops;
    private Boolean noAds;
    private Boolean noLogo;
    protected boolean runOnExecutionRoot = false;
    SchemaAnalyzer analyzer = new SchemaAnalyzer();
    private JDBCHelper jdbcHelper = new JDBCHelper();

    protected void setSchemaAnalyzer(SchemaAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    private void addToArguments(List<String> argList, String parameter, Boolean value) {
        if (value != null && value.booleanValue()) {
            argList.add(parameter + "=" + value);
        }
    }

    private void addFlagToArguments(List<String> argList, String parameter, Boolean value) {
        if (value != null && value.booleanValue()) {
            argList.add(parameter);
        }
    }

    private void addToArguments(List<String> argList, String parameter, String value) {
        if (value != null) {
            argList.add(parameter + "=" + value);
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (this.targetDirectory == null) {
            this.targetDirectory = new File("target");
        }
        this.targetDirectory.mkdirs();
        File siteDir = new File(this.targetDirectory, "site");
        siteDir.mkdirs();
        File outputDir = null;
        if (this.outputDirectory == null) {
            outputDir = new File(siteDir, "schemaspy");
            outputDir.mkdirs();
            this.outputDirectory = outputDir.getAbsolutePath();
        } else {
            outputDir = new File(new File(this.outputDirectory), "schemaspy");
            outputDir.mkdirs();
        }
        String schemaSpyDirectory = outputDir.getAbsolutePath();
        ArrayList<String> argList = new ArrayList<String>();
        if (this.jdbcUrl != null && this.databaseType == null) {
            this.databaseType = this.jdbcHelper.extractDatabaseType(this.jdbcUrl);
        }
        this.addToArguments(argList, "-dp", this.pathToDrivers);
        this.addToArguments(argList, "-db", this.database);
        this.addToArguments(argList, "-host", this.host);
        this.addToArguments(argList, "-port", this.port);
        this.addToArguments(argList, "-t", this.databaseType);
        this.addToArguments(argList, "-u", this.user);
        this.addToArguments(argList, "-p", this.password);
        this.addToArguments(argList, "-s", this.schema);
        this.addToArguments(argList, "-o", schemaSpyDirectory);
        this.addToArguments(argList, "-desc", this.schemaDescription);
        this.addToArguments(argList, "-i", this.includeTableNamesRegex);
        this.addToArguments(argList, "-x", this.excludeColumnNamesRegex);
        this.addFlagToArguments(argList, "-ahic", this.allowHtmlInComments);
        this.addFlagToArguments(argList, "-noimplied", this.noImplied);
        this.addFlagToArguments(argList, "-nohtml", this.noHtml);
        this.addFlagToArguments(argList, "-norows", this.noRows);
        this.addFlagToArguments(argList, "-noviews", this.noViews);
        this.addFlagToArguments(argList, "-noschema", this.noSchema);
        this.addFlagToArguments(argList, "-all", this.showAllSchemas);
        this.addToArguments(argList, "-schemas", this.schemas);
        this.addToArguments(argList, "-useDriverManager", this.useDriverManager);
        this.addToArguments(argList, "-css", this.cssStylesheet);
        this.addFlagToArguments(argList, "-sso", this.singleSignOn);
        this.addFlagToArguments(argList, "-lq", this.lowQuality);
        this.addFlagToArguments(argList, "-hq", this.highQuality);
        this.addToArguments(argList, "connprops", this.connprops);
        this.addFlagToArguments(argList, "-cid", this.commentsInitiallyDisplayed);
        this.addFlagToArguments(argList, "-noads", this.noAds);
        this.addFlagToArguments(argList, "-nologo", this.noLogo);
        String[] args = argList.toArray(new String[0]);
        this.getLog().info((CharSequence)"Generating SchemaSpy report with parameters:");
        for (String arg : args) {
            this.getLog().info((CharSequence)arg);
        }
        try {
            this.analyzer.analyze(new Config(args));
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    public boolean canGenerateReport() {
        return !this.runOnExecutionRoot || this.project.isExecutionRoot();
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return "SchemaSpy database documentation";
    }

    public String getName(Locale locale) {
        return "SchemaSpy";
    }

    public String getOutputName() {
        return "schemaspy/index";
    }

    public boolean isExternalReport() {
        return true;
    }
}

