/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipInputStream;
import net.sourceforge.schemaspy.TableOrderer;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.util.DbSpecificConfig;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.view.DefaultSqlFormatter;
import net.sourceforge.schemaspy.view.SqlFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static Config instance;
    private final List<String> options;
    private Map<String, String> dbSpecificOptions;
    private Map<String, String> originalDbSpecificOptions;
    private boolean helpRequired;
    private boolean dbHelpRequired;
    private File outputDir;
    private File graphvizDir;
    private String dbType;
    private String schema;
    private List<String> schemas;
    private String user;
    private Boolean singleSignOn;
    private Boolean noSchema;
    private String password;
    private Boolean promptForPassword;
    private String db;
    private String host;
    private Integer port;
    private String server;
    private String meta;
    private Pattern tableInclusions;
    private Pattern tableExclusions;
    private Pattern columnExclusions;
    private Pattern indirectColumnExclusions;
    private String userConnectionPropertiesFile;
    private Properties userConnectionProperties;
    private Integer maxDbThreads;
    private Integer maxDetailedTables;
    private String driverPath;
    private String css;
    private String charset;
    private String font;
    private Integer fontSize;
    private String description;
    private String dbPropertiesLoadedFrom;
    private Level logLevel;
    private SqlFormatter sqlFormatter;
    private String sqlFormatterClass;
    private Boolean generateHtml;
    private Boolean includeImpliedConstraints;
    private Boolean logoEnabled;
    private Boolean rankDirBugEnabled;
    private Boolean encodeCommentsEnabled;
    private Boolean numRowsEnabled;
    private Boolean viewsEnabled;
    private Boolean meterEnabled;
    private Boolean railsEnabled;
    private Boolean evaluteAll;
    private Boolean highQuality;
    private Boolean lowQuality;
    private Boolean adsEnabled;
    private String schemaSpec;
    private boolean populating = false;
    public static final String DOT_CHARSET = "UTF-8";
    private static final String ESCAPED_EQUALS = "\\=";

    public Config() {
        if (instance == null) {
            Config.setInstance(this);
        }
        this.options = new ArrayList<String>();
    }

    public Config(String[] argv) {
        Config.setInstance(this);
        this.options = this.fixupArgs(Arrays.asList(argv));
        this.helpRequired = this.options.remove("-?") || this.options.remove("/?") || this.options.remove("?") || this.options.remove("-h") || this.options.remove("-help") || this.options.remove("--help");
        this.dbHelpRequired = this.options.remove("-dbHelp") || this.options.remove("-dbhelp");
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public static void setInstance(Config config) {
        instance = config;
    }

    public void setHtmlGenerationEnabled(boolean generateHtml) {
        this.generateHtml = generateHtml;
    }

    public boolean isHtmlGenerationEnabled() {
        if (this.generateHtml == null) {
            this.generateHtml = !this.options.remove("-nohtml");
        }
        return this.generateHtml;
    }

    public void setImpliedConstraintsEnabled(boolean includeImpliedConstraints) {
        this.includeImpliedConstraints = includeImpliedConstraints;
    }

    public boolean isImpliedConstraintsEnabled() {
        if (this.includeImpliedConstraints == null) {
            this.includeImpliedConstraints = !this.options.remove("-noimplied");
        }
        return this.includeImpliedConstraints;
    }

    public void setOutputDir(String outputDirName) {
        if (outputDirName.endsWith("\"")) {
            outputDirName = outputDirName.substring(0, outputDirName.length() - 1);
        }
        this.setOutputDir(new File(outputDirName));
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public File getOutputDir() {
        if (this.outputDir == null) {
            this.setOutputDir(this.pullRequiredParam("-o"));
        }
        return this.outputDir;
    }

    public void setGraphvizDir(String graphvizDir) {
        if (graphvizDir.endsWith("\"")) {
            graphvizDir = graphvizDir.substring(0, graphvizDir.length() - 1);
        }
        this.setGraphvizDir(new File(graphvizDir));
    }

    public void setGraphvizDir(File graphvizDir) {
        this.graphvizDir = graphvizDir;
    }

    public File getGraphvizDir() {
        String gv;
        if (this.graphvizDir == null && (gv = this.pullParam("-gv")) != null) {
            this.setGraphvizDir(gv);
        }
        return this.graphvizDir;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    public String getMeta() {
        if (this.meta == null) {
            this.meta = this.pullParam("-meta");
        }
        return this.meta;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbType() {
        if (this.dbType == null) {
            this.dbType = this.pullParam("-t");
            if (this.dbType == null) {
                this.dbType = "ora";
            }
        }
        return this.dbType;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getDb() {
        if (this.db == null) {
            this.db = this.pullParam("-db");
        }
        return this.db;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        if (this.schema == null) {
            this.schema = this.pullParam("-s");
        }
        return this.schema;
    }

    public boolean isSchemaDisabled() {
        if (this.noSchema == null) {
            this.noSchema = this.options.remove("-noschema");
        }
        return this.noSchema;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = this.pullParam("-host");
        }
        return this.host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        if (this.port == null) {
            try {
                this.port = Integer.valueOf(this.pullParam("-port"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.port;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        if (this.server == null) {
            this.server = this.pullParam("-server");
        }
        return this.server;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        if (this.user == null) {
            this.user = !this.isSingleSignOn() ? this.pullRequiredParam("-u") : this.pullParam("-u");
        }
        return this.user;
    }

    public void setSingleSignOn(boolean enabled) {
        this.singleSignOn = enabled;
    }

    public boolean isSingleSignOn() {
        if (this.singleSignOn == null) {
            this.singleSignOn = this.options.remove("-sso");
        }
        return this.singleSignOn;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.pullParam("-p");
        }
        return this.password;
    }

    public void setPromptForPasswordEnabled(boolean promptForPassword) {
        this.promptForPassword = promptForPassword;
    }

    public boolean isPromptForPasswordEnabled() {
        if (this.promptForPassword == null) {
            this.promptForPassword = this.options.remove("-pfp");
        }
        return this.promptForPassword;
    }

    public void setMaxDetailedTabled(int maxDetailedTables) {
        this.maxDetailedTables = new Integer(maxDetailedTables);
    }

    public int getMaxDetailedTables() {
        if (this.maxDetailedTables == null) {
            int max = 300;
            try {
                max = Integer.parseInt(this.pullParam("-maxdet"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.maxDetailedTables = new Integer(max);
        }
        return this.maxDetailedTables;
    }

    public String getConnectionPropertiesFile() {
        return this.userConnectionPropertiesFile;
    }

    public void setConnectionPropertiesFile(String propertiesFilename) throws FileNotFoundException, IOException {
        if (this.userConnectionProperties == null) {
            this.userConnectionProperties = new Properties();
        }
        this.userConnectionProperties.load(new FileInputStream(propertiesFilename));
        this.userConnectionPropertiesFile = propertiesFilename;
    }

    public Properties getConnectionProperties() throws FileNotFoundException, IOException {
        if (this.userConnectionProperties == null) {
            String props = this.pullParam("-connprops");
            if (props != null) {
                if (props.indexOf(ESCAPED_EQUALS) != -1) {
                    this.setConnectionProperties(props);
                } else {
                    this.setConnectionPropertiesFile(props);
                }
            } else {
                this.userConnectionProperties = new Properties();
            }
        }
        return this.userConnectionProperties;
    }

    public void setConnectionProperties(String properties) {
        this.userConnectionProperties = new Properties();
        StringTokenizer tokenizer = new StringTokenizer(properties, ";");
        while (tokenizer.hasMoreElements()) {
            String pair = tokenizer.nextToken();
            int index = pair.indexOf(ESCAPED_EQUALS);
            if (index == -1) continue;
            String key = pair.substring(0, index);
            String value = pair.substring(index + ESCAPED_EQUALS.length());
            this.userConnectionProperties.put(key, value);
        }
    }

    public void setDriverPath(String driverPath) {
        this.driverPath = driverPath;
    }

    public String getDriverPath() {
        if (this.driverPath == null) {
            this.driverPath = this.pullParam("-dp");
        }
        if (this.driverPath == null) {
            this.driverPath = this.pullParam("-cp");
        }
        return this.driverPath;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public String getCss() {
        if (this.css == null) {
            this.css = this.pullParam("-css");
            if (this.css == null) {
                this.css = "schemaSpy.css";
            }
        }
        return this.css;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public String getFont() {
        if (this.font == null) {
            this.font = this.pullParam("-font");
            if (this.font == null) {
                this.font = "Helvetica";
            }
        }
        return this.font;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = new Integer(fontSize);
    }

    public int getFontSize() {
        if (this.fontSize == null) {
            int size = 11;
            try {
                size = Integer.parseInt(this.pullParam("-fontsize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fontSize = new Integer(size);
        }
        return this.fontSize;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        if (this.charset == null) {
            this.charset = this.pullParam("-charset");
            if (this.charset == null) {
                this.charset = "ISO-8859-1";
            }
        }
        return this.charset;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.pullParam("-desc");
        }
        return this.description;
    }

    public void setMaxDbThreads(int maxDbThreads) {
        this.maxDbThreads = new Integer(maxDbThreads);
    }

    public int getMaxDbThreads() throws InvalidConfigurationException {
        if (this.maxDbThreads == null) {
            Properties properties;
            try {
                properties = this.getDbProperties(this.getDbType());
            }
            catch (IOException exc) {
                throw new InvalidConfigurationException("Failed to load properties for " + this.getDbType() + ": " + exc).setParamName("-type");
            }
            int max = Integer.MAX_VALUE;
            String threads = properties.getProperty("dbThreads");
            if (threads == null) {
                threads = properties.getProperty("dbthreads");
            }
            if (threads != null) {
                max = Integer.parseInt(threads);
            }
            if ((threads = this.pullParam("-dbThreads")) == null) {
                threads = this.pullParam("-dbthreads");
            }
            if (threads != null) {
                max = Integer.parseInt(threads);
            }
            if (max < 0) {
                max = Integer.MAX_VALUE;
            } else if (max == 0) {
                max = 1;
            }
            this.maxDbThreads = new Integer(max);
        }
        return this.maxDbThreads;
    }

    public boolean isLogoEnabled() {
        if (this.logoEnabled == null) {
            this.logoEnabled = !this.options.remove("-nologo");
        }
        return this.logoEnabled;
    }

    public void setRankDirBugEnabled(boolean enabled) {
        this.rankDirBugEnabled = enabled;
    }

    public boolean isRankDirBugEnabled() {
        if (this.rankDirBugEnabled == null) {
            this.rankDirBugEnabled = this.options.remove("-rankdirbug");
        }
        return this.rankDirBugEnabled;
    }

    public void setRailsEnabled(boolean enabled) {
        this.railsEnabled = enabled;
    }

    public boolean isRailsEnabled() {
        if (this.railsEnabled == null) {
            this.railsEnabled = this.options.remove("-rails");
        }
        return this.railsEnabled;
    }

    public void setEncodeCommentsEnabled(boolean enabled) {
        this.encodeCommentsEnabled = enabled;
    }

    public boolean isEncodeCommentsEnabled() {
        if (this.encodeCommentsEnabled == null) {
            this.encodeCommentsEnabled = !this.options.remove("-ahic");
        }
        return this.encodeCommentsEnabled;
    }

    public void setNumRowsEnabled(boolean enabled) {
        this.numRowsEnabled = enabled;
    }

    public boolean isNumRowsEnabled() {
        if (this.numRowsEnabled == null) {
            this.numRowsEnabled = !this.options.remove("-norows");
        }
        return this.numRowsEnabled;
    }

    public void setViewsEnabled(boolean enabled) {
        this.viewsEnabled = enabled;
    }

    public boolean isViewsEnabled() {
        if (this.viewsEnabled == null) {
            this.viewsEnabled = !this.options.remove("-noviews");
        }
        return this.viewsEnabled;
    }

    public boolean isMeterEnabled() {
        if (this.meterEnabled == null) {
            this.meterEnabled = this.options.remove("-meter");
        }
        return this.meterEnabled;
    }

    public void setColumnExclusions(String columnExclusions) {
        this.columnExclusions = Pattern.compile(columnExclusions);
    }

    public Pattern getColumnExclusions() {
        if (this.columnExclusions == null) {
            String strExclusions = this.pullParam("-X");
            if (strExclusions == null) {
                strExclusions = "[^.]";
            }
            this.columnExclusions = Pattern.compile(strExclusions);
        }
        return this.columnExclusions;
    }

    public void setIndirectColumnExclusions(String fullColumnExclusions) {
        this.indirectColumnExclusions = Pattern.compile(fullColumnExclusions);
    }

    public Pattern getIndirectColumnExclusions() {
        if (this.indirectColumnExclusions == null) {
            String strExclusions = this.pullParam("-x");
            if (strExclusions == null) {
                strExclusions = "[^.]";
            }
            this.indirectColumnExclusions = Pattern.compile(strExclusions);
        }
        return this.indirectColumnExclusions;
    }

    public void setTableInclusions(String tableInclusions) {
        this.tableInclusions = Pattern.compile(tableInclusions);
    }

    public Pattern getTableInclusions() {
        if (this.tableInclusions == null) {
            String strInclusions = this.pullParam("-i");
            if (strInclusions == null) {
                strInclusions = ".*";
            }
            try {
                this.tableInclusions = Pattern.compile(strInclusions);
            }
            catch (PatternSyntaxException badPattern) {
                throw new InvalidConfigurationException(badPattern).setParamName("-i");
            }
        }
        return this.tableInclusions;
    }

    public void setTableExclusions(String tableExclusions) {
        this.tableExclusions = Pattern.compile(tableExclusions);
    }

    public Pattern getTableExclusions() {
        if (this.tableExclusions == null) {
            String strExclusions = this.pullParam("-I");
            if (strExclusions == null) {
                strExclusions = "";
            }
            try {
                this.tableExclusions = Pattern.compile(strExclusions);
            }
            catch (PatternSyntaxException badPattern) {
                throw new InvalidConfigurationException(badPattern).setParamName("-I");
            }
        }
        return this.tableExclusions;
    }

    public List<String> getSchemas() {
        if (this.schemas == null) {
            String tmp = this.pullParam("-schemas");
            if (tmp == null) {
                tmp = this.pullParam("-schemata");
            }
            if (tmp != null) {
                this.schemas = new ArrayList<String>();
                for (String name : tmp.split("[ ,\"]")) {
                    this.schemas.add(name);
                }
                if (this.schemas.isEmpty()) {
                    this.schemas = null;
                }
            }
        }
        return this.schemas;
    }

    public void setSqlFormatter(String formatterClassName) {
        this.sqlFormatterClass = formatterClassName;
        this.sqlFormatter = null;
    }

    public void setSqlFormatter(SqlFormatter sqlFormatter) {
        this.sqlFormatter = sqlFormatter;
        if (sqlFormatter != null) {
            this.sqlFormatterClass = sqlFormatter.getClass().getName();
        }
    }

    public SqlFormatter getSqlFormatter() throws InvalidConfigurationException {
        if (this.sqlFormatter == null) {
            if (this.sqlFormatterClass == null) {
                this.sqlFormatterClass = this.pullParam("-sqlFormatter");
                if (this.sqlFormatterClass == null) {
                    this.sqlFormatterClass = DefaultSqlFormatter.class.getName();
                }
            }
            try {
                Class<?> clazz = Class.forName(this.sqlFormatterClass);
                this.sqlFormatter = (SqlFormatter)clazz.newInstance();
            }
            catch (Exception exc) {
                throw new InvalidConfigurationException("Failed to initialize instance of SQL formatter: ", exc).setParamName("-sqlFormatter");
            }
        }
        return this.sqlFormatter;
    }

    public void setEvaluateAllEnabled(boolean enabled) {
        this.evaluteAll = enabled;
    }

    public boolean isEvaluateAllEnabled() {
        if (this.evaluteAll == null) {
            this.evaluteAll = this.options.remove("-all");
        }
        return this.evaluteAll;
    }

    public boolean isOneOfMultipleSchemas() {
        return Boolean.getBoolean("oneofmultipleschemas");
    }

    public void setSchemaSpec(String schemaSpec) {
        this.schemaSpec = schemaSpec;
    }

    public String getSchemaSpec() {
        if (this.schemaSpec == null) {
            this.schemaSpec = this.pullParam("-schemaSpec");
        }
        return this.schemaSpec;
    }

    public void setRenderer(String renderer) {
        Dot.getInstance().setRenderer(renderer);
    }

    public String getRenderer() {
        String renderer = this.pullParam("-renderer");
        if (renderer != null) {
            this.setRenderer(renderer);
        }
        return Dot.getInstance().getRenderer();
    }

    public void setHighQuality(boolean highQuality) {
        this.highQuality = highQuality;
        this.lowQuality = !highQuality;
        Dot.getInstance().setHighQuality(highQuality);
    }

    public boolean isHighQuality() {
        if (this.highQuality == null) {
            this.highQuality = this.options.remove("-hq");
            if (this.highQuality.booleanValue()) {
                Dot.getInstance().setHighQuality(this.highQuality);
            }
        }
        this.highQuality = Dot.getInstance().isHighQuality();
        return this.highQuality;
    }

    public boolean isLowQuality() {
        if (this.lowQuality == null) {
            this.lowQuality = this.options.remove("-lq");
            if (this.lowQuality.booleanValue()) {
                Dot.getInstance().setHighQuality(this.lowQuality == false);
            }
        }
        this.lowQuality = !Dot.getInstance().isHighQuality();
        return this.lowQuality;
    }

    public void setAdsEnabled(boolean enabled) {
        this.adsEnabled = enabled;
    }

    public boolean isAdsEnabled() {
        if (this.adsEnabled == null) {
            this.adsEnabled = !this.options.remove("-noads");
        }
        return this.adsEnabled;
    }

    public void setLogLevel(String logLevel) {
        if (logLevel == null) {
            this.logLevel = Level.WARNING;
            return;
        }
        LinkedHashMap<String, Level> levels = new LinkedHashMap<String, Level>();
        levels.put("severe", Level.SEVERE);
        levels.put("warning", Level.WARNING);
        levels.put("info", Level.INFO);
        levels.put("config", Level.CONFIG);
        levels.put("fine", Level.FINE);
        levels.put("finer", Level.FINER);
        levels.put("finest", Level.FINEST);
        this.logLevel = (Level)levels.get(logLevel.toLowerCase());
        if (this.logLevel == null) {
            throw new InvalidConfigurationException("Invalid logLevel: '" + logLevel + "'. Must be one of: " + levels.keySet());
        }
    }

    public Level getLogLevel() {
        if (this.logLevel == null) {
            this.setLogLevel(this.pullParam("-loglevel"));
        }
        return this.logLevel;
    }

    public boolean isHelpRequired() {
        return this.helpRequired;
    }

    public boolean isDbHelpRequired() {
        return this.dbHelpRequired;
    }

    public static String getLoadedFromJar() {
        String classpath = System.getProperty("java.class.path");
        return new StringTokenizer(classpath, File.pathSeparator).nextToken();
    }

    public Properties getDbProperties(String type) throws IOException, InvalidConfigurationException {
        String include;
        ResourceBundle bundle = null;
        try {
            File propertiesFile = new File(type);
            bundle = new PropertyResourceBundle(new FileInputStream(propertiesFile));
            this.dbPropertiesLoadedFrom = propertiesFile.getAbsolutePath();
        }
        catch (FileNotFoundException notFoundOnFilesystemWithoutExtension) {
            try {
                File propertiesFile = new File(type + ".properties");
                bundle = new PropertyResourceBundle(new FileInputStream(propertiesFile));
                this.dbPropertiesLoadedFrom = propertiesFile.getAbsolutePath();
            }
            catch (FileNotFoundException notFoundOnFilesystemWithExtensionTackedOn) {
                try {
                    bundle = ResourceBundle.getBundle(type);
                    this.dbPropertiesLoadedFrom = "[" + Config.getLoadedFromJar() + "]" + File.separator + type + ".properties";
                }
                catch (Exception notInJarWithoutPath) {
                    try {
                        String path = TableOrderer.class.getPackage().getName() + ".dbTypes." + type;
                        path = path.replace('.', '/');
                        bundle = ResourceBundle.getBundle(path);
                        this.dbPropertiesLoadedFrom = "[" + Config.getLoadedFromJar() + "]/" + path + ".properties";
                    }
                    catch (Exception notInJar) {
                        notInJar.printStackTrace();
                        notFoundOnFilesystemWithExtensionTackedOn.printStackTrace();
                        throw notFoundOnFilesystemWithoutExtension;
                    }
                }
            }
        }
        Properties props = Config.asProperties(bundle);
        bundle = null;
        String saveLoadedFrom = this.dbPropertiesLoadedFrom;
        int i = 1;
        while ((include = (String)props.remove("include." + i)) != null) {
            int separator = include.indexOf("::");
            if (separator == -1) {
                throw new InvalidConfigurationException("include directive in " + this.dbPropertiesLoadedFrom + " must have '::' between dbType and key");
            }
            String refdType = include.substring(0, separator).trim();
            String refdKey = include.substring(separator + 2).trim();
            Properties refdProps = this.getDbProperties(refdType);
            props.put(refdKey, refdProps.getProperty(refdKey));
            ++i;
        }
        String baseDbType = (String)props.remove("extends");
        if (baseDbType != null) {
            baseDbType = baseDbType.trim();
            Properties baseProps = this.getDbProperties(baseDbType);
            baseProps.putAll((Map<?, ?>)props);
            props = baseProps;
        }
        this.dbPropertiesLoadedFrom = saveLoadedFrom;
        return props;
    }

    protected String getDbPropertiesLoadedFrom() throws IOException {
        if (this.dbPropertiesLoadedFrom == null) {
            this.getDbProperties(this.getDbType());
        }
        return this.dbPropertiesLoadedFrom;
    }

    public List<String> getRemainingParameters() {
        try {
            this.populate();
        }
        catch (IllegalArgumentException exc) {
            throw new InvalidConfigurationException(exc);
        }
        catch (IllegalAccessException exc) {
            throw new InvalidConfigurationException(exc);
        }
        catch (InvocationTargetException exc) {
            if (exc.getCause() instanceof InvalidConfigurationException) {
                throw (InvalidConfigurationException)exc.getCause();
            }
            throw new InvalidConfigurationException(exc.getCause());
        }
        catch (IntrospectionException exc) {
            throw new InvalidConfigurationException(exc);
        }
        return this.options;
    }

    public void setDbSpecificOptions(Map<String, String> dbSpecificOptions) {
        this.dbSpecificOptions = dbSpecificOptions;
        this.originalDbSpecificOptions = new HashMap<String, String>(dbSpecificOptions);
    }

    public Map<String, String> getDbSpecificOptions() {
        if (this.dbSpecificOptions == null) {
            this.dbSpecificOptions = new HashMap<String, String>();
        }
        return this.dbSpecificOptions;
    }

    public static Properties asProperties(ResourceBundle bundle) {
        Properties props = new Properties();
        Enumeration<String> iter = bundle.getKeys();
        while (iter.hasMoreElements()) {
            String key = iter.nextElement();
            props.put(key, bundle.getObject(key));
        }
        return props;
    }

    private String pullParam(String paramId) {
        return this.pullParam(paramId, false, false);
    }

    private String pullRequiredParam(String paramId) {
        return this.pullParam(paramId, true, false);
    }

    private String pullParam(String paramId, boolean required, boolean dbTypeSpecific) throws MissingRequiredParameterException {
        int paramIndex = this.options.indexOf(paramId);
        if (paramIndex < 0) {
            if (required) {
                throw new MissingRequiredParameterException(paramId, dbTypeSpecific);
            }
            return null;
        }
        this.options.remove(paramIndex);
        String param = this.options.get(paramIndex).toString();
        this.options.remove(paramIndex);
        return param;
    }

    protected List<String> fixupArgs(List<String> args) {
        ArrayList<String> expandedArgs = new ArrayList<String>();
        for (String arg : args) {
            int indexOfEquals = arg.indexOf(61);
            if (indexOfEquals != -1 && indexOfEquals - 1 != arg.indexOf(ESCAPED_EQUALS)) {
                expandedArgs.add(arg.substring(0, indexOfEquals));
                expandedArgs.add(arg.substring(indexOfEquals + 1));
                continue;
            }
            expandedArgs.add(arg);
        }
        ArrayList<String> unquotedArgs = new ArrayList<String>();
        for (String arg : expandedArgs) {
            if (arg.startsWith("\"") && arg.endsWith("\"")) {
                arg = arg.substring(1, arg.length() - 1);
            }
            unquotedArgs.add(arg);
        }
        return unquotedArgs;
    }

    private void populate() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IntrospectionException {
        if (!this.populating) {
            this.populating = true;
            BeanInfo beanInfo = Introspector.getBeanInfo(Config.class);
            PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                Method readMethod = props[i].getReadMethod();
                if (readMethod == null) continue;
                readMethod.invoke((Object)this, (Object[])null);
            }
            this.populating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getBuiltInDatabaseTypes(String loadedFromJar) {
        TreeSet<String> databaseTypes = new TreeSet<String>();
        ZipInputStream jar = null;
        try {
            JarEntry entry;
            jar = new JarInputStream(new FileInputStream(loadedFromJar));
            while ((entry = ((JarInputStream)jar).getNextJarEntry()) != null) {
                String entryName = entry.getName();
                int dotPropsIndex = entryName.indexOf(".properties");
                if (dotPropsIndex == -1) continue;
                databaseTypes.add(entryName.substring(0, dotPropsIndex));
            }
        }
        catch (IOException exc) {
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException ignore) {}
            }
        }
        return databaseTypes;
    }

    protected void dumpUsage(String errorMessage, boolean detailedDb) {
        if (errorMessage != null) {
            System.out.flush();
            System.err.println("*** " + errorMessage + " ***");
        } else {
            System.out.println("SchemaSpy generates an HTML representation of a database schema's relationships.");
        }
        System.err.flush();
        System.out.println();
        if (!detailedDb) {
            System.out.println("Usage:");
            System.out.println(" java -jar " + Config.getLoadedFromJar() + " [options]");
            System.out.println("   -t databaseType       type of database - defaults to ora");
            System.out.println("                           use -dbhelp for a list of built-in types");
            System.out.println("   -u user               connect to the database with this user id");
            System.out.println("   -s schema             defaults to the specified user");
            System.out.println("   -p password           defaults to no password");
            System.out.println("   -o outputDirectory    directory to place the generated output in");
            System.out.println("   -dp pathToDrivers     optional - looks for JDBC drivers here before looking");
            System.out.println("                           in driverPath in [databaseType].properties.");
            System.out.println("Go to http://schemaspy.sourceforge.net for a complete list/description");
            System.out.println(" of additional parameters.");
            System.out.println();
        }
        if (detailedDb) {
            System.out.println("Built-in database types and their required connection parameters:");
            for (String type : Config.getBuiltInDatabaseTypes(Config.getLoadedFromJar())) {
                new DbSpecificConfig(type).dumpUsage();
            }
            System.out.println();
        }
        if (detailedDb) {
            System.out.println("You can use your own database types by specifying the filespec of a .properties file with -t.");
            System.out.println("Grab one out of " + Config.getLoadedFromJar() + " and modify it to suit your needs.");
            System.out.println();
        }
        System.out.println("Sample usage using the default database type (implied -t ora):");
        System.out.println(" java -jar schemaSpy.jar -db mydb -s myschema -u devuser -p password -o output");
        System.out.println();
        System.out.flush();
    }

    public String getParam(String paramName) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(Config.class);
            PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                PropertyDescriptor prop = props[i];
                if (!prop.getName().equalsIgnoreCase(paramName)) continue;
                Object result = prop.getReadMethod().invoke((Object)this, (Object[])null);
                return result == null ? null : result.toString();
            }
        }
        catch (Exception failed) {
            failed.printStackTrace();
        }
        return null;
    }

    public List<String> asList() throws IOException {
        String value;
        ArrayList<String> params = new ArrayList<String>();
        if (this.originalDbSpecificOptions != null) {
            for (String key : this.originalDbSpecificOptions.keySet()) {
                String value2 = this.originalDbSpecificOptions.get(key);
                if (!key.startsWith("-")) {
                    key = "-" + key;
                }
                params.add(key);
                params.add(value2);
            }
        }
        if (this.isEncodeCommentsEnabled()) {
            params.add("-ahic");
        }
        if (this.isEvaluateAllEnabled()) {
            params.add("-all");
        }
        if (!this.isHtmlGenerationEnabled()) {
            params.add("-nohtml");
        }
        if (!this.isImpliedConstraintsEnabled()) {
            params.add("-noimplied");
        }
        if (!this.isLogoEnabled()) {
            params.add("-nologo");
        }
        if (this.isMeterEnabled()) {
            params.add("-meter");
        }
        if (!this.isNumRowsEnabled()) {
            params.add("-norows");
        }
        if (!this.isViewsEnabled()) {
            params.add("-noviews");
        }
        if (this.isRankDirBugEnabled()) {
            params.add("-rankdirbug");
        }
        if (this.isRailsEnabled()) {
            params.add("-rails");
        }
        if (this.isSingleSignOn()) {
            params.add("-sso");
        }
        if (!this.isAdsEnabled()) {
            params.add("-noads");
        }
        if (this.isSchemaDisabled()) {
            params.add("-noschema");
        }
        if ((value = this.getDriverPath()) != null) {
            params.add("-dp");
            params.add(value);
        }
        params.add("-css");
        params.add(this.getCss());
        params.add("-charset");
        params.add(this.getCharset());
        params.add("-font");
        params.add(this.getFont());
        params.add("-fontsize");
        params.add(String.valueOf(this.getFontSize()));
        params.add("-t");
        params.add(this.getDbType());
        params.add("-renderer");
        params.add(this.getRenderer());
        value = this.getDescription();
        if (value != null) {
            params.add("-desc");
            params.add(value);
        }
        if ((value = this.getPassword()) != null) {
            params.add("-p");
            params.add(value);
        }
        if (this.isPromptForPasswordEnabled()) {
            params.add("-pfp");
        }
        if ((value = this.getSchema()) != null) {
            params.add("-s");
            params.add(value);
        }
        if ((value = this.getUser()) != null) {
            params.add("-u");
            params.add(value);
        }
        if ((value = this.getConnectionPropertiesFile()) != null) {
            params.add("-connprops");
            params.add(value);
        } else {
            Properties props = this.getConnectionProperties();
            if (!props.isEmpty()) {
                params.add("-connprops");
                StringBuilder buf = new StringBuilder();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    buf.append(entry.getKey());
                    buf.append(ESCAPED_EQUALS);
                    buf.append(entry.getValue());
                    buf.append(';');
                }
                params.add(buf.toString());
            }
        }
        value = this.getDb();
        if (value != null) {
            params.add("-db");
            params.add(value);
        }
        if ((value = this.getHost()) != null) {
            params.add("-host");
            params.add(value);
        }
        if (this.getPort() != null) {
            params.add("-port");
            params.add(this.getPort().toString());
        }
        if ((value = this.getServer()) != null) {
            params.add("-server");
            params.add(value);
        }
        if ((value = this.getMeta()) != null) {
            params.add("-meta");
            params.add(value);
        }
        if (this.getGraphvizDir() != null) {
            params.add("-gv");
            params.add(this.getGraphvizDir().toString());
        }
        params.add("-loglevel");
        params.add(this.getLogLevel().toString().toLowerCase());
        params.add("-sqlFormatter");
        params.add(this.getSqlFormatter().getClass().getName());
        params.add("-i");
        params.add(this.getTableInclusions().pattern());
        params.add("-I");
        params.add(this.getTableExclusions().pattern());
        params.add("-x");
        params.add(this.getColumnExclusions().pattern());
        params.add("-X");
        params.add(this.getIndirectColumnExclusions().pattern());
        params.add("-dbthreads");
        params.add(String.valueOf(this.getMaxDbThreads()));
        params.add("-maxdet");
        params.add(String.valueOf(this.getMaxDetailedTables()));
        params.add("-o");
        params.add(this.getOutputDir().toString());
        return params;
    }

    public static class MissingRequiredParameterException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final boolean dbTypeSpecific;

        public MissingRequiredParameterException(String paramId, boolean dbTypeSpecific) {
            this(paramId, null, dbTypeSpecific);
        }

        public MissingRequiredParameterException(String paramId, String description, boolean dbTypeSpecific) {
            super("Required parameter '" + paramId + "' " + (description == null ? "" : "(" + description + ") ") + "was not specified." + (dbTypeSpecific ? "  It is required for this database type." : ""));
            this.dbTypeSpecific = dbTypeSpecific;
        }

        public boolean isDbTypeSpecific() {
            return this.dbTypeSpecific;
        }
    }
}

