/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.ImpliedForeignKeyConstraint;
import net.sourceforge.schemaspy.model.RailsForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.util.Inflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbAnalyzer {
    public static List<ImpliedForeignKeyConstraint> getImpliedConstraints(Collection<Table> tables) {
        ArrayList<TableColumn> columnsWithoutParents = new ArrayList<TableColumn>();
        TreeMap<TableColumn, Table> allPrimaries = new TreeMap<TableColumn, Table>(new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn column1, TableColumn column2) {
                int rc = column1.getName().compareToIgnoreCase(column2.getName());
                if (rc == 0) {
                    rc = column1.getType().compareToIgnoreCase(column2.getType());
                }
                if (rc == 0) {
                    rc = column1.getLength() - column2.getLength();
                }
                return rc;
            }
        });
        int duplicatePrimaries = 0;
        for (Table table : tables) {
            List<TableColumn> tablePrimaries = table.getPrimaryColumns();
            if (tablePrimaries.size() == 1) {
                for (TableColumn primary : tablePrimaries) {
                    if (!primary.allowsImpliedChildren() || allPrimaries.put(primary, table) == null) continue;
                    ++duplicatePrimaries;
                }
            }
            for (TableColumn column : table.getColumns()) {
                if (column.isForeignKey() || !column.allowsImpliedParents()) continue;
                columnsWithoutParents.add(column);
            }
        }
        if (duplicatePrimaries > allPrimaries.size()) {
            return new ArrayList<ImpliedForeignKeyConstraint>();
        }
        DbAnalyzer.sortColumnsByTable(columnsWithoutParents);
        ArrayList<ImpliedForeignKeyConstraint> impliedConstraints = new ArrayList<ImpliedForeignKeyConstraint>();
        for (TableColumn childColumn : columnsWithoutParents) {
            TableColumn parentColumn;
            Table primaryTable = (Table)allPrimaries.get(childColumn);
            if (primaryTable == null || primaryTable == childColumn.getTable() || (parentColumn = primaryTable.getColumn(childColumn.getName())).getParentConstraint(childColumn) != null) continue;
            impliedConstraints.add(new ImpliedForeignKeyConstraint(parentColumn, childColumn));
        }
        return impliedConstraints;
    }

    public static List<RailsForeignKeyConstraint> getRailsConstraints(Map<String, Table> tables) {
        ArrayList<RailsForeignKeyConstraint> railsConstraints = new ArrayList<RailsForeignKeyConstraint>(tables.size());
        for (Table table : tables.values()) {
            for (TableColumn column : table.getColumns()) {
                TableColumn primaryColumn;
                String singular;
                String primaryTableName;
                Table primaryTable;
                String columnName = column.getName().toLowerCase();
                if (column.isForeignKey() || !column.allowsImpliedParents() || !columnName.endsWith("_id") || (primaryTable = tables.get(primaryTableName = Inflection.pluralize(singular = columnName.substring(0, columnName.length() - 3)))) == null || (primaryColumn = primaryTable.getColumn("ID")) == null) continue;
                railsConstraints.add(new RailsForeignKeyConstraint(primaryColumn, column));
            }
        }
        return railsConstraints;
    }

    public static List<ForeignKeyConstraint> getForeignKeyConstraints(Collection<Table> tables) {
        ArrayList<ForeignKeyConstraint> constraints = new ArrayList<ForeignKeyConstraint>();
        for (Table table : tables) {
            constraints.addAll(table.getForeignKeys());
        }
        return constraints;
    }

    public static List<Table> getOrphans(Collection<Table> tables) {
        ArrayList<Table> orphans = new ArrayList<Table>();
        for (Table table : tables) {
            if (!table.isOrphan(false)) continue;
            orphans.add(table);
        }
        return DbAnalyzer.sortTablesByName(orphans);
    }

    public static List<TableColumn> getMustBeUniqueNullableColumns(Collection<Table> tables) {
        ArrayList<TableColumn> uniqueNullables = new ArrayList<TableColumn>();
        for (Table table : tables) {
            for (TableIndex index : table.getIndexes()) {
                if (!index.isUniqueNullable()) continue;
                uniqueNullables.addAll(index.getColumns());
            }
        }
        return DbAnalyzer.sortColumnsByTable(uniqueNullables);
    }

    public static List<Table> getTablesWithoutIndexes(Collection<Table> tables) {
        ArrayList<Table> withoutIndexes = new ArrayList<Table>();
        for (Table table : tables) {
            if (table.isView() || table.getIndexes().size() != 0) continue;
            withoutIndexes.add(table);
        }
        return DbAnalyzer.sortTablesByName(withoutIndexes);
    }

    public static List<Table> getTablesWithIncrementingColumnNames(Collection<Table> tables) {
        ArrayList<Table> denormalizedTables = new ArrayList<Table>();
        block0: for (Table table : tables) {
            HashMap<String, Long> columnPrefixes = new HashMap<String, Long>();
            for (TableColumn column : table.getColumns()) {
                String columnName = column.getName();
                String numbers = null;
                for (int i = columnName.length() - 1; i > 0 && Character.isDigit(columnName.charAt(i)); --i) {
                    numbers = String.valueOf(columnName.charAt(i)) + (numbers == null ? "" : numbers);
                }
                if (numbers == null) {
                    numbers = "1";
                    columnName = columnName + numbers;
                }
                String prefix = columnName.substring(0, columnName.length() - numbers.length());
                long numeric = Long.parseLong(numbers);
                Long existing = (Long)columnPrefixes.get(prefix);
                if (existing != null && Math.abs(existing - numeric) == 1L) {
                    denormalizedTables.add(table);
                    continue block0;
                }
                columnPrefixes.put(prefix, new Long(numeric));
            }
        }
        return DbAnalyzer.sortTablesByName(denormalizedTables);
    }

    public static List<Table> getTablesWithOneColumn(Collection<Table> tables) {
        ArrayList<Table> singleColumnTables = new ArrayList<Table>();
        for (Table table : tables) {
            if (table.getColumns().size() != 1) continue;
            singleColumnTables.add(table);
        }
        return DbAnalyzer.sortTablesByName(singleColumnTables);
    }

    public static List<Table> sortTablesByName(List<Table> tables) {
        Collections.sort(tables, new Comparator<Table>(){

            @Override
            public int compare(Table table1, Table table2) {
                return table1.compareTo(table2);
            }
        });
        return tables;
    }

    public static List<TableColumn> sortColumnsByTable(List<TableColumn> columns) {
        Collections.sort(columns, new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn column1, TableColumn column2) {
                int rc = column1.getTable().compareTo(column2.getTable());
                if (rc == 0) {
                    rc = column1.getName().compareToIgnoreCase(column2.getName());
                }
                return rc;
            }
        });
        return columns;
    }

    public static List<TableColumn> getDefaultNullStringColumns(Collection<Table> tables) {
        ArrayList<TableColumn> defaultNullStringColumns = new ArrayList<TableColumn>();
        for (Table table : tables) {
            for (TableColumn column : table.getColumns()) {
                String defaultString;
                Object defaultValue = column.getDefaultValue();
                if (defaultValue == null || !(defaultValue instanceof String) || !(defaultString = defaultValue.toString()).trim().equalsIgnoreCase("null")) continue;
                defaultNullStringColumns.add(column);
            }
        }
        return DbAnalyzer.sortColumnsByTable(defaultNullStringColumns);
    }

    public static List<String> getSchemas(DatabaseMetaData meta) throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        ResultSet rs = meta.getSchemas();
        while (rs.next()) {
            schemas.add(rs.getString("TABLE_SCHEM"));
        }
        rs.close();
        return schemas;
    }

    public static List<String> getPopulatedSchemas(DatabaseMetaData meta) throws SQLException {
        return DbAnalyzer.getPopulatedSchemas(meta, ".*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPopulatedSchemas(DatabaseMetaData meta, String schemaSpec) throws SQLException {
        TreeSet<String> schemas = new TreeSet<String>();
        Pattern schemaRegex = Pattern.compile(schemaSpec);
        Logger logger = Logger.getLogger(DbAnalyzer.class.getName());
        boolean logging = logger.isLoggable(Level.FINE);
        Iterator<String> iter = DbAnalyzer.getSchemas(meta).iterator();
        while (iter.hasNext()) {
            String schema = iter.next().toString();
            if (schemaRegex.matcher(schema).matches()) {
                ResultSet rs = null;
                try {
                    rs = meta.getTables(null, schema, "%", null);
                    if (rs.next()) {
                        if (logging) {
                            logger.fine("Including schema " + schema + ": matches + \"" + schemaRegex + "\" and contains tables");
                        }
                        schemas.add(schema);
                        continue;
                    }
                    if (!logging) continue;
                    logger.fine("Excluding schema " + schema + ": matches \"" + schemaRegex + "\" but contains no tables");
                }
                catch (SQLException ignore) {}
                continue;
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    continue;
                }
            }
            if (!logging) continue;
            logger.fine("Excluding schema " + schema + ": doesn't match \"" + schemaRegex + '\"');
        }
        return new ArrayList<String>(schemas);
    }

    public static void dumpResultSetRow(ResultSet rs, String description) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int numColumns = meta.getColumnCount();
        System.out.println(numColumns + " columns of " + description + ":");
        for (int i = 1; i <= numColumns; ++i) {
            System.out.print(meta.getColumnLabel(i));
            System.out.print(": ");
            System.out.print(String.valueOf(rs.getString(i)));
            System.out.print("\t");
        }
        System.out.println();
    }
}

