/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableOrderer {
    public List<Table> getTablesOrderedByRI(Collection<Table> tables, Collection<ForeignKeyConstraint> recursiveConstraints) {
        ArrayList<Table> heads = new ArrayList<Table>();
        ArrayList<Table> tails = new ArrayList<Table>();
        ArrayList<Table> remainingTables = new ArrayList<Table>(tables);
        List<Table> unattached = new ArrayList<Table>();
        Iterator iter = remainingTables.iterator();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (table.isRemote()) {
                table.unlinkParents();
                table.unlinkChildren();
                iter.remove();
                continue;
            }
            if (!table.isLeaf() || !table.isRoot()) continue;
            unattached.add(table);
            iter.remove();
        }
        unattached = TableOrderer.sortTrimmedLevel(unattached);
        boolean prunedNonReals = false;
        while (!remainingTables.isEmpty()) {
            int tablesLeft = remainingTables.size();
            tails.addAll(0, TableOrderer.trimLeaves(remainingTables));
            heads.addAll(TableOrderer.trimRoots(remainingTables));
            if (tablesLeft != remainingTables.size()) continue;
            if (!prunedNonReals) {
                for (Table table : remainingTables) {
                    table.removeNonRealForeignKeys();
                }
                prunedNonReals = true;
                continue;
            }
            boolean foundSimpleRecursion = false;
            for (Table potentialRecursiveTable : remainingTables) {
                ForeignKeyConstraint recursiveConstraint = potentialRecursiveTable.removeSelfReferencingConstraint();
                if (recursiveConstraint == null) continue;
                recursiveConstraints.add(recursiveConstraint);
                foundSimpleRecursion = true;
            }
            if (foundSimpleRecursion) continue;
            TreeSet<Table> byParentChildDelta = new TreeSet<Table>(new Comparator<Table>(){

                @Override
                public int compare(Table table1, Table table2) {
                    int rc = Math.abs(table2.getNumChildren() - table2.getNumParents()) - Math.abs(table1.getNumChildren() - table1.getNumParents());
                    if (rc == 0) {
                        rc = table1.compareTo(table2);
                    }
                    return rc;
                }
            });
            byParentChildDelta.addAll(remainingTables);
            Table recursiveTable = (Table)byParentChildDelta.iterator().next();
            ForeignKeyConstraint removedConstraint = recursiveTable.removeAForeignKeyConstraint();
            recursiveConstraints.add(removedConstraint);
        }
        ArrayList<Table> ordered = new ArrayList<Table>(heads.size() + tails.size());
        ordered.addAll(heads);
        heads = null;
        ordered.addAll(tails);
        tails = null;
        ordered.addAll(unattached);
        return ordered;
    }

    private static List<Table> trimRoots(List<Table> tables) {
        List<Table> roots = new ArrayList<Table>();
        Iterator<Table> iter = tables.iterator();
        while (iter.hasNext()) {
            Table root = iter.next();
            if (!root.isRoot()) continue;
            roots.add(root);
            iter.remove();
        }
        roots = TableOrderer.sortTrimmedLevel(roots);
        iter = roots.iterator();
        while (iter.hasNext()) {
            iter.next().unlinkChildren();
        }
        return roots;
    }

    private static List<Table> trimLeaves(List<Table> tables) {
        List<Table> leaves = new ArrayList<Table>();
        Iterator<Table> iter = tables.iterator();
        while (iter.hasNext()) {
            Table leaf = iter.next();
            if (!leaf.isLeaf()) continue;
            leaves.add(leaf);
            iter.remove();
        }
        leaves = TableOrderer.sortTrimmedLevel(leaves);
        iter = leaves.iterator();
        while (iter.hasNext()) {
            iter.next().unlinkParents();
        }
        return leaves;
    }

    private static List<Table> sortTrimmedLevel(List<Table> tables) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class TrimComparator
        implements Comparator<Table> {
            TrimComparator() {
            }

            @Override
            public int compare(Table table1, Table table2) {
                int rc = table2.getMaxChildren() - table1.getMaxChildren();
                if (rc == 0) {
                    rc = table1.getMaxParents() - table2.getMaxParents();
                }
                if (rc == 0) {
                    rc = table1.compareTo(table2);
                }
                return rc;
            }
        }
        TreeSet<Table> sorter = new TreeSet<Table>(new TrimComparator());
        sorter.addAll(tables);
        return new ArrayList<Table>(sorter);
    }
}

