/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTable
extends Table {
    private final String baseSchema;

    public RemoteTable(Database db, String schema, String name, String baseSchema, Properties properties, Pattern excludeIndirectColumns, Pattern excludeColumns) throws SQLException {
        super(db, schema, name, null, properties, excludeIndirectColumns, excludeColumns);
        this.baseSchema = baseSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectForeignKeys(Map<String, Table> tables, Pattern excludeIndirectColumns, Pattern excludeColumns) throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.db.getMetaData().getImportedKeys(null, this.getSchema(), this.getName());
            while (rs.next()) {
                String otherSchema = rs.getString("PKTABLE_SCHEM");
                if (otherSchema == null || !otherSchema.equals(this.baseSchema)) continue;
                this.addForeignKey(rs.getString("FK_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_SCHEM"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"), rs.getInt("UPDATE_RULE"), rs.getInt("DELETE_RULE"), tables, excludeIndirectColumns, excludeColumns);
            }
        }
        catch (SQLException sqlExc) {
            if (Config.getInstance().isOneOfMultipleSchemas()) {
                throw sqlExc;
            }
            System.err.println("Couldn't resolve foreign keys for remote table " + this.getSchema() + "." + this.getName() + ": " + sqlExc);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Override
    public boolean isRemote() {
        return true;
    }
}

