/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.model.xml.ForeignKeyMeta;
import net.sourceforge.schemaspy.model.xml.TableColumnMeta;
import net.sourceforge.schemaspy.model.xml.TableMeta;
import net.sourceforge.schemaspy.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements Comparable<Table> {
    private final String schema;
    private final String name;
    protected final CaseInsensitiveMap<TableColumn> columns = new CaseInsensitiveMap();
    private final List<TableColumn> primaryKeys = new ArrayList<TableColumn>();
    private final CaseInsensitiveMap<ForeignKeyConstraint> foreignKeys = new CaseInsensitiveMap();
    private final CaseInsensitiveMap<TableIndex> indexes = new CaseInsensitiveMap();
    private Object id;
    private final Map<String, String> checkConstraints = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Integer numRows;
    protected final Database db;
    protected final Properties properties;
    private String comments;
    private int maxChildren;
    private int maxParents;
    private static final Logger logger = Logger.getLogger(Table.class.getName());

    public Table(Database db, String schema, String name, String comments, Properties properties, Pattern excludeIndirectColumns, Pattern excludeColumns) throws SQLException {
        this.schema = schema;
        this.name = name;
        this.db = db;
        this.properties = properties;
        logger.fine("Creating " + this.getClass().getSimpleName().toLowerCase() + " " + schema == null ? name : schema + '.' + name);
        this.setComments(comments);
        this.initColumns(excludeIndirectColumns, excludeColumns);
        this.initIndexes();
        this.initPrimaryKeys(db.getMetaData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectForeignKeys(Map<String, Table> tables, Pattern excludeIndirectColumns, Pattern excludeColumns) throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.db.getMetaData().getImportedKeys(null, this.getSchema(), this.getName());
            while (rs.next()) {
                this.addForeignKey(rs.getString("FK_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_SCHEM"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"), rs.getInt("UPDATE_RULE"), rs.getInt("DELETE_RULE"), tables, excludeIndirectColumns, excludeColumns);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        if (this.getSchema() != null) {
            try {
                rs = this.db.getMetaData().getExportedKeys(null, this.getSchema(), this.getName());
                while (rs.next()) {
                    String otherSchema = rs.getString("FKTABLE_SCHEM");
                    if (this.getSchema().equals(otherSchema)) continue;
                    this.db.addRemoteTable(otherSchema, rs.getString("FKTABLE_NAME"), this.getSchema(), this.properties, excludeIndirectColumns, excludeColumns);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    public Collection<ForeignKeyConstraint> getForeignKeys() {
        return Collections.unmodifiableCollection(this.foreignKeys.values());
    }

    public void addCheckConstraint(String constraintName, String text) {
        this.checkConstraints.put(constraintName, text);
    }

    protected void addForeignKey(String fkName, String fkColName, String pkTableSchema, String pkTableName, String pkColName, int updateRule, int deleteRule, Map<String, Table> tables, Pattern excludeIndirectColumns, Pattern excludeColumns) throws SQLException {
        TableColumn childColumn;
        if (fkName == null) {
            return;
        }
        ForeignKeyConstraint foreignKey = this.foreignKeys.get(fkName);
        if (foreignKey == null) {
            foreignKey = new ForeignKeyConstraint(this, fkName, updateRule, deleteRule);
            this.foreignKeys.put(fkName, foreignKey);
        }
        if ((childColumn = this.getColumn(fkColName)) != null) {
            foreignKey.addChildColumn(childColumn);
            Table parentTable = tables.get(pkTableName);
            String parentSchema = pkTableSchema;
            String baseSchema = Config.getInstance().getSchema();
            if (parentTable == null || baseSchema != null && parentSchema != null && !baseSchema.equals(parentSchema)) {
                parentTable = this.db.addRemoteTable(parentSchema, pkTableName, baseSchema, this.properties, excludeIndirectColumns, excludeColumns);
            }
            if (parentTable != null) {
                TableColumn parentColumn = parentTable.getColumn(pkColName);
                if (parentColumn != null) {
                    foreignKey.addParentColumn(parentColumn);
                    childColumn.addParent(parentColumn, foreignKey);
                    parentColumn.addChild(childColumn, foreignKey);
                } else {
                    logger.warning("Couldn't add FK '" + foreignKey.getName() + "' to table '" + this + "' - Column '" + pkColName + "' doesn't exist in table '" + parentTable + "'");
                }
            } else {
                logger.warning("Couldn't add FK '" + foreignKey.getName() + "' to table '" + this + "' - Unknown Referenced Table '" + pkTableName + "'");
            }
        } else {
            logger.warning("Couldn't add FK '" + foreignKey.getName() + "' to table '" + this + "' - Column '" + fkColName + "' doesn't exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPrimaryKeys(DatabaseMetaData meta) throws SQLException {
        if (this.properties == null) {
            return;
        }
        ResultSet rs = null;
        try {
            rs = meta.getPrimaryKeys(null, this.getSchema(), this.getName());
            while (rs.next()) {
                this.setPrimaryColumn(rs);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    private void setPrimaryColumn(ResultSet rs) throws SQLException {
        String pkName = rs.getString("PK_NAME");
        if (pkName == null) {
            return;
        }
        TableIndex index = this.getIndex(pkName);
        if (index != null) {
            index.setIsPrimaryKey(true);
        }
        String columnName = rs.getString("COLUMN_NAME");
        this.setPrimaryColumn(this.getColumn(columnName));
    }

    void setPrimaryColumn(TableColumn primaryColumn) {
        this.primaryKeys.add(primaryColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(Pattern excludeIndirectColumns, Pattern excludeColumns) throws SQLException {
        ResultSet rs = null;
        Class<Table> clazz = Table.class;
        synchronized (Table.class) {
            try {
                rs = this.db.getMetaData().getColumns(null, this.getSchema(), this.getName(), "%");
                while (rs.next()) {
                    this.addColumn(rs, excludeIndirectColumns, excludeColumns);
                }
            }
            catch (SQLException exc) {
                class ColumnInitializationFailure
                extends SQLException {
                    private static final long serialVersionUID = 1L;

                    public ColumnInitializationFailure(SQLException failure) {
                        super("Failed to collect column details for " + (Table.this.isView() ? "view" : "table") + " '" + Table.this.getName() + "' in schema '" + Table.this.getSchema() + "'");
                        this.initCause(failure);
                    }
                }
                throw new ColumnInitializationFailure(exc);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (!this.isView() && !this.isRemote()) {
                this.initColumnAutoUpdate(false);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumnAutoUpdate(boolean forceQuotes) throws SQLException {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        StringBuilder sql = new StringBuilder("select * from ");
        if (this.getSchema() != null) {
            sql.append(this.getSchema());
            sql.append('.');
        }
        if (forceQuotes) {
            String quote = this.db.getMetaData().getIdentifierQuoteString().trim();
            sql.append(quote + this.getName() + quote);
        } else {
            sql.append(this.db.getQuotedIdentifier(this.getName()));
        }
        sql.append(" where 0 = 1");
        try {
            stmt = this.db.getMetaData().getConnection().prepareStatement(sql.toString());
            rs = stmt.executeQuery();
            ResultSetMetaData rsMeta = rs.getMetaData();
            for (int i = rsMeta.getColumnCount(); i > 0; --i) {
                TableColumn column = this.getColumn(rsMeta.getColumnName(i));
                column.setIsAutoUpdated(rsMeta.isAutoIncrement(i));
            }
        }
        catch (SQLException exc) {
            if (forceQuotes) {
                logger.warning("Failed to determine auto increment status: " + exc);
                logger.warning("SQL: " + sql.toString());
            } else {
                this.initColumnAutoUpdate(true);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    protected void addColumn(ResultSet rs, Pattern excludeIndirectColumns, Pattern excludeColumns) throws SQLException {
        String columnName = rs.getString("COLUMN_NAME");
        if (columnName == null) {
            return;
        }
        if (this.getColumn(columnName) == null) {
            TableColumn column = new TableColumn(this, rs, excludeIndirectColumns, excludeColumns);
            this.columns.put(column.getName(), column);
        }
    }

    protected TableColumn addColumn(TableColumnMeta colMeta) {
        TableColumn column = new TableColumn(this, colMeta);
        this.columns.put(column.getName(), column);
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndexes() throws SQLException {
        if (this.isView() || this.isRemote()) {
            return;
        }
        if (this.initIndexes(this.properties.getProperty("selectIndexesSql"))) {
            return;
        }
        ResultSet rs = null;
        try {
            rs = this.db.getMetaData().getIndexInfo(null, this.getSchema(), this.getName(), false, true);
            while (rs.next()) {
                if (rs.getShort("TYPE") == 0) continue;
                this.addIndex(rs);
            }
        }
        catch (SQLException exc) {
            logger.warning("Unable to extract index info for table '" + this.getName() + "' in schema '" + this.getSchema() + "': " + exc);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initIndexes(String selectIndexesSql) {
        if (selectIndexesSql == null) {
            return false;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.db.prepareStatement(selectIndexesSql, this.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getShort("TYPE") == 0) continue;
                this.addIndex(rs);
            }
        }
        catch (SQLException sqlException) {
            logger.warning("Failed to query index information with SQL: " + selectIndexesSql);
            logger.warning(sqlException.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        return true;
    }

    public TableIndex getIndex(String indexName) {
        return this.indexes.get(indexName);
    }

    private void addIndex(ResultSet rs) throws SQLException {
        String indexName = rs.getString("INDEX_NAME");
        if (indexName == null) {
            return;
        }
        TableIndex index = this.getIndex(indexName);
        if (index == null) {
            index = new TableIndex(rs);
            this.indexes.put(index.getName(), index);
        }
        index.addColumn(this.getColumn(rs.getString("COLUMN_NAME")), rs.getString("ASC_OR_DESC"));
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public Map<String, String> getCheckConstraints() {
        return this.checkConstraints;
    }

    public Set<TableIndex> getIndexes() {
        return new HashSet<TableIndex>(this.indexes.values());
    }

    public List<TableColumn> getPrimaryColumns() {
        return this.primaryKeys;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        String cmts;
        String string = cmts = comments == null || comments.trim().length() == 0 ? null : comments.trim();
        if (cmts != null) {
            int crapIndex = cmts.indexOf("; InnoDB free: ");
            if (crapIndex == -1) {
                int n = crapIndex = cmts.startsWith("InnoDB free: ") ? 0 : -1;
            }
            if (crapIndex != -1) {
                cmts = (cmts = cmts.substring(0, crapIndex).trim()).length() == 0 ? null : cmts;
            }
        }
        this.comments = cmts;
    }

    public TableColumn getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    public List<TableColumn> getColumns() {
        TreeSet<TableColumn> sorted = new TreeSet<TableColumn>(new ByColumnIdComparator());
        sorted.addAll(this.columns.values());
        return new ArrayList<TableColumn>(sorted);
    }

    public boolean isRoot() {
        for (TableColumn column : this.columns.values()) {
            if (!column.isForeignKey()) continue;
            return false;
        }
        return true;
    }

    public boolean isLeaf() {
        for (TableColumn column : this.columns.values()) {
            if (column.getChildren().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getMaxParents() {
        return this.maxParents;
    }

    public void addedParent() {
        ++this.maxParents;
    }

    public void unlinkParents() {
        for (TableColumn column : this.columns.values()) {
            column.unlinkParents();
        }
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void addedChild() {
        ++this.maxChildren;
    }

    public void unlinkChildren() {
        for (TableColumn column : this.columns.values()) {
            column.unlinkChildren();
        }
    }

    public ForeignKeyConstraint removeSelfReferencingConstraint() {
        return this.remove(this.getSelfReferencingConstraint());
    }

    private ForeignKeyConstraint remove(ForeignKeyConstraint constraint) {
        if (constraint != null) {
            for (int i = 0; i < constraint.getChildColumns().size(); ++i) {
                TableColumn childColumn = constraint.getChildColumns().get(i);
                TableColumn parentColumn = constraint.getParentColumns().get(i);
                childColumn.removeParent(parentColumn);
                parentColumn.removeChild(childColumn);
            }
        }
        return constraint;
    }

    private ForeignKeyConstraint getSelfReferencingConstraint() {
        for (TableColumn column : this.columns.values()) {
            for (TableColumn parentColumn : column.getParents()) {
                if (this.compareTo(parentColumn.getTable()) != 0) continue;
                return column.getParentConstraint(parentColumn);
            }
        }
        return null;
    }

    public List<ForeignKeyConstraint> removeNonRealForeignKeys() {
        ArrayList<ForeignKeyConstraint> nonReals = new ArrayList<ForeignKeyConstraint>();
        for (TableColumn column : this.columns.values()) {
            for (TableColumn parentColumn : column.getParents()) {
                ForeignKeyConstraint constraint = column.getParentConstraint(parentColumn);
                if (constraint == null || constraint.isReal()) continue;
                nonReals.add(constraint);
            }
        }
        for (ForeignKeyConstraint constraint : nonReals) {
            this.remove(constraint);
        }
        return nonReals;
    }

    public int getNumChildren() {
        int numChildren = 0;
        for (TableColumn column : this.columns.values()) {
            numChildren += column.getChildren().size();
        }
        return numChildren;
    }

    public int getNumNonImpliedChildren() {
        int numChildren = 0;
        for (TableColumn column : this.columns.values()) {
            for (TableColumn childColumn : column.getChildren()) {
                if (column.getChildConstraint(childColumn).isImplied()) continue;
                ++numChildren;
            }
        }
        return numChildren;
    }

    public int getNumParents() {
        int numParents = 0;
        for (TableColumn column : this.columns.values()) {
            numParents += column.getParents().size();
        }
        return numParents;
    }

    public int getNumNonImpliedParents() {
        int numParents = 0;
        for (TableColumn column : this.columns.values()) {
            for (TableColumn parentColumn : column.getParents()) {
                if (column.getParentConstraint(parentColumn).isImplied()) continue;
                ++numParents;
            }
        }
        return numParents;
    }

    public ForeignKeyConstraint removeAForeignKeyConstraint() {
        List<TableColumn> columns = this.getColumns();
        int numParents = 0;
        int numChildren = 0;
        for (TableColumn column : columns) {
            numParents += column.getParents().size();
            numChildren += column.getChildren().size();
        }
        for (TableColumn column : columns) {
            ForeignKeyConstraint constraint = numParents <= numChildren ? column.removeAParentFKConstraint() : column.removeAChildFKConstraint();
            if (constraint == null) continue;
            return constraint;
        }
        return null;
    }

    public boolean isView() {
        return false;
    }

    public boolean isRemote() {
        return false;
    }

    public String getViewSql() {
        return null;
    }

    public int getNumRows() {
        if (this.numRows == null) {
            this.numRows = Config.getInstance().isNumRowsEnabled() ? this.fetchNumRows() : -1;
        }
        return this.numRows;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int fetchNumRows() {
        if (this.properties == null) {
            return 0;
        }
        SQLException originalFailure = null;
        String sql = this.properties.getProperty("selectRowCountSql");
        if (sql != null) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.db.prepareStatement(sql, this.getName());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    int n = rs.getInt("row_count");
                    return n;
                }
            }
            catch (SQLException sqlException) {
                originalFailure = sqlException;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException exc) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException exc) {}
                }
            }
        }
        try {
            return this.fetchNumRows("count(*)", false);
        }
        catch (SQLException try2Exception) {
            try {
                return this.fetchNumRows("count(1)", false);
            }
            catch (SQLException try3Exception) {
                logger.warning("Unable to extract the number of rows for table " + this.getName() + ", using '-1'");
                if (originalFailure != null) {
                    logger.warning(originalFailure.toString());
                }
                logger.warning(try2Exception.toString());
                logger.warning(try3Exception.toString());
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int fetchNumRows(String clause, boolean forceQuotes) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuilder sql = new StringBuilder("select ");
        sql.append(clause);
        sql.append(" from ");
        if (this.getSchema() != null) {
            sql.append(this.getSchema());
            sql.append('.');
        }
        if (forceQuotes) {
            String quote = this.db.getMetaData().getIdentifierQuoteString().trim();
            sql.append(quote + this.getName() + quote);
        } else {
            sql.append(this.db.getQuotedIdentifier(this.getName()));
        }
        try {
            stmt = this.db.getConnection().prepareStatement(sql.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                int quote = rs.getInt(1);
                return quote;
            }
            int quote = -1;
            return quote;
        }
        catch (SQLException exc) {
            if (forceQuotes) {
                throw exc;
            }
            int n = this.fetchNumRows(clause, true);
            return n;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void update(TableMeta tableMeta) {
        String newComments = tableMeta.getComments();
        if (newComments != null) {
            this.comments = newComments;
        }
        for (TableColumnMeta colMeta : tableMeta.getColumns()) {
            TableColumn col = this.getColumn(colMeta.getName());
            if (col == null) {
                if (tableMeta.getRemoteSchema() == null) {
                    logger.warning("Unrecognized column '" + colMeta.getName() + "' for table '" + this.getName() + '\'');
                    continue;
                }
                col = this.addColumn(colMeta);
            }
            col.update(colMeta);
        }
    }

    public void connect(TableMeta tableMeta, Map<String, Table> tables, Map<String, Table> remoteTables) {
        for (TableColumnMeta colMeta : tableMeta.getColumns()) {
            TableColumn col = this.getColumn(colMeta.getName());
            for (ForeignKeyMeta fk : colMeta.getForeignKeys()) {
                Table parent;
                Table table = parent = fk.getRemoteSchema() == null ? tables.get(fk.getTableName()) : remoteTables.get(fk.getRemoteSchema() + '.' + fk.getTableName());
                if (parent != null) {
                    TableColumn parentColumn = parent.getColumn(fk.getColumnName());
                    if (parentColumn == null) {
                        logger.warning(parent.getName() + '.' + fk.getColumnName() + " doesn't exist");
                        continue;
                    }
                    new ForeignKeyConstraint(parentColumn, col){

                        public String getName() {
                            return "Defined in XML";
                        }
                    };
                    continue;
                }
                logger.warning("Undefined table '" + fk.getTableName() + "' referenced by '" + this.getName() + '.' + col.getName() + '\'');
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isOrphan(boolean withImpliedRelationships) {
        if (withImpliedRelationships) {
            return this.getMaxParents() == 0 && this.getMaxChildren() == 0;
        }
        for (TableColumn column : this.columns.values()) {
            for (TableColumn parentColumn : column.getParents()) {
                if (column.getParentConstraint(parentColumn).isImplied()) continue;
                return false;
            }
            for (TableColumn childColumn : column.getChildren()) {
                if (column.getChildConstraint(childColumn).isImplied()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(Table other) {
        if (other == this) {
            return 0;
        }
        int rc = this.getName().compareToIgnoreCase(other.getName());
        if (rc == 0) {
            String ours = this.getSchema();
            String theirs = other.getSchema();
            rc = ours != null && theirs != null ? ours.compareToIgnoreCase(theirs) : (ours == null ? -1 : 1);
        }
        return rc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByColumnIdComparator
    implements Comparator<TableColumn> {
        private ByColumnIdComparator() {
        }

        @Override
        public int compare(TableColumn column1, TableColumn column2) {
            if (column1.getId() == null || column2.getId() == null) {
                return column1.getName().compareToIgnoreCase(column2.getName());
            }
            if (column1.getId() instanceof Number) {
                return ((Number)column1.getId()).intValue() - ((Number)column2.getId()).intValue();
            }
            return column1.getId().toString().compareToIgnoreCase(column2.getId().toString());
        }
    }
}

