/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.model.xml.TableColumnMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumn {
    private final Table table;
    private final String name;
    private final Object id;
    private final String type;
    private final int length;
    private final int decimalDigits;
    private final String detailedSize;
    private final boolean isNullable;
    private boolean isAutoUpdated;
    private Boolean isUnique;
    private final Object defaultValue;
    private String comments;
    private final Map<TableColumn, ForeignKeyConstraint> parents = new HashMap<TableColumn, ForeignKeyConstraint>();
    private final Map<TableColumn, ForeignKeyConstraint> children = new TreeMap<TableColumn, ForeignKeyConstraint>(new ColumnComparator());
    private boolean allowImpliedParents = true;
    private boolean allowImpliedChildren = true;
    private boolean isExcluded = false;
    private boolean isAllExcluded = false;
    private static final Logger logger = Logger.getLogger(TableColumn.class.getName());
    private static final boolean finerEnabled = logger.isLoggable(Level.FINER);

    TableColumn(Table table, ResultSet rs, Pattern excludeIndirectColumns, Pattern excludeColumns) throws SQLException {
        this.table = table;
        String tmp = rs.getString("COLUMN_NAME");
        this.name = tmp == null ? null : tmp.intern();
        tmp = rs.getString("TYPE_NAME");
        this.type = tmp == null ? "unknown" : tmp.intern();
        this.decimalDigits = rs.getInt("DECIMAL_DIGITS");
        Number bufLength = (Number)rs.getObject("BUFFER_LENGTH");
        this.length = bufLength != null && bufLength.shortValue() > 0 ? (int)bufLength.shortValue() : rs.getInt("COLUMN_SIZE");
        StringBuilder buf = new StringBuilder();
        buf.append(this.length);
        if (this.decimalDigits > 0) {
            buf.append(',');
            buf.append(this.decimalDigits);
        }
        this.detailedSize = buf.toString();
        this.isNullable = rs.getInt("NULLABLE") == 1;
        this.defaultValue = rs.getString("COLUMN_DEF");
        this.setComments(rs.getString("REMARKS"));
        this.id = new Integer(rs.getInt("ORDINAL_POSITION") - 1);
        this.isAllExcluded = this.matches(excludeColumns);
        boolean bl = this.isExcluded = this.isAllExcluded || this.matches(excludeIndirectColumns);
        if (this.isExcluded && finerEnabled) {
            logger.finer("Excluding column " + this.getTable() + '.' + this.getName() + ": matches " + excludeColumns + ":" + this.isAllExcluded + " " + excludeIndirectColumns + ":" + this.matches(excludeIndirectColumns));
        }
    }

    public TableColumn(Table table, TableColumnMeta colMeta) {
        this.table = table;
        this.name = colMeta.getName();
        this.id = null;
        this.type = "Unknown";
        this.length = 0;
        this.decimalDigits = 0;
        this.detailedSize = "";
        this.isNullable = false;
        this.isAutoUpdated = false;
        this.defaultValue = null;
        this.comments = colMeta.getComments();
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public Object getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public String getDetailedSize() {
        return this.detailedSize;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isAutoUpdated() {
        return this.isAutoUpdated;
    }

    public void setIsAutoUpdated(boolean isAutoUpdated) {
        this.isAutoUpdated = isAutoUpdated;
    }

    public boolean isUnique() {
        if (this.isUnique == null) {
            for (TableIndex index : this.table.getIndexes()) {
                List<TableColumn> indexColumns;
                if (!index.isUnique() || (indexColumns = index.getColumns()).size() != 1 || !indexColumns.contains(this)) continue;
                this.isUnique = true;
                break;
            }
            if (this.isUnique == null) {
                this.isUnique = this.table.getPrimaryColumns().size() == 1 && this.isPrimary();
            }
        }
        return this.isUnique;
    }

    public boolean isPrimary() {
        return this.table.getPrimaryColumns().contains(this);
    }

    public boolean isForeignKey() {
        return !this.parents.isEmpty();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments == null || comments.trim().length() == 0 ? null : comments.trim();
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public boolean isAllExcluded() {
        return this.isAllExcluded;
    }

    public void addParent(TableColumn parent, ForeignKeyConstraint constraint) {
        this.parents.put(parent, constraint);
        this.table.addedParent();
    }

    public void removeParent(TableColumn parent) {
        this.parents.remove(parent);
    }

    public void unlinkParents() {
        for (TableColumn parent : this.parents.keySet()) {
            parent.removeChild(this);
        }
        this.parents.clear();
    }

    public Set<TableColumn> getParents() {
        return this.parents.keySet();
    }

    public ForeignKeyConstraint getParentConstraint(TableColumn parent) {
        return this.parents.get(parent);
    }

    public ForeignKeyConstraint removeAParentFKConstraint() {
        Iterator<TableColumn> i$ = this.parents.keySet().iterator();
        if (i$.hasNext()) {
            TableColumn relatedColumn = i$.next();
            ForeignKeyConstraint constraint = this.parents.remove(relatedColumn);
            relatedColumn.removeChild(this);
            return constraint;
        }
        return null;
    }

    public ForeignKeyConstraint removeAChildFKConstraint() {
        Iterator<TableColumn> i$ = this.children.keySet().iterator();
        if (i$.hasNext()) {
            TableColumn relatedColumn = i$.next();
            ForeignKeyConstraint constraint = this.children.remove(relatedColumn);
            relatedColumn.removeParent(this);
            return constraint;
        }
        return null;
    }

    public void addChild(TableColumn child, ForeignKeyConstraint constraint) {
        this.children.put(child, constraint);
        this.table.addedChild();
    }

    public void removeChild(TableColumn child) {
        this.children.remove(child);
    }

    public void unlinkChildren() {
        for (TableColumn child : this.children.keySet()) {
            child.removeParent(this);
        }
        this.children.clear();
    }

    public Set<TableColumn> getChildren() {
        return this.children.keySet();
    }

    public ForeignKeyConstraint getChildConstraint(TableColumn child) {
        return this.children.get(child);
    }

    public boolean matches(Pattern regex) {
        return regex.matcher(this.getTable().getName() + '.' + this.getName()).matches();
    }

    public void update(TableColumnMeta colMeta) {
        String newComments = colMeta.getComments();
        if (newComments != null) {
            this.setComments(newComments);
        }
        if (!this.isPrimary() && colMeta.isPrimary()) {
            this.table.setPrimaryColumn(this);
        }
        this.allowImpliedParents = !colMeta.isImpliedParentsDisabled();
        this.allowImpliedChildren = !colMeta.isImpliedChildrenDisabled();
        this.isExcluded |= colMeta.isExcluded();
        this.isAllExcluded |= colMeta.isAllExcluded();
    }

    public String toString() {
        return this.getName();
    }

    public boolean allowsImpliedParents() {
        return this.allowImpliedParents;
    }

    public boolean allowsImpliedChildren() {
        return this.allowImpliedChildren;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnComparator
    implements Comparator<TableColumn> {
        private ColumnComparator() {
        }

        @Override
        public int compare(TableColumn column1, TableColumn column2) {
            int rc = column1.getTable().compareTo(column2.getTable());
            if (rc == 0) {
                rc = column1.getName().compareToIgnoreCase(column2.getName());
            }
            return rc;
        }
    }
}

