/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;

public class View
extends Table {
    private String viewSql;

    public View(Database db, String schema, String name, String remarks, String viewSql, Properties properties, Pattern excludeIndirectColumns, Pattern excludeColumns) throws SQLException {
        super(db, schema, name, remarks, properties, excludeIndirectColumns, excludeColumns);
        if (viewSql == null) {
            viewSql = this.fetchViewSql();
        }
        if (viewSql != null && viewSql.trim().length() > 0) {
            this.viewSql = viewSql;
        }
    }

    public boolean isView() {
        return true;
    }

    public String getViewSql() {
        return this.viewSql;
    }

    protected int fetchNumRows() {
        return 0;
    }

    /*
     * Loose catch block
     */
    private String fetchViewSql() throws SQLException {
        String selectViewSql = this.properties.getProperty("selectViewSql");
        if (selectViewSql == null) {
            return null;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.db.prepareStatement(selectViewSql, this.getName());
            rs = stmt.executeQuery();
            if (rs.next()) {
                try {
                    String string = rs.getString("view_definition");
                    return string;
                }
                catch (SQLException tryOldName) {
                    String string;
                    block14: {
                        string = rs.getString("text");
                        if (rs == null) break block14;
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    return string;
                }
            }
            String tryOldName = null;
            return tryOldName;
            {
                catch (SQLException sqlException) {
                    System.err.println(selectViewSql);
                    throw sqlException;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }
}

