/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.model.xml.TableColumnMeta;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMeta {
    private final String name;
    private final String comments;
    private final List<TableColumnMeta> columns = new ArrayList<TableColumnMeta>();
    private final String remoteSchema;
    private static final Logger logger = Logger.getLogger(TableMeta.class.getName());

    TableMeta(Node tableNode) {
        String tmp;
        NamedNodeMap attribs = tableNode.getAttributes();
        this.name = attribs.getNamedItem("name").getNodeValue();
        Node commentNode = attribs.getNamedItem("comments");
        this.comments = commentNode != null ? ((tmp = commentNode.getNodeValue().trim()).length() == 0 ? null : tmp) : null;
        Node remoteSchemaNode = attribs.getNamedItem("remoteSchema");
        this.remoteSchema = remoteSchemaNode != null ? remoteSchemaNode.getNodeValue().trim() : null;
        logger.fine("Found XML table metadata for " + this.name + " remoteSchema: " + this.remoteSchema + " comments: " + this.comments);
        NodeList columnNodes = ((Element)((Object)tableNode.getChildNodes())).getElementsByTagName("column");
        for (int i = 0; i < columnNodes.getLength(); ++i) {
            Node colNode = columnNodes.item(i);
            this.columns.add(new TableColumnMeta(colNode));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getComments() {
        return this.comments;
    }

    public List<TableColumnMeta> getColumns() {
        return this.columns;
    }

    public String getRemoteSchema() {
        return this.remoteSchema;
    }
}

