/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.DbSpecificConfig;

public class DbTypeSelectorModel
extends AbstractListModel
implements ComboBoxModel {
    private static final long serialVersionUID = 1L;
    private final List<DbSpecificConfig> dbConfigs = new ArrayList<DbSpecificConfig>();
    private Object selected;

    public DbTypeSelectorModel(String defaultType) {
        Pattern pattern = Pattern.compile(".*/" + defaultType);
        TreeSet<String> dbTypes = new TreeSet<String>(Config.getBuiltInDatabaseTypes(Config.getLoadedFromJar()));
        for (String dbType : dbTypes) {
            DbSpecificConfig config = new DbSpecificConfig(dbType);
            this.dbConfigs.add(config);
            if (!pattern.matcher(dbType).matches()) continue;
            this.setSelectedItem(config);
        }
        if (this.getSelectedItem() == null && this.dbConfigs.size() > 0) {
            this.setSelectedItem(this.dbConfigs.get(0));
        }
    }

    public Object getSelectedItem() {
        return this.selected;
    }

    public void setSelectedItem(Object anItem) {
        this.selected = anItem;
    }

    public Object getElementAt(int index) {
        return this.dbConfigs.get(index);
    }

    public int getSize() {
        return this.dbConfigs.size();
    }
}

