/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.schemaspy.ui.DbConfigTableModel;

public class DirectoryCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private final DbConfigTableModel model;
    private final JTextField dirField;
    private final JPanel editor;
    private File selectedDir;
    private int selectedRow;
    private int selectedColumn;

    public DirectoryCellEditor(final DbConfigTableModel model, File startingDir) {
        this.model = model;
        this.dirField = new JTextField();
        this.dirField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent evt) {
                model.setValueAt(new File(DirectoryCellEditor.this.dirField.getText()), DirectoryCellEditor.this.selectedRow, DirectoryCellEditor.this.selectedColumn);
            }

            public void removeUpdate(DocumentEvent evt) {
            }

            public void changedUpdate(DocumentEvent evt) {
                model.setValueAt(new File(DirectoryCellEditor.this.dirField.getText()), DirectoryCellEditor.this.selectedRow, DirectoryCellEditor.this.selectedColumn);
            }
        });
        this.dirField.setBorder(null);
        final JFileChooser dirSelector = new JFileChooser(startingDir);
        dirSelector.setFileSelectionMode(1);
        JButton browseButton = new JButton("...");
        browseButton.setPreferredSize(new Dimension(12, 12));
        browseButton.setMinimumSize(browseButton.getPreferredSize());
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                dirSelector.setCurrentDirectory(new File(DirectoryCellEditor.this.dirField.getText()));
                if (dirSelector.showOpenDialog((JButton)action.getSource()) == 0) {
                    DirectoryCellEditor.this.dirField.setText(dirSelector.getSelectedFile().getPath());
                }
            }
        });
        this.editor = new JPanel();
        this.editor.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.fill = 2;
        this.editor.add((Component)this.dirField, constraints);
        constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 0, 0, 1);
        this.editor.add((Component)browseButton, constraints);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.selectedRow = row;
        this.selectedColumn = column;
        this.selectedDir = (File)value;
        this.dirField.setText(this.selectedDir == null ? null : this.selectedDir.toString());
        this.editor.setToolTipText(this.model.getDescription(row));
        return this.editor;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Object getCellEditorValue() {
        return this.model.getValueAt(this.selectedRow, this.selectedColumn);
    }
}

