/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private final String lineSeparator = System.getProperty("line.separator");
    private final int MAX_LEVEL_LEN = 7;
    private static final String formatSpec = "HH:mm:ss.";
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<DateFormat> dateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat initialValue() {
            SimpleDateFormat formatter = new SimpleDateFormat(LogFormatter.formatSpec);
            return formatter;
        }
    };
    private static final ThreadLocal<Date> date = new ThreadLocal<Date>(){

        @Override
        public Date initialValue() {
            return new Date();
        }
    };

    public String format(LogRecord record) {
        StringBuilder buf = new StringBuilder(128);
        date.get().setTime(record.getMillis());
        buf.append(dateFormatter.get().format(date.get()));
        long frac = record.getMillis() % 1000L;
        buf.append(Long.toString(frac += 1000L).substring(1));
        buf.append(" ");
        StringBuilder level = new StringBuilder(record.getLevel().getLocalizedName());
        if (level.length() > 7) {
            level.setLength(7);
        }
        level.append(":");
        while (level.length() < 8) {
            level.append(' ');
        }
        buf.append((CharSequence)level);
        buf.append(" ");
        String name = record.getSourceClassName() != null ? record.getSourceClassName() : record.getLoggerName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < name.length() - 1) {
            name = name.substring(lastDot + 1);
        }
        buf.append(name);
        if (record.getSourceMethodName() != null) {
            buf.append('.');
            buf.append(record.getSourceMethodName());
        }
        buf.append(" - ");
        buf.append(this.formatMessage(record));
        buf.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter stacktrace = new StringWriter();
                record.getThrown().printStackTrace(new PrintWriter((Writer)stacktrace, true));
                buf.append(stacktrace.toString());
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return buf.toString();
    }
}

