/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import net.sourceforge.schemaspy.util.ConsolePasswordReader;

public class PasswordReader {
    private static PasswordReader instance;

    public static synchronized PasswordReader getInstance() {
        if (instance == null) {
            try {
                instance = new ConsolePasswordReader();
            }
            catch (Throwable exc) {
                instance = new PasswordReader();
            }
        }
        return instance;
    }

    protected PasswordReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char[] readPassword(String fmt, Object ... args) {
        char[] lineBuffer;
        InputStream in = System.in;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        boolean reading = true;
        Masker masker = new Masker(String.format(fmt, args));
        masker.start();
        try {
            block9: while (reading) {
                int ch = in.read();
                switch (ch) {
                    case -1: 
                    case 10: {
                        reading = false;
                        continue block9;
                    }
                    case 13: {
                        int c2 = in.read();
                        if (c2 != 10 && c2 != -1) {
                            if (!(in instanceof PushbackInputStream)) {
                                in = new PushbackInputStream(in);
                            }
                            ((PushbackInputStream)in).unread(c2);
                            continue block9;
                        }
                        reading = false;
                        continue block9;
                    }
                }
                if (--room < 0) {
                    buf = new char[offset + 128];
                    room = buf.length - offset - 1;
                    System.arraycopy(lineBuffer, 0, buf, 0, offset);
                    Arrays.fill(lineBuffer, ' ');
                    lineBuffer = buf;
                }
                buf[offset++] = (char)ch;
            }
        }
        catch (IOException exc) {
            throw new IOError((Throwable)exc);
        }
        finally {
            masker.stopMasking();
        }
        if (offset == 0) {
            return null;
        }
        char[] password = new char[offset];
        System.arraycopy(buf, 0, password, 0, offset);
        Arrays.fill(buf, ' ');
        return password;
    }

    public class IOError
    extends Error {
        private static final long serialVersionUID = 20100629L;

        public IOError(Throwable cause) {
            super(cause);
        }
    }

    private static class Masker
    extends Thread {
        private volatile boolean masking = true;
        private final String mask;

        public Masker(String prompt) {
            this.mask = "\r" + prompt + "     \b\b\b\b\b";
            this.setPriority(Thread.currentThread().getPriority() + 1);
        }

        public void run() {
            while (this.masking) {
                System.out.print(this.mask);
                try {
                    Masker.sleep(100L);
                }
                catch (InterruptedException iex) {
                    this.interrupt();
                    this.masking = false;
                }
            }
        }

        public void stopMasking() {
            this.masking = false;
        }
    }
}

