/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.Dot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotConnector
implements Comparable<DotConnector> {
    private final TableColumn parentColumn;
    private final Table parentTable;
    private final TableColumn childColumn;
    private final Table childTable;
    private final boolean implied;
    private final boolean bottomJustify;
    private String parentPort;
    private String childPort;

    public DotConnector(TableColumn parentColumn, TableColumn childColumn, boolean implied) {
        this.parentColumn = parentColumn;
        this.childColumn = childColumn;
        this.implied = implied;
        this.parentPort = parentColumn.getName();
        this.parentTable = parentColumn.getTable();
        this.childPort = childColumn.getName();
        this.childTable = childColumn.getTable();
        this.bottomJustify = !Dot.getInstance().supportsCenteredEastWestEdges();
    }

    public boolean pointsTo(Table possibleParentTable) {
        return possibleParentTable.equals(this.parentTable);
    }

    public boolean isImplied() {
        return this.implied;
    }

    public void connectToParentDetails() {
        this.parentPort = this.parentColumn.getName() + ".type";
    }

    public void connectToParentTitle() {
        this.parentPort = "elipses";
    }

    public void connectToChildTitle() {
        this.childPort = "elipses";
    }

    public String toString() {
        StringBuilder edge = new StringBuilder();
        edge.append("  \"");
        if (this.childTable.isRemote()) {
            edge.append(this.childTable.getSchema());
            edge.append('.');
        }
        edge.append(this.childTable.getName());
        edge.append("\":\"");
        edge.append(this.childPort);
        edge.append("\":");
        if (this.bottomJustify) {
            edge.append("s");
        }
        edge.append("w -> \"");
        if (this.parentTable.isRemote()) {
            edge.append(this.parentTable.getSchema());
            edge.append('.');
        }
        edge.append(this.parentTable.getName());
        edge.append("\":\"");
        edge.append(this.parentPort);
        edge.append("\":");
        if (this.bottomJustify) {
            edge.append("s");
        }
        edge.append("e ");
        boolean fullErNotation = false;
        edge.append("[arrowhead=none");
        edge.append(" dir=back");
        edge.append(" arrowtail=");
        if (this.childColumn.isUnique()) {
            edge.append("teeodot");
        } else {
            edge.append("crowodot");
        }
        if (this.implied) {
            edge.append(" style=dashed");
        }
        edge.append("];");
        return edge.toString();
    }

    @Override
    public int compareTo(DotConnector other) {
        int rc = this.childTable.compareTo(other.childTable);
        if (rc == 0) {
            rc = this.childColumn.getName().compareToIgnoreCase(other.childColumn.getName());
        }
        if (rc == 0) {
            rc = this.parentTable.compareTo(other.parentTable);
        }
        if (rc == 0) {
            rc = this.parentColumn.getName().compareToIgnoreCase(other.parentColumn.getName());
        }
        if (rc == 0 && this.implied != other.implied) {
            rc = this.implied ? 1 : -1;
        }
        return rc;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DotConnector)) {
            return false;
        }
        return this.compareTo((DotConnector)other) == 0;
    }

    public int hashCode() {
        int p = this.parentTable == null ? 0 : this.parentTable.getName().hashCode();
        int c = this.childTable == null ? 0 : this.childTable.getName().hashCode();
        return p << 16 & c;
    }

    public TableColumn getParentColumn() {
        return this.parentColumn;
    }

    public Table getParentTable() {
        return this.parentTable;
    }

    public TableColumn getChildColumn() {
        return this.childColumn;
    }

    public Table getChildTable() {
        return this.childTable;
    }
}

