/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.schemaspy.DbAnalyzer;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAnomaliesPage
extends HtmlFormatter {
    private static HtmlAnomaliesPage instance = new HtmlAnomaliesPage();

    private HtmlAnomaliesPage() {
    }

    public static HtmlAnomaliesPage getInstance() {
        return instance;
    }

    public void write(Database database, Collection<Table> tables, List<? extends ForeignKeyConstraint> impliedConstraints, boolean hasOrphans, LineWriter out) throws IOException {
        this.writeHeader(database, hasOrphans, out);
        this.writeImpliedConstraints(impliedConstraints, out);
        this.writeTablesWithoutIndexes(DbAnalyzer.getTablesWithoutIndexes(new HashSet<Table>(tables)), out);
        this.writeUniqueNullables(DbAnalyzer.getMustBeUniqueNullableColumns(new HashSet<Table>(tables)), out);
        this.writeTablesWithOneColumn(DbAnalyzer.getTablesWithOneColumn(tables), out);
        this.writeTablesWithIncrementingColumnNames(DbAnalyzer.getTablesWithIncrementingColumnNames(tables), out);
        this.writeDefaultNullStrings(DbAnalyzer.getDefaultNullStringColumns(new HashSet<Table>(tables)), out);
        this.writeFooter(out);
    }

    private void writeHeader(Database database, boolean hasOrphans, LineWriter html) throws IOException {
        this.writeHeader(database, null, "Anomalies", hasOrphans, html);
        html.writeln("<table width='100%'>");
        if (this.sourceForgeLogoEnabled()) {
            html.writeln("  <tr><td class='container' align='right' valign='top' colspan='2'><a href='http://sourceforge.net' target='_blank'><img src='http://sourceforge.net/sflogo.php?group_id=137197&amp;type=1' alt='SourceForge.net' border='0' height='31' width='88'></a></td></tr>");
        }
        html.writeln("<tr>");
        html.writeln("<td class='container'><b>Things that might not be 'quite right' about your schema:</b></td>");
        html.writeln("<td class='container' align='right'>");
        this.writeFeedMe(html);
        html.writeln("</td></tr></table>");
        html.writeln("<ul>");
    }

    private void writeImpliedConstraints(List<? extends ForeignKeyConstraint> impliedConstraints, LineWriter out) throws IOException {
        Table childTable;
        out.writeln("<li>");
        out.writeln("<b>Columns whose name and type imply a relationship to another table's primary key:</b>");
        int numDetected = 0;
        for (ForeignKeyConstraint foreignKeyConstraint : impliedConstraints) {
            childTable = foreignKeyConstraint.getChildTable();
            if (childTable.isView()) continue;
            ++numDetected;
        }
        if (numDetected > 0) {
            out.writeln("<table class='dataTable' border='1' rules='groups'>");
            out.writeln("<colgroup>");
            out.writeln("<colgroup>");
            out.writeln("<thead align='left'>");
            out.writeln("<tr>");
            out.writeln("  <th>Child Column</th>");
            out.writeln("  <th>Implied Parent Column</th>");
            out.writeln("</tr>");
            out.writeln("</thead>");
            out.writeln("<tbody>");
            for (ForeignKeyConstraint foreignKeyConstraint : impliedConstraints) {
                childTable = foreignKeyConstraint.getChildTable();
                if (childTable.isView()) continue;
                out.writeln(" <tr>");
                out.write("  <td class='detail'>");
                String tableName = childTable.getName();
                out.write("<a href='tables/");
                out.write(tableName);
                out.write(".html'>");
                out.write(tableName);
                out.write("</a>.");
                out.write(ForeignKeyConstraint.toString(foreignKeyConstraint.getChildColumns()));
                out.writeln("</td>");
                out.write("  <td class='detail'>");
                tableName = foreignKeyConstraint.getParentTable().getName();
                out.write("<a href='tables/");
                out.write(tableName);
                out.write(".html'>");
                out.write(tableName);
                out.write("</a>.");
                out.write(ForeignKeyConstraint.toString(foreignKeyConstraint.getParentColumns()));
                out.writeln("</td>");
                out.writeln(" </tr>");
            }
            out.writeln("</tbody>");
            out.writeln("</table>");
        }
        this.writeSummary(numDetected, out);
        out.writeln("<p></li>");
    }

    private void writeUniqueNullables(List<TableColumn> uniqueNullables, LineWriter out) throws IOException {
        out.writeln("<li>");
        out.writeln("<b>Columns that are flagged as both 'nullable' and 'must be unique':</b>");
        this.writeColumnBasedAnomaly(uniqueNullables, out);
        out.writeln("<p></li>");
    }

    private void writeTablesWithoutIndexes(List<Table> unindexedTables, LineWriter out) throws IOException {
        out.writeln("<li>");
        out.writeln("<b>Tables without indexes:</b>");
        if (!unindexedTables.isEmpty()) {
            out.writeln("<table class='dataTable' border='1' rules='groups'>");
            out.writeln("<colgroup>");
            if (this.displayNumRows) {
                out.writeln("<colgroup>");
            }
            out.writeln("<thead align='left'>");
            out.writeln("<tr>");
            out.write("  <th>Table</th>");
            if (this.displayNumRows) {
                out.write("<th>Rows</th>");
            }
            out.writeln();
            out.writeln("</tr>");
            out.writeln("</thead>");
            out.writeln("<tbody>");
            for (Table table : unindexedTables) {
                out.writeln(" <tr>");
                out.write("  <td class='detail'>");
                out.write("<a href='tables/");
                out.write(table.getName());
                out.write(".html'>");
                out.write(table.getName());
                out.write("</a>");
                out.writeln("</td>");
                if (this.displayNumRows) {
                    out.write("  <td class='detail' align='right'>");
                    if (!table.isView()) {
                        out.write(String.valueOf(NumberFormat.getIntegerInstance().format(table.getNumRows())));
                    }
                    out.writeln("</td>");
                }
                out.writeln(" </tr>");
            }
            out.writeln("</tbody>");
            out.writeln("</table>");
        }
        this.writeSummary(unindexedTables.size(), out);
        out.writeln("<p></li>");
    }

    private void writeTablesWithIncrementingColumnNames(List<Table> tables, LineWriter out) throws IOException {
        out.writeln("<li>");
        out.writeln("<b>Tables with incrementing column names, potentially indicating denormalization:</b>");
        if (!tables.isEmpty()) {
            out.writeln("<table class='dataTable' border='1' rules='groups'>");
            out.writeln("<thead align='left'>");
            out.writeln("<tr>");
            out.writeln("  <th>Table</th>");
            out.writeln("</tr>");
            out.writeln("</thead>");
            out.writeln("<tbody>");
            for (Table table : tables) {
                out.writeln(" <tr>");
                out.write("  <td class='detail'>");
                out.write("<a href='tables/");
                out.write(table.getName());
                out.write(".html'>");
                out.write(table.getName());
                out.write("</a>");
                out.writeln("</td>");
                out.writeln(" </tr>");
            }
            out.writeln("</tbody>");
            out.writeln("</table>");
        }
        this.writeSummary(tables.size(), out);
        out.writeln("<p></li>");
    }

    private void writeTablesWithOneColumn(List<Table> tables, LineWriter out) throws IOException {
        out.writeln("<li>");
        out.write("<b>Tables that contain a single column:</b>");
        if (!tables.isEmpty()) {
            out.writeln("<table class='dataTable' border='1' rules='groups'>");
            out.writeln("<colgroup>");
            out.writeln("<colgroup>");
            out.writeln("<thead align='left'>");
            out.writeln("<tr>");
            out.writeln("  <th>Table</th>");
            out.writeln("  <th>Column</th>");
            out.writeln("</tr>");
            out.writeln("</thead>");
            out.writeln("<tbody>");
            for (Table table : tables) {
                out.writeln(" <tr>");
                out.write("  <td class='detail'>");
                out.write("<a href='tables/");
                out.write(table.getName());
                out.write(".html'>");
                out.write(table.getName());
                out.write("</a></td><td class='detail'>");
                out.write(table.getColumns().get(0).toString());
                out.writeln("</td>");
                out.writeln(" </tr>");
            }
            out.writeln("</tbody>");
            out.writeln("</table>");
        }
        this.writeSummary(tables.size(), out);
        out.writeln("<p></li>");
    }

    private void writeDefaultNullStrings(List<TableColumn> uniqueNullables, LineWriter out) throws IOException {
        out.writeln("<li>");
        out.writeln("<b>Columns whose default value is the word 'NULL' or 'null', but the SQL NULL value may have been intended:</b>");
        this.writeColumnBasedAnomaly(uniqueNullables, out);
        out.writeln("<p></li>");
    }

    private void writeColumnBasedAnomaly(List<TableColumn> columns, LineWriter out) throws IOException {
        if (!columns.isEmpty()) {
            out.writeln("<table class='dataTable' border='1' rules='groups'>");
            out.writeln("<thead align='left'>");
            out.writeln("<tr>");
            out.writeln("  <th>Column</th>");
            out.writeln("</tr>");
            out.writeln("</thead>");
            out.writeln("<tbody>");
            for (TableColumn column : columns) {
                out.writeln(" <tr>");
                out.write("  <td class='detail'>");
                String tableName = column.getTable().getName();
                out.write("<a href='tables/");
                out.write(tableName);
                out.write(".html'>");
                out.write(tableName);
                out.write("</a>.");
                out.write(column.getName());
                out.writeln("</td>");
                out.writeln(" </tr>");
            }
            out.writeln("</tbody>");
            out.writeln("</table>");
        }
        this.writeSummary(columns.size(), out);
    }

    private void writeSummary(int numAnomalies, LineWriter out) throws IOException {
        switch (numAnomalies) {
            case 0: {
                out.write("<br>Anomaly not detected");
                break;
            }
            case 1: {
                out.write("1 instance of anomaly detected");
                break;
            }
            default: {
                out.write(numAnomalies + " instances of anomaly detected");
            }
        }
    }

    @Override
    protected void writeFooter(LineWriter out) throws IOException {
        out.writeln("</ul>");
        super.writeFooter(out);
    }

    @Override
    protected boolean isAnomaliesPage() {
        return true;
    }
}

