/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sourceforge.schemaspy.DbAnalyzer;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.HtmlEncoder;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlConstraintsPage
extends HtmlFormatter {
    private static HtmlConstraintsPage instance = new HtmlConstraintsPage();
    private int columnCounter;

    private HtmlConstraintsPage() {
    }

    public static HtmlConstraintsPage getInstance() {
        return instance;
    }

    public void write(Database database, List<ForeignKeyConstraint> constraints, Collection<Table> tables, boolean hasOrphans, LineWriter html) throws IOException {
        this.writeHeader(database, hasOrphans, html);
        this.writeForeignKeyConstraints(constraints, html);
        this.writeCheckConstraints(tables, html);
        this.writeFooter(html);
    }

    private void writeHeader(Database database, boolean hasOrphans, LineWriter html) throws IOException {
        this.writeHeader(database, null, "Constraints", hasOrphans, html);
        html.writeln("<div class='indent'>");
    }

    @Override
    protected void writeFooter(LineWriter html) throws IOException {
        html.writeln("</div>");
        super.writeFooter(html);
    }

    private void writeForeignKeyConstraints(List<ForeignKeyConstraint> constraints, LineWriter html) throws IOException {
        TreeSet<ForeignKeyConstraint> constraintsByName = new TreeSet<ForeignKeyConstraint>();
        constraintsByName.addAll(constraints);
        html.writeln("<table width='100%'>");
        html.writeln("<tr><td class='container' valign='bottom'><b>");
        html.write(String.valueOf(constraintsByName.size()));
        html.writeln(" Foreign Key Constraints:</b>");
        html.writeln("</td><td class='container' align='right'>");
        html.writeln("<table>");
        if (this.sourceForgeLogoEnabled()) {
            html.writeln("  <tr><td class='container' align='right' valign='top'><a href='http://sourceforge.net' target='_blank'><img src='http://sourceforge.net/sflogo.php?group_id=137197&amp;type=1' alt='SourceForge.net' border='0' height='31' width='88'></a></td></tr>");
        }
        html.writeln("<tr><td class='container'>");
        this.writeFeedMe(html);
        html.writeln("</td></tr></table>");
        html.writeln("</td></tr>");
        html.writeln("</table><br>");
        html.writeln("<table class='dataTable' border='1' rules='groups'>");
        html.writeln("<colgroup>");
        html.writeln("<colgroup>");
        html.writeln("<colgroup>");
        html.writeln("<colgroup>");
        html.writeln("<thead align='left'>");
        html.writeln("<tr>");
        html.writeln("  <th>Constraint Name</th>");
        html.writeln("  <th>Child Column</th>");
        html.writeln("  <th>Parent Column</th>");
        html.writeln("  <th>Delete Rule</th>");
        html.writeln("</tr>");
        html.writeln("</thead>");
        html.writeln("<tbody>");
        for (ForeignKeyConstraint constraint : constraintsByName) {
            this.writeForeignKeyConstraint(constraint, html);
        }
        if (constraints.size() == 0) {
            html.writeln(" <tr>");
            html.writeln("  <td class='detail' valign='top' colspan='4'>None detected</td>");
            html.writeln(" </tr>");
        }
        html.writeln("</tbody>");
        html.writeln("</table>");
    }

    private void writeForeignKeyConstraint(ForeignKeyConstraint constraint, LineWriter html) throws IOException {
        TableColumn column;
        boolean even;
        boolean bl = even = this.columnCounter++ % 2 == 0;
        if (even) {
            html.writeln("  <tr class='even'>");
        } else {
            html.writeln("  <tr class='odd'>");
        }
        html.write("  <td class='detail'>");
        html.write(constraint.getName());
        html.writeln("</td>");
        html.write("  <td class='detail'>");
        Iterator<TableColumn> iter = constraint.getChildColumns().iterator();
        while (iter.hasNext()) {
            column = iter.next();
            html.write("<a href='tables/");
            html.write(column.getTable().getName());
            html.write(".html'>");
            html.write(column.getTable().getName());
            html.write("</a>");
            html.write(".");
            html.write(column.getName());
            if (!iter.hasNext()) continue;
            html.write("<br>");
        }
        html.writeln("</td>");
        html.write("  <td class='detail'>");
        iter = constraint.getParentColumns().iterator();
        while (iter.hasNext()) {
            column = iter.next();
            html.write("<a href='tables/");
            html.write(column.getTable().getName());
            html.write(".html'>");
            html.write(column.getTable().getName());
            html.write("</a>");
            html.write(".");
            html.write(column.getName());
            if (!iter.hasNext()) continue;
            html.write("<br>");
        }
        html.writeln("</td>");
        html.write("  <td class='detail'>");
        String ruleText = constraint.getDeleteRuleDescription();
        String ruleName = constraint.getDeleteRuleName();
        html.write("<span title='" + ruleText + "'>" + ruleName + "&nbsp;</span>");
        html.writeln("</td>");
        html.writeln(" </tr>");
    }

    public void writeCheckConstraints(Collection<Table> tables, LineWriter html) throws IOException {
        html.writeln("<a name='checkConstraints'></a><p>");
        html.writeln("<b>Check Constraints:</b>");
        html.writeln("<TABLE class='dataTable' border='1' rules='groups'>");
        html.writeln("<colgroup>");
        html.writeln("<colgroup>");
        html.writeln("<colgroup>");
        html.writeln("<thead align='left'>");
        html.writeln("<tr>");
        html.writeln("  <th>Table</th>");
        html.writeln("  <th>Constraint Name</th>");
        html.writeln("  <th>Constraint</th>");
        html.writeln("</tr>");
        html.writeln("</thead>");
        html.writeln("<tbody>");
        List<Table> tablesByName = DbAnalyzer.sortTablesByName(new ArrayList<Table>(tables));
        int constraintsWritten = 0;
        for (Table table : tablesByName) {
            constraintsWritten += this.writeCheckConstraints(table, html);
        }
        if (constraintsWritten == 0) {
            html.writeln(" <tr>");
            html.writeln("  <td class='detail' valign='top' colspan='3'>None detected</td>");
            html.writeln(" </tr>");
        }
        html.writeln("</tbody>");
        html.writeln("</table>");
    }

    private int writeCheckConstraints(Table table, LineWriter html) throws IOException {
        Map<String, String> constraints = table.getCheckConstraints();
        int constraintsWritten = 0;
        for (String name : constraints.keySet()) {
            html.writeln(" <tr>");
            html.write("  <td class='detail' valign='top'><a href='tables/");
            html.write(table.getName());
            html.write(".html'>");
            html.write(table.getName());
            html.write("</a></td>");
            html.write("  <td class='detail' valign='top'>");
            html.write(name);
            html.writeln("</td>");
            html.write("  <td class='detail'>");
            html.write(HtmlEncoder.encodeString(constraints.get(name).toString()));
            html.writeln("</td>");
            html.writeln(" </tr>");
            ++constraintsWritten;
        }
        return constraintsWritten;
    }

    @Override
    protected boolean isConstraintsPage() {
        return true;
    }
}

