/*
 * Decompiled with CFR 0.152.
 */
package net.pizey.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.NoSuchElementException;

public class CsvFileParser {
    private BufferedReader reader = null;
    private int lineNo = 0;
    private String line = "";
    private boolean emptyLastField = false;
    private int position = 0;

    public CsvFileParser(BufferedReader reader) {
        this.reader = reader;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public boolean recordHasMoreFields() {
        return this.emptyLastField || this.position < this.line.length();
    }

    public String nextField() throws IOException {
        return this.nextToken(false);
    }

    private String nextToken(boolean inUnclosedQuotes) throws IOException {
        if (this.emptyLastField) {
            this.emptyLastField = false;
            return "";
        }
        if (this.position >= this.line.length()) {
            throw new NoSuchElementException("Line " + this.lineNo + ": Position " + this.position + ", line length " + this.line.length() + " (eof before end of token)");
        }
        if (this.line.charAt(this.position) == '\"') {
            ++this.position;
            inUnclosedQuotes = true;
        }
        if (inUnclosedQuotes) {
            int closingQuotePosition = this.line.indexOf("\",", this.position);
            if (closingQuotePosition == -1) {
                if (this.line.indexOf(34, this.position) == this.line.length() - 1) {
                    closingQuotePosition = this.line.length() - 1;
                } else {
                    String sofar = this.line.substring(this.position, this.line.length());
                    if (!this.hasNextRecord()) {
                        throw new IllegalArgumentException("Unclosed quoted field on line " + this.lineNo);
                    }
                    return sofar + "\n" + this.nextToken(inUnclosedQuotes);
                }
            }
            String it = this.line.substring(this.position, closingQuotePosition);
            if (closingQuotePosition + 1 < this.line.length() && closingQuotePosition + 1 == this.line.length() - 1) {
                this.emptyLastField = true;
            }
            this.position = closingQuotePosition + 2;
            return it;
        }
        int q = this.line.indexOf(44, this.position);
        if (q == -1) {
            String it = this.line.substring(this.position);
            this.position = this.line.length();
            return it;
        }
        String it = this.line.substring(this.position, q);
        if (q == this.line.length() - 1) {
            this.emptyLastField = true;
        }
        this.position = q + 1;
        return it;
    }

    public boolean hasNextRecord() throws IOException {
        this.line = this.reader.readLine();
        this.emptyLastField = false;
        this.position = 0;
        if (this.line == null) {
            return false;
        }
        ++this.lineNo;
        return true;
    }
}

