/*
 * Decompiled with CFR 0.152.
 */
package net.pizey.csv;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.pizey.csv.CsvColumn;
import net.pizey.csv.CsvField;
import net.pizey.csv.CsvInvalidKeyException;
import net.pizey.csv.CsvMissingPrimaryKeyException;
import net.pizey.csv.CsvRecordUnificationException;
import net.pizey.csv.CsvTable;

public class CsvRecord
implements Iterable<CsvField>,
Map<String, CsvField>,
Cloneable {
    private CsvTable table;
    private int lineNo;
    private HashMap<String, CsvField> nameToField;

    public CsvRecord(CsvTable table) {
        this.table = table;
        this.nameToField = new HashMap();
    }

    public synchronized void replaceField(CsvField oldField, CsvField newField) {
        this.nameToField.put(oldField.getColumn().getName(), newField);
    }

    public void unify(CsvRecord candidateRecord, boolean unifyWithEmpty) {
        for (CsvField candidateField : candidateRecord) {
            if (this.nameToField.containsKey(candidateField.getColumn().getName())) {
                CsvField currentField = this.nameToField.get(candidateField.getColumn().getName());
                if (currentField.getValue().equals("") && unifyWithEmpty) {
                    this.replaceField(currentField, candidateField);
                    continue;
                }
                if (currentField.getValue().equals(candidateField.getValue())) continue;
                throw new CsvRecordUnificationException(candidateRecord.getTable().getName(), candidateRecord.getLineNo(), currentField, candidateField);
            }
            if (!unifyWithEmpty) continue;
            this.getTable().addColumn(candidateField.getColumn());
            this.addField(candidateField);
        }
    }

    public CsvTable getTable() {
        return this.table;
    }

    public synchronized CsvField addField(CsvField field) {
        return this.nameToField.put(field.getColumn().getName(), field);
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    @Override
    public Iterator<CsvField> iterator() {
        Vector<CsvField> fieldsReversed = new Vector<CsvField>();
        for (CsvColumn column : this.getTable().getColumnsInOrder()) {
            fieldsReversed.add(this.nameToField.get(column.getName()));
        }
        return fieldsReversed.iterator();
    }

    @Override
    public CsvField get(Object string) {
        return this.nameToField.get(string);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.nameToField.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.nameToField.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, CsvField>> entrySet() {
        return this.nameToField.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.nameToField.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.nameToField.keySet();
    }

    @Override
    public CsvField put(String key, CsvField field) {
        if (!field.getColumn().getName().equals(key)) {
            throw new CsvInvalidKeyException("Key (" + key + ") not equal to " + "Field column name (" + field.getColumn().getName() + ")");
        }
        return this.addField(field);
    }

    @Override
    public void putAll(Map<? extends String, ? extends CsvField> m) {
        for (CsvField csvField : m.values()) {
            this.addField(csvField);
        }
    }

    @Override
    public CsvField remove(Object key) {
        return this.nameToField.remove(key);
    }

    @Override
    public int size() {
        return this.nameToField.size();
    }

    @Override
    public Collection<CsvField> values() {
        return this.nameToField.values();
    }

    public String toJSON() {
        String returnString = "";
        for (CsvField f : this) {
            if (!returnString.equals("")) {
                returnString = returnString + ",";
            }
            returnString = returnString + f.toString();
        }
        return "{" + returnString + "}";
    }

    public String toString() {
        String returnString = "";
        for (CsvField f : this) {
            if (!returnString.equals("")) {
                returnString = returnString + ",";
            }
            returnString = returnString + f.getValue();
        }
        return returnString;
    }

    public Object clone() {
        return this.clone(this.getTable());
    }

    public CsvRecord clone(CsvTable table) {
        CsvRecord newRecord = new CsvRecord(table);
        for (CsvField field : this) {
            newRecord.addField(field);
        }
        newRecord.setLineNo(this.lineNo);
        return newRecord;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lineNo;
        result = 31 * result + this.nameToField.hashCode();
        result = 31 * result + this.table.getName().hashCode();
        result = 31 * result + this.table.getColumnsInOrder().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CsvRecord other = (CsvRecord)obj;
        if (this.lineNo != other.lineNo) {
            return false;
        }
        if (!this.nameToField.equals(other.nameToField)) {
            return false;
        }
        if (!this.table.getName().equals(other.table.getName())) {
            return false;
        }
        return this.table.getColumnsInOrder().equals(other.getTable().getColumnsInOrder());
    }

    public String getPrimaryKey() {
        CsvColumn primaryKeyColumn = this.getTable().getPrimaryKeyColumn();
        CsvField f = this.get(primaryKeyColumn.getName());
        if (f == null) {
            throw new CsvMissingPrimaryKeyException();
        }
        return f.getValue();
    }
}

