/*
 * Decompiled with CFR 0.152.
 */
package net.pizey.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.pizey.csv.CsvBugException;
import net.pizey.csv.CsvColumn;
import net.pizey.csv.CsvDuplicateKeyException;
import net.pizey.csv.CsvField;
import net.pizey.csv.CsvFileParser;
import net.pizey.csv.CsvParseException;
import net.pizey.csv.CsvRecord;
import net.pizey.csv.CsvRecordNotFoundException;
import net.pizey.csv.UnificationOptions;

public class CsvTable
implements Map<String, CsvRecord>,
Iterable<CsvRecord> {
    private File dataFile = null;
    private String name;
    private UnificationOptions unificationOption;
    private HashMap<String, CsvColumn> nameToColumn;
    private ArrayList<CsvColumn> columnsInOrder;
    private CsvColumn primaryKeyColumn;
    private HashMap<String, CsvRecord> keyToRecord;
    private ArrayList<String> keys;
    private String primaryKeyName;

    public CsvTable(String fileName) {
        this(new File(fileName), null);
    }

    public CsvTable(String fileName, String primeKeyName) {
        this(new File(fileName), primeKeyName);
    }

    public CsvTable(String fileName, UnificationOptions unificationOption) {
        this(new File(fileName), null, unificationOption);
    }

    public CsvTable(String fileName, String primeKeyName, UnificationOptions unificationOption) {
        this(new File(fileName), primeKeyName, unificationOption);
    }

    public CsvTable(File file, String primeKeyName) {
        this(file, primeKeyName, UnificationOptions.THROW);
    }

    public CsvTable(File file, String primeKeyName, UnificationOptions unificationOption) {
        this.dataFile = file;
        this.name = CsvTable.removeExtension(file.getName());
        this.unificationOption = unificationOption;
        this.nameToColumn = new HashMap();
        this.columnsInOrder = new ArrayList();
        this.primaryKeyName = primeKeyName;
        this.primaryKeyColumn = null;
        this.keyToRecord = new HashMap();
        this.keys = new ArrayList();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.dataFile));
            this.load(new CsvFileParser(reader));
            reader.close();
        }
        catch (IOException e) {
            throw new CsvBugException("Unexpected exception", e);
        }
    }

    public CsvTable(CsvTable other) {
        this.dataFile = other.dataFile;
        this.name = other.getName();
        this.unificationOption = other.unificationOption;
        this.nameToColumn = new HashMap();
        for (Map.Entry<String, CsvColumn> e : other.nameToColumn.entrySet()) {
            this.nameToColumn.put(e.getKey(), e.getValue());
        }
        this.columnsInOrder = new ArrayList();
        for (CsvColumn c : other.columnsInOrder) {
            this.columnsInOrder.add(c);
        }
        this.primaryKeyColumn = other.primaryKeyColumn;
        this.keys = new ArrayList();
        this.keyToRecord = new HashMap();
        for (String key : other.keys) {
            this.keys.add(key);
            this.keyToRecord.put(key, other.get(key).clone(this));
        }
    }

    private void load(CsvFileParser parser) throws IOException {
        CsvRecord record;
        this.defineColumns(parser, this.primaryKeyName);
        while (null != (record = this.loadRecord(parser))) {
            this.add(record);
        }
    }

    private void defineColumns(CsvFileParser parser, String primeKeyName) throws IOException {
        parser.hasNextRecord();
        while (parser.recordHasMoreFields()) {
            String colName = parser.nextField();
            if (colName.equals("")) continue;
            boolean isPrimeKey = primeKeyName == null ? this.columnsInOrder.size() == 0 : colName.equals(this.primaryKeyName);
            CsvColumn column = new CsvColumn(colName, isPrimeKey);
            if (column.isPrimaryKey()) {
                this.primaryKeyColumn = column;
            }
            this.addColumn(column);
        }
    }

    public void addColumn(CsvColumn column) {
        this.columnsInOrder.add(column);
        this.nameToColumn.put(column.getName(), column);
        for (CsvRecord r : this) {
            r.put(column.getName(), new CsvField(column, ""));
        }
    }

    public String getName() {
        return this.name;
    }

    public CsvColumn getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public UnificationOptions getUnificationOption() {
        return this.unificationOption;
    }

    public HashMap<String, CsvColumn> getNameToColumn() {
        return this.nameToColumn;
    }

    public HashMap<String, CsvRecord> getKeyToRecord() {
        return this.keyToRecord;
    }

    public ArrayList<String> getKeys() {
        return this.keys;
    }

    public CsvRecord loadRecord(CsvFileParser parser) throws IOException {
        if (!parser.hasNextRecord()) {
            return null;
        }
        String value = null;
        CsvRecord record = new CsvRecord(this);
        for (int i = 0; i < this.columnsInOrder.size(); ++i) {
            try {
                value = parser.nextField();
            }
            catch (IllegalArgumentException e) {
                throw new CsvParseException("Failed to read data field no. " + (i + 1) + " in " + this.dataFile + " line " + parser.getLineNo(), e);
            }
            catch (NoSuchElementException f) {
                String message = "Problem with data field no. " + (i + 1) + " of " + this.columnsInOrder.size() + " in " + this.dataFile + " line " + parser.getLineNo();
                message = message + " (Check last line of file)";
                throw new CsvParseException(message, f);
            }
            CsvColumn col = this.columnsInOrder.get(i);
            record.addField(new CsvField(col, value));
        }
        record.setLineNo(parser.getLineNo());
        return record;
    }

    public CsvRecord addMissingFields(CsvRecord record) {
        CsvRecord csvRecord = new CsvRecord(this);
        csvRecord.addField(new CsvField(record.getTable().getPrimaryKeyColumn(), record.getPrimaryKey()));
        for (CsvColumn column : this.columnsInOrder) {
            if (column.getName().equals(record.getTable().getPrimaryKeyColumn().getName())) continue;
            csvRecord.addField(new CsvField(column, record.containsKey(column.getName()) ? record.get(column.getName()).getValue() : ""));
        }
        csvRecord.setLineNo(record.getLineNo());
        return csvRecord;
    }

    public CsvTable unify(CsvTable candidateTable, boolean unifyWithEmpty) {
        CsvTable unified = new CsvTable(this);
        for (CsvRecord candidateRecord : candidateTable.values()) {
            CsvRecord currentRecord = unified.get(candidateRecord.getPrimaryKey());
            if (currentRecord == null) {
                String message = "Record not found in " + unified.name + " with key equal " + candidateRecord.getPrimaryKey() + " from line " + candidateRecord.getLineNo() + " in file " + candidateTable.name;
                switch (this.unificationOption) {
                    case THROW: {
                        throw new CsvRecordNotFoundException(message);
                    }
                    case LOG: {
                        System.err.println(message);
                        break;
                    }
                    case DEFAULT: {
                        candidateRecord = unified.addMissingFields(candidateRecord);
                        unified.add(candidateRecord);
                    }
                }
                continue;
            }
            currentRecord.unify(candidateRecord, unifyWithEmpty);
        }
        return unified;
    }

    public void makeFirstAndPrimary(String columnName) {
        CsvColumn currentPrimaryKeyColumn = this.getPrimaryKeyColumn();
        currentPrimaryKeyColumn.setPrimaryKey(false);
        CsvColumn column = this.nameToColumn.get(columnName);
        column.setPrimaryKey(true);
        ArrayList<CsvColumn> newColumnsInOrder = new ArrayList<CsvColumn>();
        newColumnsInOrder.add(column);
        this.columnsInOrder.remove(column);
        for (CsvColumn existingColumn : this.columnsInOrder) {
            existingColumn.setPrimaryKey(false);
            newColumnsInOrder.add(existingColumn);
        }
        this.columnsInOrder = newColumnsInOrder;
        this.primaryKeyColumn = column;
        ArrayList<String> newKeys = new ArrayList<String>();
        HashMap<String, CsvRecord> reKeyed = new HashMap<String, CsvRecord>();
        for (String oldKey : this.keys) {
            CsvRecord r = this.keyToRecord.get(oldKey);
            String newKey = r.get(columnName).getValue();
            newKeys.add(newKey);
            reKeyed.put(newKey, r);
        }
        this.keys = newKeys;
        this.keyToRecord = reKeyed;
    }

    public static String removeExtension(String name) {
        return name.lastIndexOf(46) > -1 ? name.substring(0, name.lastIndexOf(46)) : name;
    }

    public void outputToFile(String outputFileName) throws IOException {
        FileOutputStream out = new FileOutputStream(outputFileName);
        PrintStream p = new PrintStream(out);
        p.println(this.toString());
        p.close();
    }

    public CsvColumn getColumn(String name) {
        return this.nameToColumn.get(name);
    }

    public ArrayList<CsvColumn> getColumnsInOrder() {
        return this.columnsInOrder;
    }

    public boolean hasColumn(String columnName) {
        return this.nameToColumn.containsKey(columnName);
    }

    public String toString() {
        StringBuffer returnStringBuffer = new StringBuffer();
        for (CsvColumn column : this.columnsInOrder) {
            returnStringBuffer.append(column.getName());
            returnStringBuffer.append(',');
        }
        returnStringBuffer.append("\n");
        for (String key : this.keys) {
            CsvRecord record = this.keyToRecord.get(key);
            returnStringBuffer.append(record.toString());
            returnStringBuffer.append(",\n");
        }
        return returnStringBuffer.toString();
    }

    @Override
    public void clear() {
        this.keys = new ArrayList();
        this.keyToRecord.clear();
    }

    @Override
    public CsvRecord get(Object key) {
        return this.keyToRecord.get(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.keyToRecord.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, CsvRecord>> entrySet() {
        return this.keyToRecord.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.keyToRecord.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.keyToRecord.keySet();
    }

    public void add(CsvRecord record) {
        this.put(record.getPrimaryKey(), record);
    }

    @Override
    public CsvRecord put(String key, CsvRecord record) {
        if (this.keys.contains(key)) {
            throw new CsvDuplicateKeyException(record.getLineNo(), key);
        }
        this.keys.add(key);
        return this.keyToRecord.put(key, this.addMissingFields(record));
    }

    @Override
    public void putAll(Map<? extends String, ? extends CsvRecord> m) {
        for (Map.Entry<? extends String, ? extends CsvRecord> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public CsvRecord remove(Object key) {
        this.keys.remove(key);
        return this.keyToRecord.remove(key);
    }

    @Override
    public int size() {
        return this.keyToRecord.size();
    }

    @Override
    public Collection<CsvRecord> values() {
        ArrayList<CsvRecord> records = new ArrayList<CsvRecord>();
        for (String key : this.keys) {
            records.add(this.keyToRecord.get(key));
        }
        return records;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToRecord.containsKey(key);
    }

    @Override
    public Iterator<CsvRecord> iterator() {
        ArrayList<CsvRecord> records = new ArrayList<CsvRecord>();
        for (String key : this.keys) {
            records.add(this.keyToRecord.get(key));
        }
        return records.iterator();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.columnsInOrder.hashCode();
        result = 31 * result + this.keyToRecord.hashCode();
        result = 31 * result + this.keys.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.primaryKeyColumn.hashCode();
        result = 31 * result + this.unificationOption.ordinal();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CsvTable other = (CsvTable)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.primaryKeyColumn.equals(other.primaryKeyColumn)) {
            return false;
        }
        if (!this.columnsInOrder.equals(other.columnsInOrder)) {
            return false;
        }
        if (!this.keys.equals(other.keys)) {
            return false;
        }
        if (!this.keyToRecord.equals(other.keyToRecord)) {
            return false;
        }
        return this.unificationOption.equals((Object)other.unificationOption);
    }
}

