/*
 * Decompiled with CFR 0.152.
 */
package org.cggh.casutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class CasProtectedResourceDownloader {
    static final String charSet = "UTF-8";
    private String username = "adam@example.org";
    private String password = "bar";
    private String ticketGrantingProtocol = "http://";
    private String ticketGrantingHostAndPort = "cloud1.cggh.org:80";
    private String ticketGrantingServiceUrl = this.ticketGrantingProtocol + this.ticketGrantingHostAndPort + "/sso/v1/tickets";
    private String tempFileDirectory = "/tmp/";
    private String tempUrlLocation = "file://" + this.tempFileDirectory;

    public CasProtectedResourceDownloader(String ticketGrantingProtocolIn, String ticketGrantingHostAndPortIn, String usernameIn, String passwordIn, String tempFileDirectoryIn) {
        this.ticketGrantingProtocol = ticketGrantingProtocolIn;
        this.ticketGrantingHostAndPort = ticketGrantingHostAndPortIn;
        this.ticketGrantingServiceUrl = this.ticketGrantingProtocol + this.ticketGrantingHostAndPort + "/sso/v1/tickets";
        this.username = usernameIn;
        this.password = passwordIn;
        this.tempFileDirectory = tempFileDirectoryIn;
        this.tempUrlLocation = "file://" + this.tempFileDirectory;
        System.err.println("ticketGrantingServiceUrl:" + this.ticketGrantingServiceUrl);
        System.err.println("usernameIn:" + usernameIn);
        System.err.println("passwordIn:" + passwordIn);
        System.err.println("tempFileDirectoryIn:" + tempFileDirectoryIn);
    }

    public String download(String uri) throws IOException {
        String name = uri.substring(uri.lastIndexOf(47) + 1);
        name = name.replace('?', '_');
        this.downloadUrlToFile(uri, new File(this.tempFileDirectory, name));
        String returnUrl = this.tempUrlLocation + name;
        return returnUrl;
    }

    private String ticketedUri(String uri) {
        String ticketedUri = uri;
        String ticket = CasProtectedResourceDownloader.getServiceTicket(this.ticketGrantingServiceUrl, this.username, this.password, uri);
        ticketedUri = uri.indexOf(63) > -1 ? ticketedUri + "&" : ticketedUri + "?";
        ticketedUri = ticketedUri + "ticket=" + ticket;
        return ticketedUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int downloadUrlToFile(String uri, File file) throws IOException {
        int status;
        block5: {
            System.err.println("Downloading uri " + uri + " to " + file);
            String ticketedUri = this.ticketedUri(uri);
            System.err.println("Ticketted uri: " + ticketedUri);
            GetMethod get = new GetMethod(ticketedUri);
            get.setRequestHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows 2000)");
            get.setFollowRedirects(true);
            HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            status = 0;
            try {
                client.executeMethod((HttpMethod)get);
                status = get.getStatusCode();
                if (status == 200) {
                    InputStream in = get.getResponseBodyAsStream();
                    FileOutputStream out = new FileOutputStream(file);
                    byte[] buffer = new byte[1024];
                    int count = -1;
                    while ((count = in.read(buffer)) != -1) {
                        out.write(buffer, 0, count);
                    }
                    out.flush();
                    out.close();
                    break block5;
                }
                String response = get.getResponseBodyAsString();
                throw new RuntimeException("Invalid response code (" + status + ") from server.\n" + "Response (first 1k): " + response.substring(0, Math.min(1024, response.length())));
            }
            finally {
                get.releaseConnection();
            }
        }
        return status;
    }

    private static String getServiceTicket(String casServerUrl, String username, String password, String service) {
        return CasProtectedResourceDownloader.getServiceTicket(casServerUrl, CasProtectedResourceDownloader.getTicketGrantingTicket(casServerUrl, username, password), service);
    }

    private static String getServiceTicket(String casServerUrl, String ticketGrantingTicket, String service) {
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(casServerUrl + "/" + ticketGrantingTicket);
        post.setRequestBody(new NameValuePair[]{new NameValuePair("service", service)});
        try {
            client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            if (post.getStatusCode() == 200) {
                String string = response;
                return string;
            }
            try {
                throw new RuntimeException("Invalid response code (" + post.getStatusCode() + ") from CAS server.\n" + "Response (first 1k): " + response.substring(0, Math.min(1024, response.length())));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getTicketGrantingTicket(String ticketGrantingServiceUrl, String username, String password) {
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(ticketGrantingServiceUrl);
        post.setRequestBody(new NameValuePair[]{new NameValuePair("username", username), new NameValuePair("password", password)});
        try {
            client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            if (post.getStatusCode() != 201) throw new RuntimeException("Invalid response code (" + post.getStatusCode() + ") from CAS server " + ticketGrantingServiceUrl + "\n" + "Response (first 1k): " + response.substring(0, Math.min(1024, response.length())));
            Matcher matcher = Pattern.compile(".*action=\".*/(.*?)\".*").matcher(response);
            if (matcher.matches()) {
                String string = matcher.group(1);
                return string;
            }
            try {
                throw new RuntimeException("Successful ticket granting request, but no ticket found.\nResponse (first 1k): " + response.substring(0, Math.min(1024, response.length())));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            post.releaseConnection();
        }
    }
}

