/*
 * Decompiled with CFR 0.152.
 */
package org.cggh.casutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.cggh.casutils.NotFoundException;

public class CasProtectedResourceDownloader {
    private static final int ONE_MINUTE = 60000;
    static final String charSet = "UTF-8";
    private String username = "adam@example.org";
    private String password = "bar";
    private String ticketGrantingProtocol = "http://";
    private String ticketGrantingHostAndPort = "cloud1.cggh.org:80";
    private String ticketGrantingServiceUrl = this.ticketGrantingProtocol + this.ticketGrantingHostAndPort + "/sso/v1/tickets";
    private String tempFileDirectory = "/tmp/";
    private String tempUrlLocation = "file://" + this.tempFileDirectory;

    public CasProtectedResourceDownloader(String ticketGrantingProtocolIn, String ticketGrantingHostAndPortIn, String usernameIn, String passwordIn, String tempFileDirectoryIn) {
        this.ticketGrantingProtocol = ticketGrantingProtocolIn;
        this.ticketGrantingHostAndPort = ticketGrantingHostAndPortIn;
        this.ticketGrantingServiceUrl = this.ticketGrantingProtocol + this.ticketGrantingHostAndPort + "/sso/v1/tickets";
        this.username = usernameIn;
        this.password = passwordIn;
        this.tempFileDirectory = tempFileDirectoryIn;
        this.tempUrlLocation = "file://" + this.tempFileDirectory;
        if (!this.tempUrlLocation.endsWith("/")) {
            this.tempUrlLocation = this.tempUrlLocation + "/";
        }
    }

    public String toString() {
        return super.toString() + " from:" + this.ticketGrantingServiceUrl + " to " + this.tempUrlLocation;
    }

    public String download(String uri) throws NotFoundException, IOException {
        String name = uri.substring(uri.lastIndexOf(47) + 1);
        name = name.replace('?', '_');
        this.downloadUrlToFile(uri, new File(this.tempFileDirectory, name));
        String returnUrl = this.tempUrlLocation + name;
        return returnUrl;
    }

    private String ticketedUri(String uri) throws IOException {
        String ticketedUri = uri;
        String ticket = CasProtectedResourceDownloader.getServiceTicket(this.ticketGrantingServiceUrl, this.username, this.password, uri);
        ticketedUri = uri.indexOf(63) > -1 ? ticketedUri + "&" : ticketedUri + "?";
        ticketedUri = ticketedUri + "ticket=" + ticket;
        return ticketedUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int downloadUrlToFile(String uri, File file) throws NotFoundException, IOException {
        int status;
        block6: {
            String ticketedUri = this.ticketedUri(uri);
            System.err.println("Downloading uri " + uri + " to " + file);
            GetMethod get = new GetMethod(ticketedUri);
            get.setRequestHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows 2000)");
            get.setFollowRedirects(true);
            MultiThreadedHttpConnectionManager hcm = new MultiThreadedHttpConnectionManager();
            hcm.getParams().setSoTimeout(60000);
            HttpClient client = new HttpClient((HttpConnectionManager)hcm);
            status = 0;
            try {
                client.executeMethod((HttpMethod)get);
                status = get.getStatusCode();
                if (status == 200) {
                    InputStream in = get.getResponseBodyAsStream();
                    FileOutputStream out = new FileOutputStream(file);
                    byte[] buffer = new byte[1024];
                    int count = -1;
                    while ((count = in.read(buffer)) != -1) {
                        out.write(buffer, 0, count);
                    }
                    out.flush();
                    out.close();
                    break block6;
                }
                if (status == 404) {
                    throw new NotFoundException("Uri " + uri + " not found.");
                }
                String response = get.getResponseBodyAsString();
                throw new RuntimeException("Invalid response code (" + status + ") from server.\n" + "Response (first 3k): " + response.substring(0, Math.min(3072, response.length())));
            }
            finally {
                get.releaseConnection();
            }
        }
        return status;
    }

    private static String getServiceTicket(String casServerUrl, String username, String password, String service) throws IOException {
        return CasProtectedResourceDownloader.getServiceTicket(casServerUrl, CasProtectedResourceDownloader.getTicketGrantingTicket(casServerUrl, username, password), service);
    }

    private static String getServiceTicket(String casServerUrl, String ticketGrantingTicket, String service) throws IOException {
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(casServerUrl + "/" + ticketGrantingTicket);
        post.setRequestBody(new NameValuePair[]{new NameValuePair("service", service)});
        try {
            client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            if (post.getStatusCode() == 200) {
                String string = response;
                return string;
            }
            throw new RuntimeException("Unexpected invalid response code (" + post.getStatusCode() + ") from CAS server. \n" + "Despite a ticket granting ticket having been issued by the server.\n" + "Response (first 1k): " + response.substring(0, Math.min(1024, response.length())));
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getTicketGrantingTicket(String ticketGrantingServiceUrl, String username, String password) {
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(ticketGrantingServiceUrl);
        post.setRequestBody(new NameValuePair[]{new NameValuePair("username", username), new NameValuePair("password", password)});
        try {
            client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            if (post.getStatusCode() != 201) throw new RuntimeException("Invalid response code (" + post.getStatusCode() + ") from CAS server " + ticketGrantingServiceUrl + "\n" + "Response (first 1k): " + response.substring(0, Math.min(1024, response.length())));
            Matcher matcher = Pattern.compile(".*action=\".*/(.*?)\".*").matcher(response);
            if (matcher.matches()) {
                String string = matcher.group(1);
                return string;
            }
            try {
                throw new RuntimeException("Unexpected missing action. Successful ticket granting request, but no ticket found.\nResponse (first 1k): " + response.substring(0, Math.min(1024, response.length())));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            post.releaseConnection();
        }
    }
}

