/*
 * $Source: /usr/cvsroot/melati/dsd-maven-plugin/src/main/java/org/melati/poem/prepro/HiddenTableException.java,v $
 * $Revision: 1.6 $
 *
 * Copyright (C) 2001 Myles Chippendale
 *
 * Part of Melati (http://melati.org), a framework for the rapid
 * development of clean, maintainable web applications.
 *
 * Melati is free software; Permission is granted to copy, distribute
 * and/or modify this software under the terms either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version,
 *
 *    or
 *
 * b) any version of the Melati Software License, as published
 *    at http://melati.org
 *
 * You should have received a copy of the GNU General Public License and
 * the Melati Software License along with this program;
 * if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA to obtain the
 * GNU General Public License and visit http://melati.org to obtain the
 * Melati Software License.
 *
 * Feel free to contact the Developers of Melati (http://melati.org),
 * if you would like to work out a different arrangement than the options
 * outlined here.  It is our intention to allow Melati to be used by as
 * wide an audience as possible.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Contact details for copyright holder:
 *
 *     Myles Chippendale <mylesc At paneris.org>
 *     http://paneris.org/
 *     29 Stanley Road, Oxford, UK
 */

package org.melati.poem.prepro;

/**
 * Thrown when a table is given a name which is already used in 
 * this or an imported DSD.
 *
 * Note that this exception is thrown if a table is referred to by the 
 * <tt>extends</tt> keyword before it is defined.
 * Room for improvement but not a pressing requirement.
 */
class HiddenTableException extends IllegalityException {
  private static final long serialVersionUID = 1L;

  String name;
  String table;

  HiddenTableException(String name, String table) {
    this.name = name;
    this.table = table;
    this.message = "You cannot name a table `" + name + "' unless it extends the " +
    "pre-existing table " + table + 
    "(Check that extended tables are defined before being referenced)"; 
  }

}
