/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.melati.poem.prepro.DSD;

public class MelatiDsdProcessorMojo
extends AbstractMojo {
    private String dsdPackage;
    private String dsdFile;
    private File sourceDirectory;
    private File testSourceDirectory;
    private String groupId;
    private String artifactId;
    private boolean checkUptodate;
    private boolean isMain = true;
    private String searchedLocations = "";

    public void execute() throws MojoExecutionException {
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        URL[] urls = ((URLClassLoader)sysClassLoader).getURLs();
        int i = 0;
        while (i < urls.length) {
            System.out.println(urls[i].getFile());
            ++i;
        }
        File f = null;
        f = this.isMain ? this.sourceDirectory : this.testSourceDirectory;
        if (f == null || !f.exists()) {
            throw new MojoExecutionException("Source directory (" + f + ")could not be found");
        }
        String dsdPath = null;
        if (this.dsdPackage != null) {
            String lookupDir = String.valueOf(f.getPath()) + "/" + this.dsdPackage.replace('.', '/') + "/";
            dsdPath = this.dsdFileName(lookupDir, this.dsdFile);
            if (dsdPath == null) {
                if (this.dsdFile != null) {
                    throw new MojoExecutionException("Configured DSD file " + lookupDir + this.dsdFile + " could not be found.");
                }
                throw new MojoExecutionException("DSD file could not be found on configured path " + this.dsdPackage + " in any of: \n" + this.searchedLocations + "Add an explicit dsdPackage and/or dsdFile parameter to your configuration.");
            }
        } else {
            String groupDir = this.groupId.replace('.', '/');
            String sourceDir = String.valueOf(f.getPath()) + "/" + groupDir + "/";
            String foundDsdName = this.existingDsdFileName(sourceDir, this.dsdFile);
            if (foundDsdName == null) {
                foundDsdName = this.existingDsdFileName(f + this.artifactId + "/", this.dsdFile);
            }
            if (foundDsdName == null) {
                throw new MojoExecutionException("DSD file could not be found in any of: \n" + this.searchedLocations + "Add an explicit dsdPackage and/or dsdFile parameter to your configuration.");
            }
            this.getLog().info((CharSequence)("Found DSD at " + foundDsdName + ":"));
            dsdPath = foundDsdName;
        }
        String modelDir = dsdPath.substring(0, dsdPath.lastIndexOf(47) + 1);
        String modelName = MelatiDsdProcessorMojo.capitalised(dsdPath.substring(dsdPath.lastIndexOf(47) + 1, dsdPath.lastIndexOf(46)));
        String databaseTablesFileName = String.valueOf(modelDir) + "generated/" + modelName + "DatabaseBase.java";
        File databaseTablesFile = new File(databaseTablesFileName);
        long dsdTimestamp = new File(dsdPath).lastModified();
        long databaseTablesTimestamp = 1L;
        if (databaseTablesFile.exists()) {
            databaseTablesTimestamp = databaseTablesFile.lastModified();
        }
        boolean doIt = true;
        if (this.checkUptodate) {
            this.getLog().info((CharSequence)(" Checking " + databaseTablesFileName));
            if (dsdTimestamp < databaseTablesTimestamp) {
                this.getLog().info((CharSequence)"Generated files are uptodate. No action required.");
                doIt = false;
            }
        } else {
            this.getLog().info((CharSequence)" Not checking - doing regardless");
        }
        if (doIt) {
            try {
                DSD dsd = new DSD(dsdPath);
                dsd.generateJava();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error processing DSD", e);
            }
        }
    }

    private String existingDsdFileName(String dir, String dsdFileName) {
        String modelDirName = String.valueOf(dir) + "poem/";
        File modelDir = new File(modelDirName);
        if (!modelDir.exists()) {
            this.searchedLocations = String.valueOf(this.searchedLocations) + " " + modelDirName + "\n";
            modelDirName = String.valueOf(dir) + "model/";
            modelDir = new File(modelDirName);
        }
        if (!modelDir.exists()) {
            this.searchedLocations = String.valueOf(this.searchedLocations) + " " + modelDirName + "\n";
            modelDirName = dir;
            modelDir = new File(modelDirName);
        }
        if (!modelDir.exists()) {
            this.searchedLocations = String.valueOf(this.searchedLocations) + " " + modelDirName + "\n";
            return null;
        }
        return this.dsdFileName(modelDirName, dsdFileName);
    }

    private String dsdFileName(String dir, String dsdFileName) {
        if (dsdFileName != null) {
            dsdFileName = String.valueOf(dir) + dsdFileName;
            File foundDsdFile = new File(dsdFileName);
            if (!foundDsdFile.exists()) {
                this.searchedLocations = String.valueOf(this.searchedLocations) + " " + dsdFileName + "\n";
                return null;
            }
        } else {
            dsdFileName = String.valueOf(dir) + this.artifactId + ".dsd";
            File foundDsdFile = new File(dsdFileName);
            if (!foundDsdFile.exists()) {
                this.searchedLocations = String.valueOf(this.searchedLocations) + " " + dsdFileName + "\n";
                dsdFileName = String.valueOf(dir) + MelatiDsdProcessorMojo.capitalised(this.artifactId) + ".dsd";
                foundDsdFile = new File(dsdFileName);
            }
            if (!foundDsdFile.exists()) {
                this.searchedLocations = String.valueOf(this.searchedLocations) + " " + dsdFileName + "\n";
                return null;
            }
        }
        return dsdFileName;
    }

    public static String capitalised(String name) {
        char[] suffix = name.toCharArray();
        suffix[0] = Character.toUpperCase(suffix[0]);
        return new String(suffix);
    }
}

